# generated by datamodel-codegen:
#   filename:  socialscience.json
#   timestamp: 2022-05-24T09:26:50+00:00

from __future__ import annotations

from typing import List, Optional

from easyDataverse.core import DataverseBase
from pydantic import Field


class Notes(DataverseBase):
    type: Optional[str] = Field(
        None,
        description='Type of note.',
        multiple=False,
        typeClass='primitive',
        typeName='socialScienceNotesType',
    )
    subject: Optional[str] = Field(
        None,
        description='Note subject.',
        multiple=False,
        typeClass='primitive',
        typeName='socialScienceNotesSubject',
    )
    text: Optional[str] = Field(
        None,
        description='Text for this note.',
        multiple=False,
        typeClass='primitive',
        typeName='socialScienceNotesText',
    )


class TargetSampleSize(DataverseBase):
    actual: Optional[int] = Field(
        None,
        description='Actual sample size.',
        multiple=False,
        typeClass='primitive',
        typeName='targetSampleActualSize',
    )
    formula: Optional[str] = Field(
        None,
        description='Formula used to determine target sample size.',
        multiple=False,
        typeClass='primitive',
        typeName='targetSampleSizeFormula',
    )


class Socialscience(DataverseBase):
    notes: List[Notes] = Field(
        default_factory=list,
        description='General notes about this Dataset.',
        multiple=False,
        typeClass='compound',
        typeName='socialScienceNotes',
    )
    unit_of_analysis: Optional[List] = Field(
        None,
        description="Basic unit of analysis or observation that this Dataset describes, such as individuals, families/households, groups, institutions/organizations, administrative units, and more. For information about the DDI's controlled vocabulary for this element, please refer to the DDI web page at http://www.ddialliance.org/controlled-vocabularies.",
        multiple=True,
        typeClass='primitive',
        typeName='unitOfAnalysis',
    )
    universe: Optional[List] = Field(
        None,
        description='Description of the population covered by the data in the file; the group of people or other elements that are the object of the study and to which the study results refer. Age, nationality, and residence commonly help to  delineate a given universe, but any number of other factors may be used, such as age limits, sex, marital status, race, ethnic group, nationality, income, veteran status, criminal convictions, and more. The universe may consist of elements other than persons, such as housing units, court cases, deaths, countries, and so on. In general, it should be possible to tell from the description of the universe whether a given individual or element is a member of the population under study. Also known as the universe of interest, population of interest, and target population.',
        multiple=True,
        typeClass='primitive',
        typeName='universe',
    )
    time_method: Optional[str] = Field(
        None,
        description='The time method or time dimension of the data collection, such as panel, cross-sectional, trend, time- series, or other.',
        multiple=False,
        typeClass='primitive',
        typeName='timeMethod',
    )
    data_collector: Optional[str] = Field(
        None,
        description='Individual, agency or organization responsible for  administering the questionnaire or interview or compiling the data.',
        multiple=False,
        typeClass='primitive',
        typeName='dataCollector',
    )
    collector_training: Optional[str] = Field(
        None,
        description='Type of training provided to the data collector',
        multiple=False,
        typeClass='primitive',
        typeName='collectorTraining',
    )
    frequency: Optional[str] = Field(
        None,
        description='If the data collected includes more than one point in time, indicate the frequency with which the data was collected; that is, monthly, quarterly, or other.',
        multiple=False,
        typeClass='primitive',
        typeName='frequencyOfDataCollection',
    )
    sampling_procedure: Optional[str] = Field(
        None,
        description='Type of sample and sample design used to select the survey respondents to represent the population. May include reference to the target sample size and the sampling fraction.',
        multiple=False,
        typeClass='primitive',
        typeName='samplingProcedure',
    )
    major_deviations_for_sample_design: Optional[str] = Field(
        None,
        description='Show correspondence as well as discrepancies between the sampled units (obtained) and available statistics for the population (age, sex-ratio, marital status, etc.) as a whole.',
        multiple=False,
        typeClass='primitive',
        typeName='deviationsFromSampleDesign',
    )
    collection_mode: Optional[List] = Field(
        None,
        description='Method used to collect the data; instrumentation characteristics (e.g., telephone interview, mail questionnaire, or other).',
        multiple=True,
        typeClass='primitive',
        typeName='collectionMode',
    )
    type_of_research_instrument: Optional[str] = Field(
        None,
        description='Type of data collection instrument used. Structured indicates an instrument in which all respondents are asked the same questions/tests, possibly with precoded answers. If a small portion of such a questionnaire includes open-ended questions, provide appropriate comments. Semi-structured indicates that the research instrument contains mainly open-ended questions. Unstructured indicates that in-depth interviews were conducted.',
        multiple=False,
        typeClass='primitive',
        typeName='researchInstrument',
    )
    characteristics_of_data_collection_situation: Optional[str] = Field(
        None,
        description='Description of noteworthy aspects of the data collection situation. Includes information on factors such as cooperativeness of respondents, duration of interviews, number of call backs, or similar.',
        multiple=False,
        typeClass='primitive',
        typeName='dataCollectionSituation',
    )
    actions_to_minimize_losses: Optional[str] = Field(
        None,
        description='Summary of actions taken to minimize data loss. Include information on actions such as follow-up visits, supervisory checks, historical matching, estimation, and so on.',
        multiple=False,
        typeClass='primitive',
        typeName='actionsToMinimizeLoss',
    )
    control_operations: Optional[str] = Field(
        None,
        description='Control OperationsMethods to facilitate data control performed by the primary investigator or by the data archive.',
        multiple=False,
        typeClass='primitive',
        typeName='controlOperations',
    )
    weighting: Optional[str] = Field(
        None,
        description='The use of sampling procedures might make it necessary to apply weights to produce accurate statistical results. Describes the criteria for using weights in analysis of a collection. If a weighting formula or coefficient was developed, the formula is provided, its elements are defined, and it is indicated how the formula was applied to the data.',
        multiple=False,
        typeClass='primitive',
        typeName='weighting',
    )
    cleaning_operations: Optional[str] = Field(
        None,
        description='Methods used to clean the data collection, such as consistency checking, wildcode checking, or other.',
        multiple=False,
        typeClass='primitive',
        typeName='cleaningOperations',
    )
    study_level_error_notes: Optional[str] = Field(
        None,
        description='Note element used for any information annotating or clarifying the methodology and processing of the study. ',
        multiple=False,
        typeClass='primitive',
        typeName='datasetLevelErrorNotes',
    )
    response_rate: Optional[str] = Field(
        None,
        description='Percentage of sample members who provided information.',
        multiple=False,
        typeClass='primitive',
        typeName='responseRate',
    )
    estimates_of_sampling_error: Optional[str] = Field(
        None,
        description='Measure of how precisely one can estimate a population value from a given sample.',
        multiple=False,
        typeClass='primitive',
        typeName='samplingErrorEstimates',
    )
    other_forms_of_data_appraisal: Optional[str] = Field(
        None,
        description='Other issues pertaining to the data appraisal. Describe issues such as response variance, nonresponse rate  and testing for bias, interviewer and response bias, confidence levels, question bias, or similar.',
        multiple=False,
        typeClass='primitive',
        typeName='otherDataAppraisal',
    )
    target_sample_size: List[TargetSampleSize] = Field(
        default_factory=list,
        description='Specific information regarding the target sample size, actual  sample size, and the formula used to determine this.',
        multiple=False,
        typeClass='compound',
        typeName='targetSampleSize',
    )
    _metadatablock_name: Optional[str] = 'socialscience'


    def add_notes(
        self,
        type: Optional[str] = None,
        subject: Optional[str] = None,
        text: Optional[str] = None,
    ):
        """Function used to add an instance of Notes to the metadatablock.

        Args:
        
            type (string): Type of note.
            subject (string): Note subject.
            text (string): Text for this note.

        """

        self.notes.append(
            Notes(
                type=type, subject=subject, text=text
            )
        )


    def add_target_sample_size(
        self,
        actual: Optional[int] = None,
        formula: Optional[str] = None,
    ):
        """Function used to add an instance of TargetSampleSize to the metadatablock.

        Args:
        
            actual (integer): Actual sample size.
            formula (string): Formula used to determine target sample size.

        """

        self.target_sample_size.append(
            TargetSampleSize(
                actual=actual, formula=formula
            )
        )
