# Generated by Django 4.0.2 on 2022-06-20 08:23

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='DiscordManagedServer',
            fields=[
                ('guild_id', models.BigIntegerField(
                    help_text='Guild ID on Discord', primary_key=True, serialize=False)),
                ('server_name', models.CharField(blank=True, db_index=True,
                 default='', help_text='Server Name', max_length=32)),
                ('sync_names', models.BooleanField(default=False,
                 help_text='Sync Auth Main Name to Discord.')),
            ],
            options={
                'permissions': (('access_discord_multiverse', 'Can access the Discord Multiverse services'),),
            },
        ),
        migrations.CreateModel(
            name='MultiDiscordUser',
            fields=[
                ('id', models.AutoField(auto_created=True,
                 primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.BigIntegerField(
                    db_index=True, help_text="user's ID on Discord")),
                ('username', models.CharField(blank=True, db_index=True, default='',
                 help_text="user's username on Discord", max_length=32)),
                ('discriminator', models.CharField(blank=True, default='',
                 help_text="user's discriminator on Discord", max_length=4)),
                ('activated', models.DateTimeField(blank=True, default=None,
                 help_text='Date & time this service account was activated', null=True)),
                ('guild', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                 to='aadiscordmultiverse.discordmanagedserver')),
                ('user', models.ForeignKey(help_text='Auth user owning this Discord account',
                 on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
