/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.Comparator;
import net.sourceforge.plantuml.BackSlash;
import net.sourceforge.plantuml.BasicEnsureVisible;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.DotMaker2;

public class Url
implements EnsureVisible {
    private final String url;
    private final String tooltip;
    private final String label;
    private boolean member;
    private final BasicEnsureVisible visible = new BasicEnsureVisible();
    public static final Comparator<Url> SURFACE_COMPARATOR = new Comparator<Url>(){

        @Override
        public int compare(Url url1, Url url2) {
            double surface2;
            double surface1 = url1.visible.getSurface();
            if (surface1 > (surface2 = url2.visible.getSurface())) {
                return 1;
            }
            if (surface1 < surface2) {
                return -1;
            }
            return 0;
        }
    };

    public Url(String url, String tooltip) {
        this(url, tooltip, null);
    }

    public Url(String url, String tooltip, String label) {
        this.url = url = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(url, "\"");
        this.tooltip = tooltip == null ? url : BackSlash.manageNewLine(tooltip);
        this.label = label == null || label.length() == 0 ? url : label;
    }

    public static boolean isLatex(String pendingUrl) {
        return pendingUrl.startsWith("latex://");
    }

    public boolean isLatex() {
        return Url.isLatex(this.url);
    }

    public final String getUrl() {
        return this.url;
    }

    public final String getTooltip() {
        return this.tooltip;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return super.toString() + " " + this.url + " " + this.visible.getCoords(1.0);
    }

    public String getCoords(double scale) {
        if (DotMaker2.isJunit() && this.visible.getCoords(1.0).contains("0,0,0,0")) {
            throw new IllegalStateException(this.toString());
        }
        return this.visible.getCoords(scale);
    }

    public void setMember(boolean member) {
        this.member = member;
    }

    public final boolean isMember() {
        return this.member;
    }

    @Override
    public void ensureVisible(double x, double y) {
        this.visible.ensureVisible(x, y);
    }

    public boolean hasData() {
        return this.visible.hasData();
    }
}

