#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['poliastro',
 'poliastro.atmosphere',
 'poliastro.constants',
 'poliastro.core',
 'poliastro.core.propagation',
 'poliastro.core.thrust',
 'poliastro.czml',
 'poliastro.frames',
 'poliastro.iod',
 'poliastro.neos',
 'poliastro.plotting',
 'poliastro.threebody',
 'poliastro.twobody',
 'poliastro.twobody.thrust']

package_data = \
{'': ['*'], 'poliastro.atmosphere': ['data/*']}

package_dir = \
{'': 'src'}

install_requires = \
['astropy >=3.2,<5',
 'astroquery >=0.3.9',
 'jplephem',
 'matplotlib >=2.0,!=3.0.1',
 'numpy',
 'pandas',
 'plotly ~=4.0',
 'scipy >=1.4.0']

extras_require = \
{":implementation_name=='cpython'": ['numba >=0.46,!=0.49.0 '],
 ":python_version<'3.8'": ['cached_property '],
 'cesium': ['czml3 ~=0.5.3'],
 'dev': ['black',
         'coverage',
         'hypothesis',
         'ipykernel',
         'ipython>=5.0',
         'ipywidgets>=7.0',
         'isort',
         'jupyter-client',
         'mypy>=0.740',
         'nbsphinx>=0.5.0',
         'nbconvert>=5.5',
         'pycodestyle',
         'pytest>=3.2',
         'pytest-cov<2.6.0',
         'pytest-doctestplus',
         'pytest-mpl',
         'pytest-mypy',
         'pytest-remotedata',
         'sphinx',
         'sphinx_rtd_theme @ '
         'https://github.com/Juanlu001/sphinx_rtd_theme/archive/avoid-require-redefinition.zip',
         'sphinx-hoverxref @ '
         'https://github.com/readthedocs/sphinx-hoverxref/archive/master.zip',
         'sphinx-notfound-page',
         'tox'],
 'jupyter': ['notebook']}

entry_points = \
{'console_scripts': ['poliastro = poliastro.cli:main']}

setup(name='poliastro',
      version='0.14b1',
      description='=========',
      author='Juan Luis Cano Rodríguez',
      author_email='hello@juanlu.space',
      url='https://github.com/poliastro/poliastro/',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.6,<3.9',
     )
