# Generated by Django 5.0.9 on 2024-10-09 14:19

import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import pgtrigger.compiler
import pgtrigger.migrations
from django.conf import settings
from django.db import migrations, models

import baseapp_comments.models
import baseapp_comments.validators
import baseapp_reactions.models
import baseapp_reports.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("pghistory", "0006_delete_aggregateevent"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        migrations.swappable_dependency(settings.BASEAPP_PROFILES_PROFILE_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Comment",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                (
                    "reports_count",
                    models.JSONField(default=baseapp_reports.models.default_reports_count),
                ),
                (
                    "reactions_count",
                    models.JSONField(
                        default=baseapp_reactions.models.default_reactions_count, editable=False
                    ),
                ),
                ("is_reactions_enabled", models.BooleanField(default=True)),
                (
                    "comments_count",
                    models.JSONField(
                        default=baseapp_comments.models.default_comments_count,
                        editable=False,
                        verbose_name="comments count",
                    ),
                ),
                (
                    "is_comments_enabled",
                    models.BooleanField(default=True, verbose_name="is comments enabled"),
                ),
                (
                    "body",
                    models.TextField(
                        blank=True,
                        null=True,
                        validators=[baseapp_comments.validators.blocked_words_validator],
                        verbose_name="body",
                    ),
                ),
                (
                    "language",
                    models.CharField(
                        blank=True,
                        help_text="languaged used in the comment",
                        max_length=10,
                        null=True,
                        verbose_name="language",
                    ),
                ),
                ("is_edited", models.BooleanField(default=False, verbose_name="is edited")),
                ("is_pinned", models.BooleanField(default=False, verbose_name="is pinned")),
                (
                    "target_object_id",
                    models.PositiveIntegerField(
                        blank=True, db_index=True, null=True, verbose_name="target object id"
                    ),
                ),
                (
                    "status",
                    models.IntegerField(
                        choices=[(0, "deleted"), (1, "published")],
                        db_index=True,
                        default=1,
                        verbose_name="status",
                    ),
                ),
                (
                    "in_reply_to",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="comments",
                        to=settings.BASEAPP_COMMENTS_COMMENT_MODEL,
                        verbose_name="in reply to",
                    ),
                ),
                (
                    "profile",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="comments",
                        to=settings.BASEAPP_PROFILES_PROFILE_MODEL,
                        verbose_name="profile",
                    ),
                ),
                (
                    "target_content_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="comments_inbox",
                        to="contenttypes.contenttype",
                        verbose_name="target content type",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="comments",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="user",
                    ),
                ),
            ],
            options={
                "verbose_name": "comment",
                "verbose_name_plural": "comments",
                "ordering": ["-is_pinned", "-created"],
                "permissions": [
                    ("pin_comment", "can pin comments"),
                    ("report_comment", "can report comments"),
                    ("view_all_comments", "can view all comments"),
                    ("add_comment_with_profile", "can add comments with profile"),
                ],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="CommentEvent",
            fields=[
                ("pgh_id", models.AutoField(primary_key=True, serialize=False)),
                ("pgh_created_at", models.DateTimeField(auto_now_add=True)),
                ("pgh_label", models.TextField(help_text="The event label.")),
                ("id", models.IntegerField()),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "reports_count",
                    models.JSONField(default=baseapp_reports.models.default_reports_count),
                ),
                ("is_reactions_enabled", models.BooleanField(default=True)),
                (
                    "is_comments_enabled",
                    models.BooleanField(default=True, verbose_name="is comments enabled"),
                ),
                (
                    "body",
                    models.TextField(
                        blank=True,
                        null=True,
                        validators=[baseapp_comments.validators.blocked_words_validator],
                        verbose_name="body",
                    ),
                ),
                (
                    "language",
                    models.CharField(
                        blank=True,
                        help_text="languaged used in the comment",
                        max_length=10,
                        null=True,
                        verbose_name="language",
                    ),
                ),
                ("is_edited", models.BooleanField(default=False, verbose_name="is edited")),
                ("is_pinned", models.BooleanField(default=False, verbose_name="is pinned")),
                (
                    "target_object_id",
                    models.PositiveIntegerField(
                        blank=True, null=True, verbose_name="target object id"
                    ),
                ),
                (
                    "status",
                    models.IntegerField(
                        choices=[(0, "deleted"), (1, "published")], default=1, verbose_name="status"
                    ),
                ),
                (
                    "in_reply_to",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        related_query_name="+",
                        to=settings.BASEAPP_COMMENTS_COMMENT_MODEL,
                        verbose_name="in reply to",
                    ),
                ),
                (
                    "pgh_context",
                    models.ForeignKey(
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="pghistory.context",
                    ),
                ),
                (
                    "pgh_obj",
                    models.ForeignKey(
                        db_constraint=False,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="events",
                        to=settings.BASEAPP_COMMENTS_COMMENT_MODEL,
                    ),
                ),
                (
                    "profile",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        related_query_name="+",
                        to=settings.BASEAPP_PROFILES_PROFILE_MODEL,
                        verbose_name="profile",
                    ),
                ),
                (
                    "target_content_type",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        related_query_name="+",
                        to="contenttypes.contenttype",
                        verbose_name="target content type",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        related_query_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="user",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddIndex(
            model_name="comment",
            index=models.Index(
                fields=[
                    "target_content_type",
                    "target_object_id",
                    "status",
                    "-is_pinned",
                    "-created",
                ],
                name="comments_co_target__9b7cc1_idx",
            ),
        ),
        pgtrigger.migrations.AddTrigger(
            model_name="comment",
            trigger=pgtrigger.compiler.Trigger(
                name="soft_delete",
                sql=pgtrigger.compiler.UpsertTriggerSql(
                    func='UPDATE "comments_comment" SET status = 0 WHERE "id" = OLD."id"; RETURN NULL;',
                    hash="076534cbdf4a4da2954da23d5469509710724ba5",
                    operation="DELETE",
                    pgid="pgtrigger_soft_delete_1316e",
                    table="comments_comment",
                    when="BEFORE",
                ),
            ),
        ),
        pgtrigger.migrations.AddTrigger(
            model_name="comment",
            trigger=pgtrigger.compiler.Trigger(
                name="insert_insert",
                sql=pgtrigger.compiler.UpsertTriggerSql(
                    func='INSERT INTO "comments_commentevent" ("body", "created", "id", "in_reply_to_id", "is_comments_enabled", "is_edited", "is_pinned", "is_reactions_enabled", "language", "pgh_context_id", "pgh_created_at", "pgh_label", "pgh_obj_id", "profile_id", "reports_count", "status", "target_content_type_id", "target_object_id", "user_id") VALUES (NEW."body", NEW."created", NEW."id", NEW."in_reply_to_id", NEW."is_comments_enabled", NEW."is_edited", NEW."is_pinned", NEW."is_reactions_enabled", NEW."language", _pgh_attach_context(), NOW(), \'insert\', NEW."id", NEW."profile_id", NEW."reports_count", NEW."status", NEW."target_content_type_id", NEW."target_object_id", NEW."user_id"); RETURN NULL;',
                    hash="459d8ae7b0bd11ea045b5ffce390a282a4793073",
                    operation="INSERT",
                    pgid="pgtrigger_insert_insert_18fd9",
                    table="comments_comment",
                    when="AFTER",
                ),
            ),
        ),
        pgtrigger.migrations.AddTrigger(
            model_name="comment",
            trigger=pgtrigger.compiler.Trigger(
                name="update_update",
                sql=pgtrigger.compiler.UpsertTriggerSql(
                    condition='WHEN (OLD."body" IS DISTINCT FROM (NEW."body") OR OLD."created" IS DISTINCT FROM (NEW."created") OR OLD."id" IS DISTINCT FROM (NEW."id") OR OLD."in_reply_to_id" IS DISTINCT FROM (NEW."in_reply_to_id") OR OLD."is_comments_enabled" IS DISTINCT FROM (NEW."is_comments_enabled") OR OLD."is_edited" IS DISTINCT FROM (NEW."is_edited") OR OLD."is_pinned" IS DISTINCT FROM (NEW."is_pinned") OR OLD."is_reactions_enabled" IS DISTINCT FROM (NEW."is_reactions_enabled") OR OLD."language" IS DISTINCT FROM (NEW."language") OR OLD."profile_id" IS DISTINCT FROM (NEW."profile_id") OR OLD."reports_count" IS DISTINCT FROM (NEW."reports_count") OR OLD."status" IS DISTINCT FROM (NEW."status") OR OLD."target_content_type_id" IS DISTINCT FROM (NEW."target_content_type_id") OR OLD."target_object_id" IS DISTINCT FROM (NEW."target_object_id") OR OLD."user_id" IS DISTINCT FROM (NEW."user_id"))',
                    func='INSERT INTO "comments_commentevent" ("body", "created", "id", "in_reply_to_id", "is_comments_enabled", "is_edited", "is_pinned", "is_reactions_enabled", "language", "pgh_context_id", "pgh_created_at", "pgh_label", "pgh_obj_id", "profile_id", "reports_count", "status", "target_content_type_id", "target_object_id", "user_id") VALUES (NEW."body", NEW."created", NEW."id", NEW."in_reply_to_id", NEW."is_comments_enabled", NEW."is_edited", NEW."is_pinned", NEW."is_reactions_enabled", NEW."language", _pgh_attach_context(), NOW(), \'update\', NEW."id", NEW."profile_id", NEW."reports_count", NEW."status", NEW."target_content_type_id", NEW."target_object_id", NEW."user_id"); RETURN NULL;',
                    hash="f7ef5fa58c40d65fecdd8df60b31fa66ffef0744",
                    operation="UPDATE",
                    pgid="pgtrigger_update_update_230ec",
                    table="comments_comment",
                    when="AFTER",
                ),
            ),
        ),
        pgtrigger.migrations.AddTrigger(
            model_name="comment",
            trigger=pgtrigger.compiler.Trigger(
                name="delete_delete",
                sql=pgtrigger.compiler.UpsertTriggerSql(
                    func='INSERT INTO "comments_commentevent" ("body", "created", "id", "in_reply_to_id", "is_comments_enabled", "is_edited", "is_pinned", "is_reactions_enabled", "language", "pgh_context_id", "pgh_created_at", "pgh_label", "pgh_obj_id", "profile_id", "reports_count", "status", "target_content_type_id", "target_object_id", "user_id") VALUES (OLD."body", OLD."created", OLD."id", OLD."in_reply_to_id", OLD."is_comments_enabled", OLD."is_edited", OLD."is_pinned", OLD."is_reactions_enabled", OLD."language", _pgh_attach_context(), NOW(), \'delete\', OLD."id", OLD."profile_id", OLD."reports_count", OLD."status", OLD."target_content_type_id", OLD."target_object_id", OLD."user_id"); RETURN NULL;',
                    hash="7de476c9f7d91713afcbf1edff16cbe4cea97c8d",
                    operation="DELETE",
                    pgid="pgtrigger_delete_delete_ff62f",
                    table="comments_comment",
                    when="AFTER",
                ),
            ),
        ),
    ]
