import sys

sys.path.append("/home/navi/CODE/RAE-sdk-python/ml_models")

from ra_engine.ml.regression import (
    Linear,
    GradientBoosting,
    RandomForest,
    ANN,
    Logistic,
)
from ra_engine.type_def.creds import Credentials
from ra_engine.type_def.ml import TrainData, PredData
from ra_engine.core.app import RAEApp
import pandas as pd

creds = {
    "host": "http://localhost:8000",
    "email": "navi@gmail.com",
    "password": "abc12345",
}

c = Credentials(**creds)

rae = RAEApp(c)
rae.init()


df_train = pd.DataFrame(
    {
        "R&D Spend": {
            "0": 165349.2,
            "1": 162597.7,
            "2": 153441.51,
            "3": 144372.41,
            "4": 142107.34,
            "5": 131876.9,
            "6": 134615.46,
            "7": 130298.13,
            "8": 120542.52,
            "9": 123334.88,
            "10": 101913.08,
            "11": 100671.96,
            "12": 93863.75,
            "13": 91992.39,
            "14": 119943.24,
            "15": 114523.61,
            "16": 78013.11,
            "17": 94657.16,
            "18": 91749.16,
            "19": 86419.7,
            "20": 76253.86,
            "21": 78389.47,
            "22": 73994.56,
            "23": 67532.53,
            "24": 77044.01,
            "25": 64664.71,
            "26": 75328.87,
            "27": 72107.6,
            "28": 66051.52,
            "29": 65605.48,
            "30": 61994.48,
            "31": 61136.38,
            "32": 63408.86,
            "33": 55493.95,
            "34": 46426.07,
            "35": 46014.02,
            "36": 28663.76,
            "37": 44069.95,
            "38": 20229.59,
            "39": 38558.51,
            "40": 28754.33,
            "41": 27892.92,
            "42": 23640.93,
            "43": 15505.73,
            "44": 22177.74,
            "45": 1000.23,
            "46": 1315.46,
            "47": 0.0,
            "48": 542.05,
            "49": 0.0,
        },
        "Administration Spend": {
            "0": 136897.8,
            "1": 151377.59,
            "2": 101145.55,
            "3": 118671.85,
            "4": 91391.77,
            "5": 99814.71,
            "6": 147198.87,
            "7": 145530.06,
            "8": 148718.95,
            "9": 108679.17,
            "10": 110594.11,
            "11": 91790.61,
            "12": 127320.38,
            "13": 135495.07,
            "14": 156547.42,
            "15": 122616.84,
            "16": 121597.55,
            "17": 145077.58,
            "18": 114175.79,
            "19": 153514.11,
            "20": 113867.3,
            "21": 153773.43,
            "22": 122782.75,
            "23": 105751.03,
            "24": 99281.34,
            "25": 139553.16,
            "26": 144135.98,
            "27": 127864.55,
            "28": 182645.56,
            "29": 153032.06,
            "30": 115641.28,
            "31": 152701.92,
            "32": 129219.61,
            "33": 103057.49,
            "34": 157693.92,
            "35": 85047.44,
            "36": 127056.21,
            "37": 51283.14,
            "38": 65947.93,
            "39": 82982.09,
            "40": 118546.05,
            "41": 84710.77,
            "42": 96189.63,
            "43": 127382.3,
            "44": 154806.14,
            "45": 124153.04,
            "46": 115816.21,
            "47": 135426.92,
            "48": 51743.15,
            "49": 116983.8,
        },
        "Marketing Spend": {
            "0": 471784.1,
            "1": 443898.53,
            "2": 407934.54,
            "3": 383199.62,
            "4": 366168.42,
            "5": 362861.36,
            "6": 127716.82,
            "7": 323876.68,
            "8": 311613.29,
            "9": 304981.62,
            "10": 229160.95,
            "11": 249744.55,
            "12": 249839.44,
            "13": 252664.93,
            "14": 256512.92,
            "15": 261776.23,
            "16": 264346.06,
            "17": 282574.31,
            "18": 294919.57,
            "19": 0.0,
            "20": 298664.47,
            "21": 299737.29,
            "22": 303319.26,
            "23": 304768.73,
            "24": 140574.81,
            "25": 137962.62,
            "26": 134050.07,
            "27": 353183.81,
            "28": 118148.2,
            "29": 107138.38,
            "30": 91131.24,
            "31": 88218.23,
            "32": 46085.25,
            "33": 214634.81,
            "34": 210797.67,
            "35": 205517.64,
            "36": 201126.82,
            "37": 197029.42,
            "38": 185265.1,
            "39": 174999.3,
            "40": 172795.67,
            "41": 164470.71,
            "42": 148001.11,
            "43": 35534.17,
            "44": 28334.72,
            "45": 1903.93,
            "46": 297114.46,
            "47": 0.0,
            "48": 0.0,
            "49": 45173.06,
        },
        "State": {
            "0": "New York",
            "1": "California",
            "2": "Florida",
            "3": "New York",
            "4": "Florida",
            "5": "New York",
            "6": "California",
            "7": "Florida",
            "8": "New York",
            "9": "California",
            "10": "Florida",
            "11": "California",
            "12": "Florida",
            "13": "California",
            "14": "Florida",
            "15": "New York",
            "16": "California",
            "17": "New York",
            "18": "Florida",
            "19": "New York",
            "20": "California",
            "21": "New York",
            "22": "Florida",
            "23": "Florida",
            "24": "New York",
            "25": "California",
            "26": "Florida",
            "27": "New York",
            "28": "Florida",
            "29": "New York",
            "30": "Florida",
            "31": "New York",
            "32": "California",
            "33": "Florida",
            "34": "California",
            "35": "New York",
            "36": "Florida",
            "37": "California",
            "38": "New York",
            "39": "California",
            "40": "California",
            "41": "Florida",
            "42": "California",
            "43": "New York",
            "44": "California",
            "45": "New York",
            "46": "Florida",
            "47": "California",
            "48": "New York",
            "49": "California",
        },
        "Profit": {
            "0": 192261.83,
            "1": 191792.06,
            "2": 191050.39,
            "3": 182901.99,
            "4": 166187.94,
            "5": 156991.12,
            "6": 156122.51,
            "7": 155752.6,
            "8": 152211.77,
            "9": 149759.96,
            "10": 146121.95,
            "11": 144259.4,
            "12": 141585.52,
            "13": 134307.35,
            "14": 132602.65,
            "15": 129917.04,
            "16": 126992.93,
            "17": 125370.37,
            "18": 124266.9,
            "19": 122776.86,
            "20": 118474.03,
            "21": 111313.02,
            "22": 110352.25,
            "23": 108733.99,
            "24": 108552.04,
            "25": 107404.34,
            "26": 105733.54,
            "27": 105008.31,
            "28": 103282.38,
            "29": 101004.64,
            "30": 99937.59,
            "31": 97483.56,
            "32": 97427.84,
            "33": 96778.92,
            "34": 96712.8,
            "35": 96479.51,
            "36": 90708.19,
            "37": 89949.14,
            "38": 81229.06,
            "39": 81005.76,
            "40": 78239.91,
            "41": 77798.83,
            "42": 71498.49,
            "43": 69758.98,
            "44": 65200.33,
            "45": 64926.08,
            "46": 49490.75,
            "47": 42559.73,
            "48": 35673.41,
            "49": 14681.4,
        },
    }
)

df_pred = pd.DataFrame(
    {
        "R&D Spend": [165349.20, 162597.70],
        "Administration Spend": [136897.80, 136897.80],
        "Marketing Spend": [471784.10, 443898.53],
        "State": ["New York", "California"],
    }
)


rae.ping().json()
features = ["R&D Spend", "Administration Spend", "Marketing Spend", "State"]
target = ["Profit"]
inp_config = {"encoder": "onehot", "std_scaler": True}
op_config = {"include_inputs": True}


def test_linear():
    lr = Linear(
        rae,
        df_train,
        df_pred,
        features,
        target,
        inp_config,
        op_config,
    )
    assert lr.predictions(as_df=True) is not None


def test_grad_boost():
    gb = GradientBoosting(
        rae,
        df_train,
        df_pred,
        features,
        target,
        inp_config,
        op_config,
    )
    assert gb.predictions(as_df=True) is not None


def test_randomforest():
    rf = RandomForest(
        rae,
        df_train,
        df_pred,
        features,
        target,
        inp_config,
        op_config,
    )
    assert rf.predictions(as_df=True) is not None


def test_ann():
    ann = ANN(
        rae,
        df_train,
        df_pred,
        features,
        target,
        inp_config,
        op_config,
    )
    assert ann.predictions(as_df=True) is not None


# def test_logistic():
#     lr = Linear(
#         rae,
#         df_train,
#         df_pred,
#         features,
#         target,
#         inp_config=inp_config,
#         op_config=op_config,
#     )
#     assert lr.predictions(as_df=True) is not None
