# Socket Api 2

This is make easier to create servers and clients with socket.

Supported language is python 3. (Package wrote in 3.9.6)

## Installation
Use this command:
    pip install socket_api2

## Change Log

0.0.3 (29/08/2021)
-------------------
- First Release
- Fixing / Desging description
- Added:
	class Server
	class MultiCLient
	class ClientObject
	def check_connection

## Examples

Difference between SEND_METHOD.default_send and SEND_METHOD.just_send, with the default send the program send a lenght of the message then send the message to know how many bytes we need to receive, but the just_send is just send the message. 

Example for Server:

    from socket_api2 import *

    server = Server(ip="auto", port=5555) #You can specify client_timeout, console_outoput, and use_pyngrok (if pyngrok use is True then pyngrok_options (dict) are required argument.) 

    @server.when_client_connect()
    def handling_client(client):
        while True:
            if client.is_connected:
                msg = client.recv(2048) #You can specify the buffer size, but not required | Default: 2048
                if msg == "hi":
                    client.send("hi 2", method=SEND_METHOD.default_send) #We don't need to specify the method. Default is better, but if you want to use just send its good to.
                
                elif msg == "I love u":
                    client.send("I love u too")

                else:
                    client.send("no hi", method=SEND_METHOD.just_send)
            else:
                break

    server.start()

Example for Client:

    from socket_api2 import *

    client = MultiClient(target_ip="IP", target_port=5555, timeout=10) #Here you can specify the timeout, console_output, and reconnect. (default True, if reconnect False then the program don't try reconnect)
    client.connect()

    client.send("hi")
    client.recv(2048)

    client.send("I love u", method=SEND_METHOD.just_send)
    client.recv(2048)