# coding: utf-8

"""
    Xero Finance API

    The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class CashBalance(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "opening_cash_balance": "float",
        "closing_cash_balance": "float",
        "net_cash_movement": "float",
    }

    attribute_map = {
        "opening_cash_balance": "openingCashBalance",
        "closing_cash_balance": "closingCashBalance",
        "net_cash_movement": "netCashMovement",
    }

    def __init__(
        self,
        opening_cash_balance=None,
        closing_cash_balance=None,
        net_cash_movement=None,
    ):  # noqa: E501
        """CashBalance - a model defined in OpenAPI"""  # noqa: E501

        self._opening_cash_balance = None
        self._closing_cash_balance = None
        self._net_cash_movement = None
        self.discriminator = None

        if opening_cash_balance is not None:
            self.opening_cash_balance = opening_cash_balance
        if closing_cash_balance is not None:
            self.closing_cash_balance = closing_cash_balance
        if net_cash_movement is not None:
            self.net_cash_movement = net_cash_movement

    @property
    def opening_cash_balance(self):
        """Gets the opening_cash_balance of this CashBalance.  # noqa: E501

        Opening balance of cash and cash equivalents  # noqa: E501

        :return: The opening_cash_balance of this CashBalance.  # noqa: E501
        :rtype: float
        """
        return self._opening_cash_balance

    @opening_cash_balance.setter
    def opening_cash_balance(self, opening_cash_balance):
        """Sets the opening_cash_balance of this CashBalance.

        Opening balance of cash and cash equivalents  # noqa: E501

        :param opening_cash_balance: The opening_cash_balance of this CashBalance.  # noqa: E501
        :type: float
        """

        self._opening_cash_balance = opening_cash_balance

    @property
    def closing_cash_balance(self):
        """Gets the closing_cash_balance of this CashBalance.  # noqa: E501

        Closing balance of cash and cash equivalents  # noqa: E501

        :return: The closing_cash_balance of this CashBalance.  # noqa: E501
        :rtype: float
        """
        return self._closing_cash_balance

    @closing_cash_balance.setter
    def closing_cash_balance(self, closing_cash_balance):
        """Sets the closing_cash_balance of this CashBalance.

        Closing balance of cash and cash equivalents  # noqa: E501

        :param closing_cash_balance: The closing_cash_balance of this CashBalance.  # noqa: E501
        :type: float
        """

        self._closing_cash_balance = closing_cash_balance

    @property
    def net_cash_movement(self):
        """Gets the net_cash_movement of this CashBalance.  # noqa: E501

        Net movement of cash and cash equivalents for the period  # noqa: E501

        :return: The net_cash_movement of this CashBalance.  # noqa: E501
        :rtype: float
        """
        return self._net_cash_movement

    @net_cash_movement.setter
    def net_cash_movement(self, net_cash_movement):
        """Sets the net_cash_movement of this CashBalance.

        Net movement of cash and cash equivalents for the period  # noqa: E501

        :param net_cash_movement: The net_cash_movement of this CashBalance.  # noqa: E501
        :type: float
        """

        self._net_cash_movement = net_cash_movement
