import * as dynamodb from 'aws-cdk-lib/aws-dynamodb';
import * as iot from '@aws-cdk/aws-iot-alpha';
import { CommonActionProps } from './common-action-props';
/**
 * Configuration properties of an action for the dynamodb table.
 */
export interface DynamoDBv2PutItemActionProps extends CommonActionProps {
}
/**
 * The action to put the record from an MQTT message to the DynamoDB table.
 */
export declare class DynamoDBv2PutItemAction implements iot.IAction {
    private readonly table;
    private readonly role?;
    /**
     * @param table the DynamoDB table in which to put the items.
     * @param props Optional properties to not use default
     */
    constructor(table: dynamodb.ITable, props?: DynamoDBv2PutItemActionProps);
    /**
     * @internal
     */
    _bind(rule: iot.ITopicRule): iot.ActionConfig;
}
