# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 21.2.0.20210406.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class TeleCheckICAPaymentMethodAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'customer_ip_address': 'str',
        'imei_code': 'str',
        'recurring_type': 'AchRecurringType'
    }

    attribute_map = {
        'customer_ip_address': 'customerIpAddress',
        'imei_code': 'imeiCode',
        'recurring_type': 'recurringType'
    }

    def __init__(self, customer_ip_address=None, imei_code=None, recurring_type=None):  # noqa: E501
        """TeleCheckICAPaymentMethodAllOf - a model defined in OpenAPI"""  # noqa: E501

        self._customer_ip_address = None
        self._imei_code = None
        self._recurring_type = None
        self.discriminator = None

        self.customer_ip_address = customer_ip_address
        if imei_code is not None:
            self.imei_code = imei_code
        if recurring_type is not None:
            self.recurring_type = recurring_type

    @property
    def customer_ip_address(self):
        """Gets the customer_ip_address of this TeleCheckICAPaymentMethodAllOf.  # noqa: E501

        Customer IP address from the terminal where the order was placed (as captured by merchant).  # noqa: E501

        :return: The customer_ip_address of this TeleCheckICAPaymentMethodAllOf.  # noqa: E501
        :rtype: str
        """
        return self._customer_ip_address

    @customer_ip_address.setter
    def customer_ip_address(self, customer_ip_address):
        """Sets the customer_ip_address of this TeleCheckICAPaymentMethodAllOf.

        Customer IP address from the terminal where the order was placed (as captured by merchant).  # noqa: E501

        :param customer_ip_address: The customer_ip_address of this TeleCheckICAPaymentMethodAllOf.  # noqa: E501
        :type: str
        """
        if customer_ip_address is None:
            raise ValueError("Invalid value for `customer_ip_address`, must not be `None`")  # noqa: E501
        if customer_ip_address is not None and len(customer_ip_address) > 15:
            raise ValueError("Invalid value for `customer_ip_address`, length must be less than or equal to `15`")  # noqa: E501
        if customer_ip_address is not None and not re.search(r'^[0-9\.]+$', customer_ip_address):  # noqa: E501
            raise ValueError(r"Invalid value for `customer_ip_address`, must be a follow pattern or equal to `/^[0-9\.]+$/`")  # noqa: E501

        self._customer_ip_address = customer_ip_address

    @property
    def imei_code(self):
        """Gets the imei_code of this TeleCheckICAPaymentMethodAllOf.  # noqa: E501

        International mobile equipment identity code.  # noqa: E501

        :return: The imei_code of this TeleCheckICAPaymentMethodAllOf.  # noqa: E501
        :rtype: str
        """
        return self._imei_code

    @imei_code.setter
    def imei_code(self, imei_code):
        """Sets the imei_code of this TeleCheckICAPaymentMethodAllOf.

        International mobile equipment identity code.  # noqa: E501

        :param imei_code: The imei_code of this TeleCheckICAPaymentMethodAllOf.  # noqa: E501
        :type: str
        """
        if imei_code is not None and len(imei_code) > 25:
            raise ValueError("Invalid value for `imei_code`, length must be less than or equal to `25`")  # noqa: E501
        if imei_code is not None and not re.search(r'(?=.*[^\s])^[^|]+$', imei_code):  # noqa: E501
            raise ValueError(r"Invalid value for `imei_code`, must be a follow pattern or equal to `/(?=.*[^\s])^[^|]+$/`")  # noqa: E501

        self._imei_code = imei_code

    @property
    def recurring_type(self):
        """Gets the recurring_type of this TeleCheckICAPaymentMethodAllOf.  # noqa: E501


        :return: The recurring_type of this TeleCheckICAPaymentMethodAllOf.  # noqa: E501
        :rtype: AchRecurringType
        """
        return self._recurring_type

    @recurring_type.setter
    def recurring_type(self, recurring_type):
        """Sets the recurring_type of this TeleCheckICAPaymentMethodAllOf.


        :param recurring_type: The recurring_type of this TeleCheckICAPaymentMethodAllOf.  # noqa: E501
        :type: AchRecurringType
        """

        self._recurring_type = recurring_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TeleCheckICAPaymentMethodAllOf):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
