# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 21.2.0.20210406.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class PaymentUrlDetail(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'payment_url': 'str',
        'merchant_transaction_id': 'str',
        'order_id': 'str',
        'request_time': 'int',
        'status': 'PaymentUrlStatus'
    }

    attribute_map = {
        'payment_url': 'paymentUrl',
        'merchant_transaction_id': 'merchantTransactionId',
        'order_id': 'orderId',
        'request_time': 'requestTime',
        'status': 'status'
    }

    def __init__(self, payment_url=None, merchant_transaction_id=None, order_id=None, request_time=None, status=None):  # noqa: E501
        """PaymentUrlDetail - a model defined in OpenAPI"""  # noqa: E501

        self._payment_url = None
        self._merchant_transaction_id = None
        self._order_id = None
        self._request_time = None
        self._status = None
        self.discriminator = None

        if payment_url is not None:
            self.payment_url = payment_url
        if merchant_transaction_id is not None:
            self.merchant_transaction_id = merchant_transaction_id
        if order_id is not None:
            self.order_id = order_id
        if request_time is not None:
            self.request_time = request_time
        if status is not None:
            self.status = status

    @property
    def payment_url(self):
        """Gets the payment_url of this PaymentUrlDetail.  # noqa: E501

        URL for embedded payment link.  # noqa: E501

        :return: The payment_url of this PaymentUrlDetail.  # noqa: E501
        :rtype: str
        """
        return self._payment_url

    @payment_url.setter
    def payment_url(self, payment_url):
        """Sets the payment_url of this PaymentUrlDetail.

        URL for embedded payment link.  # noqa: E501

        :param payment_url: The payment_url of this PaymentUrlDetail.  # noqa: E501
        :type: str
        """

        self._payment_url = payment_url

    @property
    def merchant_transaction_id(self):
        """Gets the merchant_transaction_id of this PaymentUrlDetail.  # noqa: E501

        The unique merchant transaction ID from the request, if supplied.  # noqa: E501

        :return: The merchant_transaction_id of this PaymentUrlDetail.  # noqa: E501
        :rtype: str
        """
        return self._merchant_transaction_id

    @merchant_transaction_id.setter
    def merchant_transaction_id(self, merchant_transaction_id):
        """Sets the merchant_transaction_id of this PaymentUrlDetail.

        The unique merchant transaction ID from the request, if supplied.  # noqa: E501

        :param merchant_transaction_id: The merchant_transaction_id of this PaymentUrlDetail.  # noqa: E501
        :type: str
        """
        if merchant_transaction_id is not None and len(merchant_transaction_id) > 40:
            raise ValueError("Invalid value for `merchant_transaction_id`, length must be less than or equal to `40`")  # noqa: E501

        self._merchant_transaction_id = merchant_transaction_id

    @property
    def order_id(self):
        """Gets the order_id of this PaymentUrlDetail.  # noqa: E501

        Note - Client Order ID if supplied by client. If not supplied by client, IPG will generate. The first 12 alphanumeric digits are passed down to Fiserv Enterprise reporting tool, Clientline and Data File Manager (DFM).  # noqa: E501

        :return: The order_id of this PaymentUrlDetail.  # noqa: E501
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this PaymentUrlDetail.

        Note - Client Order ID if supplied by client. If not supplied by client, IPG will generate. The first 12 alphanumeric digits are passed down to Fiserv Enterprise reporting tool, Clientline and Data File Manager (DFM).  # noqa: E501

        :param order_id: The order_id of this PaymentUrlDetail.  # noqa: E501
        :type: str
        """

        self._order_id = order_id

    @property
    def request_time(self):
        """Gets the request_time of this PaymentUrlDetail.  # noqa: E501

        The transaction time in seconds since epoch.  # noqa: E501

        :return: The request_time of this PaymentUrlDetail.  # noqa: E501
        :rtype: int
        """
        return self._request_time

    @request_time.setter
    def request_time(self, request_time):
        """Sets the request_time of this PaymentUrlDetail.

        The transaction time in seconds since epoch.  # noqa: E501

        :param request_time: The request_time of this PaymentUrlDetail.  # noqa: E501
        :type: int
        """

        self._request_time = request_time

    @property
    def status(self):
        """Gets the status of this PaymentUrlDetail.  # noqa: E501


        :return: The status of this PaymentUrlDetail.  # noqa: E501
        :rtype: PaymentUrlStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this PaymentUrlDetail.


        :param status: The status of this PaymentUrlDetail.  # noqa: E501
        :type: PaymentUrlStatus
        """

        self._status = status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PaymentUrlDetail):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
