# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 21.2.0.20210406.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class PaymentCardPaymentTokenUpdateRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'request_type': 'str',
        'store_id': 'str',
        'payment_tokens': 'list[UpdatePaymentToken]'
    }

    attribute_map = {
        'request_type': 'requestType',
        'store_id': 'storeId',
        'payment_tokens': 'paymentTokens'
    }

    discriminator_value_class_map = {
        
    }

    def __init__(self, request_type=None, store_id=None, payment_tokens=None):  # noqa: E501
        """PaymentCardPaymentTokenUpdateRequest - a model defined in OpenAPI"""  # noqa: E501

        self._request_type = None
        self._store_id = None
        self._payment_tokens = None
        self.discriminator = 'request_type'

        self.request_type = request_type
        if store_id is not None:
            self.store_id = store_id
        self.payment_tokens = payment_tokens

    @property
    def request_type(self):
        """Gets the request_type of this PaymentCardPaymentTokenUpdateRequest.  # noqa: E501

        Object name of tokenization request.  # noqa: E501

        :return: The request_type of this PaymentCardPaymentTokenUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._request_type

    @request_type.setter
    def request_type(self, request_type):
        """Sets the request_type of this PaymentCardPaymentTokenUpdateRequest.

        Object name of tokenization request.  # noqa: E501

        :param request_type: The request_type of this PaymentCardPaymentTokenUpdateRequest.  # noqa: E501
        :type: str
        """
        if request_type is None:
            raise ValueError("Invalid value for `request_type`, must not be `None`")  # noqa: E501

        self._request_type = request_type

    @property
    def store_id(self):
        """Gets the store_id of this PaymentCardPaymentTokenUpdateRequest.  # noqa: E501

        An optional outlet ID for clients that support multiple stores in the same app.  # noqa: E501

        :return: The store_id of this PaymentCardPaymentTokenUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._store_id

    @store_id.setter
    def store_id(self, store_id):
        """Sets the store_id of this PaymentCardPaymentTokenUpdateRequest.

        An optional outlet ID for clients that support multiple stores in the same app.  # noqa: E501

        :param store_id: The store_id of this PaymentCardPaymentTokenUpdateRequest.  # noqa: E501
        :type: str
        """
        if store_id is not None and len(store_id) > 20:
            raise ValueError("Invalid value for `store_id`, length must be less than or equal to `20`")  # noqa: E501

        self._store_id = store_id

    @property
    def payment_tokens(self):
        """Gets the payment_tokens of this PaymentCardPaymentTokenUpdateRequest.  # noqa: E501

        List of payment tokens to be updated in the request.  # noqa: E501

        :return: The payment_tokens of this PaymentCardPaymentTokenUpdateRequest.  # noqa: E501
        :rtype: list[UpdatePaymentToken]
        """
        return self._payment_tokens

    @payment_tokens.setter
    def payment_tokens(self, payment_tokens):
        """Sets the payment_tokens of this PaymentCardPaymentTokenUpdateRequest.

        List of payment tokens to be updated in the request.  # noqa: E501

        :param payment_tokens: The payment_tokens of this PaymentCardPaymentTokenUpdateRequest.  # noqa: E501
        :type: list[UpdatePaymentToken]
        """
        if payment_tokens is None:
            raise ValueError("Invalid value for `payment_tokens`, must not be `None`")  # noqa: E501

        self._payment_tokens = payment_tokens

    def get_real_child_model(self, data):
        """Returns the real base class specified by the discriminator"""
        discriminator_key = self.attribute_map[self.discriminator]
        discriminator_value = data[discriminator_key]
        return self.discriminator_value_class_map.get(discriminator_value)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PaymentCardPaymentTokenUpdateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
