# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 21.2.0.20210406.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class DCCExchangeRateRequestAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'bin': 'str'
    }

    attribute_map = {
        'bin': 'bin'
    }

    def __init__(self, bin=None):  # noqa: E501
        """DCCExchangeRateRequestAllOf - a model defined in OpenAPI"""  # noqa: E501

        self._bin = None
        self.discriminator = None

        self.bin = bin

    @property
    def bin(self):
        """Gets the bin of this DCCExchangeRateRequestAllOf.  # noqa: E501

        The bank identification number (BIN) of the card to be used for DCC. The BIN is the first 6-9 digits of the card number.  # noqa: E501

        :return: The bin of this DCCExchangeRateRequestAllOf.  # noqa: E501
        :rtype: str
        """
        return self._bin

    @bin.setter
    def bin(self, bin):
        """Sets the bin of this DCCExchangeRateRequestAllOf.

        The bank identification number (BIN) of the card to be used for DCC. The BIN is the first 6-9 digits of the card number.  # noqa: E501

        :param bin: The bin of this DCCExchangeRateRequestAllOf.  # noqa: E501
        :type: str
        """
        if bin is None:
            raise ValueError("Invalid value for `bin`, must not be `None`")  # noqa: E501
        if bin is not None and not re.search(r'[0-9]{6,9}', bin):  # noqa: E501
            raise ValueError(r"Invalid value for `bin`, must be a follow pattern or equal to `/[0-9]{6,9}/`")  # noqa: E501

        self._bin = bin

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DCCExchangeRateRequestAllOf):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
