"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const cloudfront = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'integ-cloudfront-s3');
const bucket = new s3.Bucket(stack, 'Bucket', { removalPolicy: cdk.RemovalPolicy.DESTROY });
const oai = new cloudfront.CfnCloudFrontOriginAccessIdentity(stack, 'OAI', {
    cloudFrontOriginAccessIdentityConfig: {
        comment: 'Allows CloudFront to reach the bucket!',
    },
});
const oaiImported = cloudfront.OriginAccessIdentity.fromOriginAccessIdentityName(stack, 'OAIImported', oai.ref);
const dist = new cloudfront.CloudFrontWebDistribution(stack, 'Distribution', {
    originConfigs: [{
            behaviors: [{ isDefaultBehavior: true }],
            s3OriginSource: {
                s3BucketSource: bucket,
                originAccessIdentity: oaiImported,
            },
        }],
});
new cdk.CfnOutput(stack, 'DistributionDomainName', { value: dist.domainName });
//# sourceMappingURL=data:application/json;base64,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