"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CacheBehavior = void 0;
const distribution_1 = require("../distribution");
/**
 * Allows configuring a variety of CloudFront functionality for a given URL path pattern.
 *
 * Note: This really should simply by called 'Behavior', but this name is already taken by the legacy
 * CloudFrontWebDistribution implementation.
 */
class CacheBehavior {
    constructor(props) {
        this.props = props;
        this.origin = props.origin;
    }
    /**
     * Creates and returns the CloudFormation representation of this behavior.
     * This renders as a "CacheBehaviorProperty" regardless of if this is a default
     * cache behavior or not, as the two are identical except that the pathPattern
     * is omitted for the default cache behavior.
     *
     * @internal
     */
    _renderBehavior() {
        var _a, _b, _c;
        return {
            pathPattern: this.props.pathPattern,
            targetOriginId: this.origin.id,
            allowedMethods: (_b = (_a = this.props.allowedMethods) === null || _a === void 0 ? void 0 : _a.methods) !== null && _b !== void 0 ? _b : undefined,
            forwardedValues: {
                queryString: (_c = this.props.forwardQueryString) !== null && _c !== void 0 ? _c : false,
                queryStringCacheKeys: this.props.forwardQueryStringCacheKeys,
            },
            viewerProtocolPolicy: distribution_1.ViewerProtocolPolicy.ALLOW_ALL,
        };
    }
}
exports.CacheBehavior = CacheBehavior;
//# sourceMappingURL=data:application/json;base64,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