/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.util;

import com.github.sh0nk.matplotlib4j.Plot;
import com.github.sh0nk.matplotlib4j.PythonExecutionException;
import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.online.signal.TimeChain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Plotter {
    private final List<Thread> threads = new ArrayList<Thread>();
    private final boolean isAsync;
    private final double infinity;

    public Plotter(double maxValue) {
        this(true, maxValue);
    }

    public Plotter(boolean async, double maxValue) {
        this.isAsync = async;
        this.infinity = maxValue;
    }

    public void waitActivePlots(long seconds) {
        try {
            for (Thread t : this.threads) {
                t.join(seconds * 1000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Plot coordinator died unexpectedly");
        }
    }

    public void plot(List<Double> data, String name, String label) {
        if (this.isAsync) {
            this.asyncShow(() -> this.plotSingle(data, name, label));
        } else {
            this.plotSingle(data, name, label);
        }
    }

    public void plot(List<Double> dataDown, List<Double> dataUp, String name) {
        List<Double> down = this.replaceInfinite(dataDown);
        List<Double> up = this.replaceInfinite(dataUp);
        if (this.isAsync) {
            this.asyncShow(() -> this.plotInterval(down, up, name));
        } else {
            this.plotInterval(down, up, name);
        }
    }

    public void plot(TimeChain<Double, Box<Double>> data, String name) {
        List<Double> dataDown = this.replaceInfinite(data.stream().map(x -> (Double)((Box)x.getValue()).getStart()).collect(Collectors.toList()));
        List<Double> dataUp = this.replaceInfinite(data.stream().map(x -> (Double)((Box)x.getValue()).getEnd()).collect(Collectors.toList()));
        if (this.isAsync) {
            this.asyncShow(() -> this.plotInterval(dataDown, dataUp, name));
        } else {
            this.plotInterval(dataDown, dataUp, name);
        }
    }

    public void plotAll(TimeChain<Double, List<Box<Double>>> data, String name) {
        int locations = data.getFirst().getValue().size();
        IntStream.range(0, locations).forEach(location -> this.plotOne(data, name, location));
    }

    public void plotOne(TimeChain<Double, List<Box<Double>>> data, String name, int location) {
        List<Double> dataDown = this.replaceInfinite(data.stream().map(x -> (Double)((Box)((List)x.getValue()).get(location)).getStart()).collect(Collectors.toList()));
        List<Double> dataUp = this.replaceInfinite(data.stream().map(x -> (Double)((Box)((List)x.getValue()).get(location)).getEnd()).collect(Collectors.toList()));
        String locName = name + "@loc-" + location;
        if (this.isAsync) {
            this.asyncShow(() -> this.plotInterval(dataDown, dataUp, locName));
        } else {
            this.plotInterval(dataDown, dataUp, locName);
        }
    }

    public void plotOne(TimeChain<Double, List<Double>> data, String name, int location, String label) {
        List<Double> values = this.replaceInfinite(data.stream().map(x -> (Double)((List)x.getValue()).get(location)).collect(Collectors.toList()));
        String locName = name + "@loc-" + location;
        if (this.isAsync) {
            this.asyncShow(() -> this.plotSingle(values, locName, label));
        } else {
            this.plotSingle(values, locName, label);
        }
    }

    private Plot createPlot(String name) {
        Plot plt = Plot.create();
        plt.xlabel("times");
        plt.title(name);
        plt.legend();
        return plt;
    }

    private void addData(Plot plt, List<Double> data, String label) {
        plt.plot().add(data).label(label);
    }

    private void showPlot(Plot plt) {
        try {
            plt.show();
        }
        catch (PythonExecutionException | IOException e) {
            System.err.println("unable to plot!");
            e.printStackTrace();
        }
    }

    private void plotInterval(List<Double> dataDown, List<Double> dataUp, String name) {
        Plot plt = this.createPlot(name);
        this.addData(plt, dataDown, "rho_down");
        this.addData(plt, dataUp, "rho_up");
        this.showPlot(plt);
    }

    private void plotSingle(List<Double> data, String name, String label) {
        Plot plt = this.createPlot(name);
        data = this.replaceInfinite(data);
        this.addData(plt, data, label);
        this.showPlot(plt);
    }

    private void asyncShow(Runnable r) {
        Thread t = new Thread(r);
        this.threads.add(t);
        t.start();
    }

    private List<Double> replaceInfinite(List<Double> vs) {
        vs = vs.stream().map(v -> v.equals(Double.POSITIVE_INFINITY) ? this.infinity : v).map(v -> v.equals(Double.NEGATIVE_INFINITY) ? -this.infinity : v).collect(Collectors.toList());
        return vs;
    }
}

