/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.monitoring;

import eu.quanticol.moonlight.core.algorithms.EscapeAlgorithm;
import eu.quanticol.moonlight.core.algorithms.SpatialAlgorithms;
import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.core.formula.Formula;
import eu.quanticol.moonlight.core.formula.SpatialFormula;
import eu.quanticol.moonlight.core.formula.UnaryFormula;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.signal.SpaceTimeSignal;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.domain.BoxDomain;
import eu.quanticol.moonlight.domain.ListDomain;
import eu.quanticol.moonlight.formula.AtomicFormula;
import eu.quanticol.moonlight.formula.classic.AndFormula;
import eu.quanticol.moonlight.formula.classic.NegationFormula;
import eu.quanticol.moonlight.formula.classic.OrFormula;
import eu.quanticol.moonlight.formula.spatial.EscapeFormula;
import eu.quanticol.moonlight.formula.spatial.EverywhereFormula;
import eu.quanticol.moonlight.formula.spatial.ReachFormula;
import eu.quanticol.moonlight.formula.spatial.SomewhereFormula;
import eu.quanticol.moonlight.formula.temporal.EventuallyFormula;
import eu.quanticol.moonlight.formula.temporal.GloballyFormula;
import eu.quanticol.moonlight.online.algorithms.SpatialOp;
import eu.quanticol.moonlight.online.monitoring.OnlineMonitor;
import eu.quanticol.moonlight.online.monitoring.spatialtemporal.AtomicMonitor;
import eu.quanticol.moonlight.online.monitoring.spatialtemporal.BinaryMonitor;
import eu.quanticol.moonlight.online.monitoring.spatialtemporal.BinarySpaceOpMonitor;
import eu.quanticol.moonlight.online.monitoring.spatialtemporal.UnaryMonitor;
import eu.quanticol.moonlight.online.monitoring.spatialtemporal.UnarySpaceOpMonitor;
import eu.quanticol.moonlight.online.monitoring.spatialtemporal.UnaryTimeOpMonitor;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.Update;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.jetbrains.annotations.NotNull;

public class OnlineSpatialTemporalMonitor<S, V, R extends Comparable<R>> {
    private final Formula formula;
    private final SignalDomain<R> interpretation;
    private final ListDomain<R> listInterpretation;
    private final Map<String, OnlineMonitor<Double, List<V>, List<Box<R>>>> monitors = new HashMap<String, OnlineMonitor<Double, List<V>, List<Box<R>>>>();
    private final Map<String, Function<V, Box<R>>> atoms;
    private final Map<String, Function<SpatialModel<S>, DistanceStructure<S, ?>>> dist;
    private final LocationService<Double, S> locSvc;
    private final boolean parallel;
    private final int size;

    public OnlineSpatialTemporalMonitor(Formula formula, int size, SignalDomain<R> interpretation, LocationService<Double, S> locationService, Map<String, Function<V, Box<R>>> atomicPropositions, Map<String, Function<SpatialModel<S>, DistanceStructure<S, ?>>> distanceFunctions) {
        this(formula, size, interpretation, locationService, atomicPropositions, distanceFunctions, false);
    }

    public OnlineSpatialTemporalMonitor(Formula formula, int size, SignalDomain<R> interpretation, LocationService<Double, S> locationService, Map<String, Function<V, Box<R>>> atomicPropositions, Map<String, Function<SpatialModel<S>, DistanceStructure<S, ?>>> distanceFunctions, boolean parallel) {
        this.atoms = atomicPropositions;
        this.formula = formula;
        this.interpretation = interpretation;
        this.dist = distanceFunctions;
        this.locSvc = locationService;
        this.size = size;
        this.listInterpretation = new ListDomain<R>(size, interpretation);
        this.parallel = parallel;
    }

    public SpaceTimeSignal<Double, Box<R>> monitor(@NotNull Update<Double, List<V>> update) {
        OnlineMonitor<Double, List<List<V>>, List<Box<R>>> m = this.monitor(this.formula);
        if (update.value().size() != this.size) {
            throw new IllegalArgumentException("The update doesn't match the expected size of the signal");
        }
        m.monitor(update);
        return (SpaceTimeSignal)m.getResult();
    }

    public SpaceTimeSignal<Double, Box<R>> monitor(@NotNull TimeChain<Double, List<V>> updates) {
        OnlineMonitor<Double, List<List<V>>, List<Box<R>>> m = this.monitor(this.formula);
        m.monitor(updates);
        return (SpaceTimeSignal)m.getResult();
    }

    private OnlineMonitor<Double, List<V>, List<Box<R>>> monitor(Formula f) {
        Formula formula = f;
        Objects.requireNonNull(formula);
        Formula formula2 = formula;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AtomicFormula.class, NegationFormula.class, AndFormula.class, OrFormula.class, EventuallyFormula.class, GloballyFormula.class, SomewhereFormula.class, EverywhereFormula.class, EscapeFormula.class}, (Object)formula2, n)) {
            case 0 -> {
                AtomicFormula atomic = (AtomicFormula)formula2;
                yield this.generateAtomicMonitor(atomic);
            }
            case 1 -> {
                NegationFormula negation = (NegationFormula)formula2;
                yield this.generateNegationMonitor(negation);
            }
            case 2 -> {
                AndFormula and = (AndFormula)formula2;
                yield this.generateAndMonitor(and);
            }
            case 3 -> {
                OrFormula or = (OrFormula)formula2;
                yield this.generateOrMonitor(or);
            }
            case 4 -> {
                EventuallyFormula ev = (EventuallyFormula)formula2;
                yield this.generateEventuallyMonitor(ev);
            }
            case 5 -> {
                GloballyFormula globally = (GloballyFormula)formula2;
                yield this.generateGloballyMonitor(globally);
            }
            case 6 -> {
                SomewhereFormula some = (SomewhereFormula)formula2;
                yield this.unarySpace(some, this::somewhereOp);
            }
            case 7 -> {
                EverywhereFormula every = (EverywhereFormula)formula2;
                yield this.unarySpace(every, this::everywhereOp);
            }
            case 8 -> {
                EscapeFormula escape = (EscapeFormula)formula2;
                yield this.unarySpace(escape, this::escapeOp);
            }
            default -> this.illegalFormula(f);
        };
    }

    private OnlineMonitor<Double, List<V>, List<Box<R>>> illegalFormula(Formula f) {
        throw new IllegalArgumentException("Unsupported formula: " + f);
    }

    public OnlineMonitor<Double, List<V>, List<Box<R>>> generateAtomicMonitor(AtomicFormula formula) {
        Function<V, Box<R>> f = this.fetchAtom(formula);
        return this.monitors.computeIfAbsent(formula.toString(), x -> new AtomicMonitor(f, this.size, this.interpretation));
    }

    public OnlineMonitor<Double, List<V>, List<Box<R>>> generateNegationMonitor(NegationFormula formula) {
        OnlineMonitor<Double, List<V>, List<Box<R>>> argMonitor = this.monitor(formula.getArgument());
        return this.monitors.computeIfAbsent(formula.toString(), x -> new UnaryMonitor(argMonitor, this.listInterpretation::negation, this.interpretation, this.size));
    }

    public OnlineMonitor<Double, List<V>, List<Box<R>>> generateAndMonitor(AndFormula formula) {
        OnlineMonitor<Double, List<V>, List<Box<R>>> firstArg = this.monitor(formula.getFirstArgument());
        OnlineMonitor<Double, List<V>, List<Box<R>>> secondArg = this.monitor(formula.getSecondArgument());
        return this.monitors.computeIfAbsent(formula.toString(), x -> new BinaryMonitor(firstArg, secondArg, this.listInterpretation::conjunction, this.interpretation, this.size));
    }

    public OnlineMonitor<Double, List<V>, List<Box<R>>> generateOrMonitor(OrFormula formula) {
        OnlineMonitor<Double, List<V>, List<Box<R>>> firstArg = this.monitor(formula.getFirstArgument());
        OnlineMonitor<Double, List<V>, List<Box<R>>> secondArg = this.monitor(formula.getSecondArgument());
        return this.monitors.computeIfAbsent(formula.toString(), x -> new BinaryMonitor(firstArg, secondArg, this.listInterpretation::disjunction, this.interpretation, this.size));
    }

    public OnlineMonitor<Double, List<V>, List<Box<R>>> generateEventuallyMonitor(EventuallyFormula formula) {
        OnlineMonitor<Double, List<V>, List<Box<R>>> argMonitor = this.monitor(formula.getArgument());
        return this.monitors.computeIfAbsent(formula.toString(), x -> new UnaryTimeOpMonitor(argMonitor, this.listInterpretation::disjunction, formula.getInterval(), this.interpretation, this.size));
    }

    public OnlineMonitor<Double, List<V>, List<Box<R>>> generateGloballyMonitor(GloballyFormula formula) {
        OnlineMonitor<Double, List<V>, List<Box<R>>> argMonitor = this.monitor(formula.getArgument());
        return this.monitors.computeIfAbsent(formula.toString(), x -> new UnaryTimeOpMonitor(argMonitor, this.listInterpretation::conjunction, formula.getInterval(), this.interpretation, this.size));
    }

    public OnlineMonitor<Double, List<V>, List<Box<R>>> generateReachMonitor(ReachFormula formula) {
        OnlineMonitor<Double, List<V>, List<Box<R>>> firstArg = this.monitor(formula.getFirstArgument());
        OnlineMonitor<Double, List<V>, List<Box<R>>> secondArg = this.monitor(formula.getSecondArgument());
        return this.monitors.computeIfAbsent(formula.toString(), x -> new BinarySpaceOpMonitor(firstArg, secondArg, null, this.interpretation, this.size));
    }

    private OnlineMonitor<Double, List<V>, List<Box<R>>> unarySpace(UnaryFormula f, BiFunction<IntFunction<Box<R>>, DistanceStructure<S, ?>, IntFunction<Box<R>>> op) {
        OnlineMonitor<Double, List<V>, List<Box<R>>> argMonitor = this.monitor(f.getArgument());
        String distF = ((SpatialFormula)((Object)f)).getDistanceFunctionId();
        Function<SpatialModel<S>, DistanceStructure<S, ?>> d = this.dist.get(distF);
        SpatialOp sc = new SpatialOp(this.locSvc, d, op);
        return this.monitors.computeIfAbsent(this.formula.toString(), x -> new UnarySpaceOpMonitor(argMonitor, sc, this.interpretation, this.size));
    }

    private IntFunction<Box<R>> everywhereOp(IntFunction<Box<R>> spatialSignal, DistanceStructure<S, ?> ds) {
        BoxDomain<R> domain = new BoxDomain<R>(this.interpretation);
        return new SpatialAlgorithms(ds, domain, this.parallel).everywhere(spatialSignal);
    }

    private IntFunction<Box<R>> somewhereOp(IntFunction<Box<R>> spatialSignal, DistanceStructure<S, ?> ds) {
        BoxDomain<R> domain = new BoxDomain<R>(this.interpretation);
        return new SpatialAlgorithms(ds, domain, this.parallel).somewhere(spatialSignal);
    }

    private IntFunction<Box<R>> escapeOp(IntFunction<Box<R>> spatialSignal, DistanceStructure<S, ?> f) {
        BoxDomain<R> domain = new BoxDomain<R>(this.interpretation);
        return new EscapeAlgorithm(f, domain, spatialSignal).compute();
    }

    private Function<V, Box<R>> fetchAtom(AtomicFormula f) {
        Function<V, Box<R>> atom = this.atoms.get(f.getAtomicId());
        if (atom == null) {
            throw new IllegalArgumentException("Unknown atomic ID " + f.getAtomicId());
        }
        return atom;
    }
}

