/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.monitoring.spatialtemporal;

import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitorAtomic;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitorBinaryOperator;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitorEscape;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitorEverywhere;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitorFutureOperator;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitorPastOperator;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitorReach;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitorSince;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitorSomewhere;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitorUnaryOperator;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitorUntil;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import java.util.function.Function;

public interface SpatialTemporalMonitor<S, T, R> {
    public SpatialTemporalSignal<R> monitor(LocationService<Double, S> var1, SpatialTemporalSignal<T> var2);

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> atomicMonitor(Function<T, R> atomic) {
        return new SpatialTemporalMonitorAtomic(atomic);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> andMonitor(SpatialTemporalMonitor<S, T, R> m1, SignalDomain<R> domain, SpatialTemporalMonitor<S, T, R> m2) {
        return new SpatialTemporalMonitorBinaryOperator<S, T, R>(m1, domain::conjunction, m2);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> orMonitor(SpatialTemporalMonitor<S, T, R> m1, SignalDomain<R> domain, SpatialTemporalMonitor<S, T, R> m2) {
        return new SpatialTemporalMonitorBinaryOperator<S, T, R>(m1, domain::disjunction, m2);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> impliesMonitor(SpatialTemporalMonitor<S, T, R> m1, SignalDomain<R> domain, SpatialTemporalMonitor<S, T, R> m2) {
        return new SpatialTemporalMonitorBinaryOperator<S, T, R>(m1, domain::implies, m2);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> notMonitor(SpatialTemporalMonitor<S, T, R> m, SignalDomain<R> domain) {
        return new SpatialTemporalMonitorUnaryOperator<S, T, R>(m, domain::negation);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> eventuallyMonitor(SpatialTemporalMonitor<S, T, R> m, SignalDomain<R> domain, Interval interval) {
        return new SpatialTemporalMonitorFutureOperator<S, T, R>(m, interval, domain::disjunction, domain.min());
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> eventuallyMonitor(SpatialTemporalMonitor<S, T, R> m, SignalDomain<R> domain) {
        return SpatialTemporalMonitor.eventuallyMonitor(m, domain, null);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> globallyMonitor(SpatialTemporalMonitor<S, T, R> m, SignalDomain<R> domain, Interval interval) {
        return new SpatialTemporalMonitorFutureOperator<S, T, R>(m, interval, domain::conjunction, domain.max());
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> globallyMonitor(SpatialTemporalMonitor<S, T, R> m, SignalDomain<R> domain) {
        return SpatialTemporalMonitor.globallyMonitor(m, domain, null);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> untilMonitor(SpatialTemporalMonitor<S, T, R> m1, Interval interval, SpatialTemporalMonitor<S, T, R> m2, SignalDomain<R> domain) {
        return new SpatialTemporalMonitorUntil<S, T, R>(m1, interval, m2, domain);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> untilMonitor(SpatialTemporalMonitor<S, T, R> m1, SpatialTemporalMonitor<S, T, R> m2, SignalDomain<R> domain) {
        return SpatialTemporalMonitor.untilMonitor(m1, null, m2, domain);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> sinceMonitor(SpatialTemporalMonitor<S, T, R> m1, Interval interval, SpatialTemporalMonitor<S, T, R> m2, SignalDomain<R> domain) {
        return new SpatialTemporalMonitorSince<S, T, R>(m1, interval, m2, domain);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> sinceMonitor(SpatialTemporalMonitor<S, T, R> m1, SpatialTemporalMonitor<S, T, R> m2, SignalDomain<R> domain) {
        return SpatialTemporalMonitor.sinceMonitor(m1, null, m2, domain);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> onceMonitor(SpatialTemporalMonitor<S, T, R> m, SignalDomain<R> domain, Interval interval) {
        return new SpatialTemporalMonitorPastOperator<S, T, R>(m, interval, domain::disjunction, domain.min());
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> onceMonitor(SpatialTemporalMonitor<S, T, R> m, SignalDomain<R> domain) {
        return SpatialTemporalMonitor.onceMonitor(m, domain, null);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> historicallyMonitor(SpatialTemporalMonitor<S, T, R> m, SignalDomain<R> domain, Interval interval) {
        return new SpatialTemporalMonitorPastOperator<S, T, R>(m, interval, domain::conjunction, domain.max());
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> historicallyMonitor(SpatialTemporalMonitor<S, T, R> m, SignalDomain<R> domain) {
        return SpatialTemporalMonitor.historicallyMonitor(m, domain, null);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> somewhereMonitor(SpatialTemporalMonitor<S, T, R> m, Function<SpatialModel<S>, DistanceStructure<S, ?>> distance, SignalDomain<R> domain) {
        return SpatialTemporalMonitor.somewhereMonitor(m, distance, domain, false);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> somewhereMonitor(SpatialTemporalMonitor<S, T, R> m, Function<SpatialModel<S>, DistanceStructure<S, ?>> distance, SignalDomain<R> domain, boolean isParallel) {
        return new SpatialTemporalMonitorSomewhere<S, T, R>(m, distance, domain, isParallel);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> everywhereMonitor(SpatialTemporalMonitor<S, T, R> m, Function<SpatialModel<S>, DistanceStructure<S, ?>> distance, SignalDomain<R> domain) {
        return SpatialTemporalMonitor.everywhereMonitor(m, distance, domain, false);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> everywhereMonitor(SpatialTemporalMonitor<S, T, R> m, Function<SpatialModel<S>, DistanceStructure<S, ?>> distance, SignalDomain<R> domain, boolean isParallel) {
        return new SpatialTemporalMonitorEverywhere<S, T, R>(m, distance, domain, isParallel);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> escapeMonitor(SpatialTemporalMonitor<S, T, R> m, Function<SpatialModel<S>, DistanceStructure<S, ?>> distance, SignalDomain<R> domain) {
        return new SpatialTemporalMonitorEscape<S, T, R>(m, distance, domain);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> reachMonitor(SpatialTemporalMonitor<S, T, R> m1, Function<SpatialModel<S>, DistanceStructure<S, ?>> distance, SpatialTemporalMonitor<S, T, R> m2, SignalDomain<R> domain) {
        return new SpatialTemporalMonitorReach<S, T, R>(m1, distance, m2, domain);
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> surroundMonitor(SpatialTemporalMonitor<S, T, R> m, Interval interval, SignalDomain<R> domain) {
        return null;
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> nextMonitor(SpatialTemporalMonitor<S, T, R> m, Interval interval, SignalDomain<T> domain) {
        return null;
    }

    public static <S, T, R> SpatialTemporalMonitor<S, T, R> closureMonitor(SpatialTemporalMonitor<S, T, R> m, Interval interval, SignalDomain<T> domain) {
        return null;
    }
}

