/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.algorithms;

import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.offline.algorithms.BooleanOp;
import eu.quanticol.moonlight.offline.signal.Signal;
import java.util.function.BinaryOperator;

public class UnboundedOperator<T> {
    private final SignalDomain<T> domain;
    private T current;

    UnboundedOperator(SignalDomain<T> domain) {
        this.domain = domain;
    }

    public Signal<T> computeUnbounded(Signal<T> s1, Signal<T> s2, boolean isForward) {
        this.setCurrent(this.domain.min());
        BooleanOp booleanOp = new BooleanOp(isForward);
        BinaryOperator op = (left, right) -> {
            Object value = this.untilOp(left, right, this.getCurrent());
            this.setCurrent(value);
            return value;
        };
        return booleanOp.applyBinary(s1, op, s2);
    }

    private T getCurrent() {
        return this.current;
    }

    private void setCurrent(T value) {
        this.current = value;
    }

    private T untilOp(T left, T right, T previous) {
        return this.domain.disjunction(right, this.domain.conjunction(left, previous));
    }
}

