/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.algorithms;

import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.offline.algorithms.BooleanOp;
import eu.quanticol.moonlight.offline.algorithms.SlidingWindow;
import eu.quanticol.moonlight.offline.algorithms.UnboundedOperator;
import eu.quanticol.moonlight.offline.signal.Signal;
import java.util.function.BinaryOperator;

public class TemporalOp {
    private TemporalOp() {
    }

    public static <T> Signal<T> computeSince(SignalDomain<T> domain, Signal<T> s1, Interval interval, Signal<T> s2) {
        UnboundedOperator<T> operator = new UnboundedOperator<T>(domain);
        Signal<T> unboundedMonitoring = operator.computeUnbounded(s1, s2, true);
        if (interval == null) {
            return unboundedMonitoring;
        }
        Signal<T> onceMonitoring = TemporalOp.computePastSignal(s2, interval, domain::disjunction, domain.max());
        BooleanOp<Object, Object> booleanOp = new BooleanOp<Object, Object>();
        return booleanOp.applyBinary(unboundedMonitoring, domain::conjunction, onceMonitoring);
    }

    public static <T> Signal<T> computeUntil(SignalDomain<T> domain, Signal<T> s1, Interval interval, Signal<T> s2) {
        UnboundedOperator<T> op = new UnboundedOperator<T>(domain);
        Signal<T> unboundedMonitoring = op.computeUnbounded(s1, s2, false);
        if (interval == null) {
            return unboundedMonitoring;
        }
        Signal<T> eventuallyMonitoring = TemporalOp.computeFutureSignal(s2, interval, domain::disjunction, domain.min());
        BooleanOp<Object, Object> booleanOp = new BooleanOp<Object, Object>();
        return booleanOp.applyBinary(unboundedMonitoring, domain::conjunction, eventuallyMonitoring);
    }

    public static <T> Signal<T> computePastSignal(Signal<T> signal, Interval interval, BinaryOperator<T> op, T init) {
        if (interval == null) {
            BooleanOp<Object, Object> booleanOp = new BooleanOp<Object, Object>();
            return booleanOp.applyUnary(signal, x -> op.apply(x, init));
        }
        SlidingWindow<T> sw = new SlidingWindow<T>((Double)interval.getStart(), (Double)interval.getEnd(), op, false);
        return sw.apply(signal);
    }

    public static <T> Signal<T> computeFutureSignal(Signal<T> signal, Interval interval, BinaryOperator<T> op, T init) {
        if (interval == null) {
            BooleanOp<T, T> booleanOp = new BooleanOp<T, T>(false);
            return booleanOp.applyUnaryWithBound(signal, op, init);
        }
        SlidingWindow<T> sw = new SlidingWindow<T>((Double)interval.getStart(), (Double)interval.getEnd(), op, true);
        return sw.apply(signal);
    }
}

