/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.algorithms;

import eu.quanticol.moonlight.offline.signal.Segment;
import eu.quanticol.moonlight.offline.signal.Signal;
import eu.quanticol.moonlight.offline.signal.SignalCursor;
import java.util.function.BinaryOperator;

public class SlidingWindow<R> {
    private final double a;
    private final double size;
    private final boolean isFuture;
    private final BinaryOperator<R> aggregator;

    public SlidingWindow(double a, double b, BinaryOperator<R> aggregator, boolean isFuture) {
        this.a = a;
        this.size = b - a;
        this.aggregator = aggregator;
        this.isFuture = isFuture;
    }

    public Signal<R> apply(Signal<R> s) {
        if (s.isEmpty() || s.getEnd() - s.getStart() < this.size) {
            return new Signal();
        }
        SignalCursor<Double, R> cursor = this.iteratorInit(s);
        Window window = new Window();
        Signal<R> result = this.doSlide(cursor, window);
        this.storeEnding(result, window);
        return result;
    }

    public double size() {
        return this.size;
    }

    protected Signal<R> doSlide(SignalCursor<Double, R> iterator, Window window) {
        Signal result = new Signal();
        while (!iterator.isCompleted()) {
            double time = iterator.getCurrentTime();
            R value = iterator.getCurrentValue();
            while (!window.tryAdd(time, value)) {
                result.add(this.timeOf(window.firstTime()), window.firstValue());
                window.shift(time);
            }
            iterator.forward();
        }
        this.registerLastValidTime(iterator, window);
        return result;
    }

    protected void registerLastValidTime(SignalCursor<Double, R> iter, Window wnd) {
        if (iter.isCompleted() && iter.hasPrevious()) {
            iter.revert();
            double lastTime = iter.nextTime();
            R lastValue = iter.getCurrentValue();
            wnd.tryAdd(lastTime, lastValue);
        }
    }

    protected void storeEnding(Signal<R> result, Window window) {
        if (this.isFuture) {
            result.add(this.timeOf(window.firstTime()), window.firstValue());
        } else {
            result.add(window.end, window.firstValue());
        }
    }

    protected SignalCursor<Double, R> iteratorInit(Signal<R> signal) {
        SignalCursor<Double, R> iterator = signal.getIterator(true);
        iterator.move(signal.getStart() + this.a);
        return iterator;
    }

    protected double timeOf(double t) {
        if (this.isFuture) {
            return t - this.a;
        }
        return t + this.size;
    }

    protected class Window {
        private static final double EPSILON = 1.0E-6;
        private Segment<R> first;
        private Segment<R> last;
        protected double end;

        protected Window() {
        }

        void shift(double time) {
            double nextTime = this.first.getSegmentEnd();
            if (this.firstTime() == nextTime) {
                this.init(time - SlidingWindow.this.size, this.first.getValue());
            } else if (nextTime + SlidingWindow.this.size > time) {
                this.first = this.first.splitAt(time - SlidingWindow.this.size);
            } else {
                this.first = this.first.getNext();
                if (this.first != null) {
                    this.first.setFirst();
                }
            }
        }

        boolean tryAdd(double time, R value) {
            if (this.first == null) {
                this.init(time, value);
            } else {
                if (this.firstTime() < time - SlidingWindow.this.size && this.firstTime() + SlidingWindow.this.size < time) {
                    return false;
                }
                this.update(time, value);
                this.end = time;
            }
            return true;
        }

        double firstTime() {
            return this.first.getStart();
        }

        R firstValue() {
            return this.first.getValue();
        }

        double size() {
            return this.first == null ? 0.0 : this.end - this.firstTime();
        }

        private void update(double time, R value) {
            double insertTime = time;
            Object aggregatedValue = value;
            for (Segment current = this.last; current != null; current = current.getPrevious()) {
                Object newValue;
                Object currentValue = current.getValue();
                if (currentValue.equals(newValue = SlidingWindow.this.aggregator.apply(currentValue, aggregatedValue))) {
                    this.last = current.addAfter(insertTime, aggregatedValue);
                    return;
                }
                insertTime = current.getStart();
                aggregatedValue = newValue;
                this.last = current;
                this.end = insertTime;
            }
            this.init(insertTime, aggregatedValue);
            this.end = time;
        }

        private void init(double time, R value) {
            this.first = new Segment(time, value);
            this.last = this.first;
            this.end = time;
        }

        public String toString() {
            if (this.first == null) {
                return "<>";
            }
            return "< " + this.first.toString() + " - " + this.last.toString() + " : " + this.end + ">";
        }
    }
}

