/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.io.parsing;

import eu.quanticol.moonlight.io.parsing.ParsingStrategy;
import eu.quanticol.moonlight.io.parsing.SignalProcessor;
import eu.quanticol.moonlight.util.MultiValuedTrace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MultiRawTrajectoryExtractor
implements ParsingStrategy<Collection<MultiValuedTrace>> {
    private final int spaceNodes;
    private int timePoints;
    private final SignalProcessor<Float> processor;
    private int signalCount = 0;
    private List<MultiValuedTrace> signals;
    private Float[][] singleSignal;
    private int spaceIterator;

    public MultiRawTrajectoryExtractor(int spaceSize, SignalProcessor<Float> proc) {
        this.spaceNodes = spaceSize;
        this.processor = proc;
    }

    @Override
    public void initialize(String[] header) {
        this.timePoints = header.length;
        this.spaceIterator = 0;
        this.signals = new ArrayList<MultiValuedTrace>();
        this.singleSignal = new Float[this.spaceNodes][this.timePoints];
        this.processor.initializeSpaceTime(this.spaceNodes, this.timePoints);
    }

    @Override
    public void process(String[] data) {
        for (int i = 0; i < this.timePoints; ++i) {
            this.singleSignal[this.spaceIterator][i] = Float.valueOf(Float.parseFloat(data[i]));
        }
        ++this.spaceIterator;
        if (this.spaceIterator == this.spaceNodes) {
            ++this.signalCount;
            this.signals.add(this.processor.generateSignal((Float[][])this.singleSignal));
            this.spaceIterator = 0;
            this.singleSignal = new Float[this.spaceNodes][this.timePoints];
            System.out.println("Completed Processing of " + this.signalCount + " signal.");
        }
    }

    @Override
    public Collection<MultiValuedTrace> result() {
        if (this.spaceIterator > 0) {
            throw new IllegalArgumentException("It seems the input file was missing parts of some trajectories. Please correct the input and retry!");
        }
        return this.signals;
    }

    public int getTimePoints() {
        return this.timePoints;
    }

    public int getSpaceNodes() {
        return this.spaceNodes;
    }
}

