/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.domain;

import eu.quanticol.moonlight.core.base.Pair;
import eu.quanticol.moonlight.core.space.DistanceDomain;

public class PairDistance<D1, D2>
implements DistanceDomain<Pair<D1, D2>> {
    private final DistanceDomain<D1> firstDomain;
    private final DistanceDomain<D2> secondDomain;

    public PairDistance(DistanceDomain<D1> firstDomain, DistanceDomain<D2> secondDomain) {
        this.firstDomain = firstDomain;
        this.secondDomain = secondDomain;
    }

    @Override
    public Pair<D1, D2> zero() {
        return new Pair<D1, D2>(this.firstDomain.zero(), this.secondDomain.zero());
    }

    @Override
    public Pair<D1, D2> infinity() {
        return new Pair<D1, D2>(this.firstDomain.infinity(), this.secondDomain.infinity());
    }

    @Override
    public boolean lessOrEqual(Pair<D1, D2> x, Pair<D1, D2> y) {
        return this.firstDomain.lessOrEqual(x.getFirst(), y.getFirst()) && this.secondDomain.lessOrEqual(x.getSecond(), y.getSecond());
    }

    @Override
    public boolean less(Pair<D1, D2> x, Pair<D1, D2> y) {
        return this.firstDomain.less(x.getFirst(), y.getFirst()) && this.secondDomain.less(x.getSecond(), y.getSecond());
    }

    @Override
    public Pair<D1, D2> sum(Pair<D1, D2> x, Pair<D1, D2> y) {
        return new Pair<D1, D2>(this.firstDomain.sum(x.getFirst(), y.getFirst()), this.secondDomain.sum(x.getSecond(), y.getSecond()));
    }

    @Override
    public boolean equalTo(Pair<D1, D2> x, Pair<D1, D2> y) {
        return this.firstDomain.equalTo(x.getFirst(), y.getFirst()) && this.secondDomain.equalTo(x.getSecond(), y.getSecond());
    }
}

