/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight;

import eu.quanticol.moonlight.TemporalMonitorDefinition;
import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.io.IllegalFileFormatException;
import eu.quanticol.moonlight.io.TemporalSignalReader;
import eu.quanticol.moonlight.io.TemporalSignalWriter;
import eu.quanticol.moonlight.offline.monitoring.temporal.TemporalMonitor;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import eu.quanticol.moonlight.offline.signal.Signal;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class TemporalScriptComponent<S> {
    private final TemporalMonitorDefinition definition;
    private final SignalDomain<S> domain;

    public TemporalScriptComponent(TemporalMonitorDefinition definition, SignalDomain<S> domain) {
        this.definition = definition;
        this.domain = domain;
    }

    public String getName() {
        return this.definition.getName();
    }

    public TemporalMonitor<MoonLightRecord, S> getMonitorFromString(String ... values) {
        return this.definition.getMonitorFromString(this.domain, values);
    }

    public TemporalMonitor<MoonLightRecord, S> getMonitorFromDouble(double ... values) {
        return this.definition.getMonitorFromDouble(this.domain, values);
    }

    public TemporalMonitor<MoonLightRecord, S> getMonitorFromObject(Object ... values) {
        return this.definition.getMonitorFromObject(this.domain, values);
    }

    public Signal<S> monitor(Signal<MoonLightRecord> input, String ... values) {
        TemporalMonitor<MoonLightRecord, S> monitor = this.getMonitorFromString(values);
        return monitor.monitor(input);
    }

    public Signal<S> monitor(Signal<MoonLightRecord> input, Object ... values) {
        TemporalMonitor<MoonLightRecord, S> monitor = this.getMonitorFromObject(values);
        return monitor.monitor(input);
    }

    public Signal<S> monitor(Signal<MoonLightRecord> input, double ... values) {
        TemporalMonitor<MoonLightRecord, S> monitor = this.getMonitorFromDouble(values);
        return monitor.monitor(input);
    }

    public double[][] monitorToArray(Signal<MoonLightRecord> input, String ... values) {
        return this.monitor(input, values).arrayOf(this.domain.getDataHandler()::doubleOf);
    }

    public double[][] monitorToArray(Signal<MoonLightRecord> input, double ... values) {
        return this.monitor(input, values).arrayOf(this.domain.getDataHandler()::doubleOf);
    }

    public double[][] monitorToArray(double[] time, String[][] signal, String ... values) {
        return this.monitorToArray(RecordHandler.buildTemporalSignal(this.definition.getSignalRecordHandler(), time, signal), values);
    }

    public double[][] monitorToArray(double[] time, double[][] signal, double ... values) {
        return this.monitorToArray(RecordHandler.buildTemporalSignal(this.definition.getSignalRecordHandler(), time, signal), values);
    }

    public void monitorToFile(TemporalSignalWriter writer, File output, Signal<MoonLightRecord> input, String ... values) throws IOException {
        Signal<S> signal = this.monitor(input, values);
        writer.write(this.domain.getDataHandler(), signal, output);
    }

    public void monitor(TemporalSignalReader reader, File input, TemporalSignalWriter writer, File output, String ... values) throws IOException, IllegalFileFormatException {
        this.monitorToFile(writer, output, reader.load(this.definition.getSignalRecordHandler(), input), values);
    }

    public String getInfo() {
        return this.getName() + Arrays.toString(this.getVariables());
    }

    public String[] getVariables() {
        return this.definition.getArguments().getVariables();
    }

    public RecordHandler getSignalHandler() {
        return this.definition.getSignalRecordHandler();
    }
}

