/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight;

import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.core.io.SerializableData;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.offline.monitoring.temporal.TemporalMonitor;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

@FunctionalInterface
public interface TemporalMonitorProducer {
    public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> var1, MoonLightRecord var2);

    public static TemporalMonitorProducer produceImplication(final TemporalMonitorProducer left, final TemporalMonitorProducer right) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.impliesMonitor(left.apply(domain, args), domain, right.apply(domain, args));
            }
        };
    }

    public static TemporalMonitorProducer produceAtomic(final BiFunction<MoonLightRecord, MoonLightRecord, Double> atomic) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.atomicMonitor(s -> domain.valueOf((Double)atomic.apply(args, s)));
            }
        };
    }

    public static TemporalMonitorProducer produceAtomic(final BiFunction<MoonLightRecord, MoonLightRecord, Double> left, final String op, final BiFunction<MoonLightRecord, MoonLightRecord, Double> right) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.atomicMonitor(s -> SerializableData.getOperator(domain, op).apply((Double)left.apply(args, s), (Double)right.apply(args, s)));
            }
        };
    }

    public static TemporalMonitorProducer produceAnd(final TemporalMonitorProducer left, final TemporalMonitorProducer right) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.andMonitor(left.apply(domain, args), domain, right.apply(domain, args));
            }
        };
    }

    public static TemporalMonitorProducer produceOr(final TemporalMonitorProducer left, final TemporalMonitorProducer right) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.orMonitor(left.apply(domain, args), domain, right.apply(domain, args));
            }
        };
    }

    public static TemporalMonitorProducer produceNegation(final TemporalMonitorProducer arg) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.notMonitor(arg.apply(domain, args), domain);
            }
        };
    }

    public static TemporalMonitorProducer produceFalse() {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.atomicMonitor(v -> domain.min());
            }
        };
    }

    public static TemporalMonitorProducer produceTrue() {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.atomicMonitor(v -> domain.max());
            }
        };
    }

    public static TemporalMonitorProducer produceOnce(final TemporalMonitorProducer arg) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.onceMonitor(arg.apply(domain, args), domain);
            }
        };
    }

    public static TemporalMonitorProducer produceHistorically(final TemporalMonitorProducer arg) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.historicallyMonitor(arg.apply(domain, args), domain);
            }
        };
    }

    public static TemporalMonitorProducer produceEventually(final TemporalMonitorProducer arg) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.eventuallyMonitor(arg.apply(domain, args), domain);
            }
        };
    }

    public static TemporalMonitorProducer produceGlobally(final TemporalMonitorProducer arg) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.globallyMonitor(arg.apply(domain, args), domain);
            }
        };
    }

    public static TemporalMonitorProducer produceOnce(final TemporalMonitorProducer arg, final Function<MoonLightRecord, Interval> interval) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.onceMonitor(arg.apply(domain, args), domain, (Interval)interval.apply(args));
            }
        };
    }

    public static TemporalMonitorProducer produceHistorically(final TemporalMonitorProducer arg, final Function<MoonLightRecord, Interval> interval) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.historicallyMonitor(arg.apply(domain, args), domain, (Interval)interval.apply(args));
            }
        };
    }

    public static TemporalMonitorProducer produceEventually(final TemporalMonitorProducer arg, final Function<MoonLightRecord, Interval> interval) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.eventuallyMonitor(arg.apply(domain, args), domain, (Interval)interval.apply(args));
            }
        };
    }

    public static TemporalMonitorProducer produceGlobally(final TemporalMonitorProducer arg, final Function<MoonLightRecord, Interval> interval) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.globallyMonitor(arg.apply(domain, args), domain, (Interval)interval.apply(args));
            }
        };
    }

    public static TemporalMonitorProducer produceUntil(final TemporalMonitorProducer left, final TemporalMonitorProducer right) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.untilMonitor(left.apply(domain, args), right.apply(domain, args), domain);
            }
        };
    }

    public static TemporalMonitorProducer produceUntil(final TemporalMonitorProducer left, final Function<MoonLightRecord, Interval> interval, final TemporalMonitorProducer right) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.untilMonitor(left.apply(domain, args), (Interval)interval.apply(args), right.apply(domain, args), domain);
            }
        };
    }

    public static TemporalMonitorProducer produceSince(final TemporalMonitorProducer left, final TemporalMonitorProducer right) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.sinceMonitor(left.apply(domain, args), right.apply(domain, args), domain);
            }
        };
    }

    public static TemporalMonitorProducer produceSince(final TemporalMonitorProducer left, final Function<MoonLightRecord, Interval> interval, final TemporalMonitorProducer right) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return TemporalMonitor.sinceMonitor(left.apply(domain, args), (Interval)interval.apply(args), right.apply(domain, args), domain);
            }
        };
    }

    public static TemporalMonitorProducer produceCall(final TemporalMonitorProducer temporalMonitorProducer, final RecordHandler callee, final List<Function<MoonLightRecord, Double>> functionArgument) {
        return new TemporalMonitorProducer(){

            @Override
            public <S> TemporalMonitor<MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return temporalMonitorProducer.apply(domain, callee.fromDoubleArray(functionArgument.stream().mapToDouble(f -> (Double)f.apply(args)).toArray()));
            }
        };
    }
}

