/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight;

import eu.quanticol.moonlight.TemporalMonitorProducer;
import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.offline.monitoring.temporal.TemporalMonitor;
import eu.quanticol.moonlight.offline.signal.RecordHandler;

public class TemporalMonitorDefinition {
    private final String name;
    private final RecordHandler arguments;
    private final RecordHandler signalRecordHandler;
    private final TemporalMonitorProducer producer;

    public TemporalMonitorDefinition(String name, RecordHandler arguments, RecordHandler signalRecordHandler, TemporalMonitorProducer producer) {
        this.name = name;
        this.arguments = arguments;
        this.signalRecordHandler = signalRecordHandler;
        this.producer = producer;
    }

    public String getName() {
        return this.name;
    }

    public RecordHandler getArguments() {
        return this.arguments;
    }

    public TemporalMonitorProducer getProducer() {
        return this.producer;
    }

    public <S> TemporalMonitor<MoonLightRecord, S> getMonitor(SignalDomain<S> domain, MoonLightRecord arguments) {
        return this.producer.apply(domain, arguments);
    }

    public <S> TemporalMonitor<MoonLightRecord, S> getMonitorFromString(SignalDomain<S> domain, String[] values) {
        return this.getMonitor(domain, this.arguments.fromStringArray(values));
    }

    public <S> TemporalMonitor<MoonLightRecord, S> getMonitorFromDouble(SignalDomain<S> domain, double[] values) {
        return this.getMonitor(domain, this.evalArgumentFromDoubleArray(values));
    }

    private MoonLightRecord evalArgumentFromDoubleArray(double[] values) {
        if (this.arguments == null) {
            return null;
        }
        if (values == null) {
            values = new double[]{};
        }
        return this.arguments.fromDoubleArray(values);
    }

    public <S> TemporalMonitor<MoonLightRecord, S> getMonitorFromObject(SignalDomain<S> domain, Object[] values) {
        return this.getMonitor(domain, this.arguments.fromObjectArray(values));
    }

    public RecordHandler getSignalRecordHandler() {
        return this.signalRecordHandler;
    }
}

