""" Collect all svn release numbers from the standard input and print a list
of restructured text hyperlink targets pointing to the corresponding Plone
Collective changeset. The release numbers must begin with 'r' followed by the
commit number, e.g. r74523 for commit number 74523.

:authors: - Jan Hackel <plonecode@hackel.name>
"""

import re
import sys

# svn commits are written like r43422
svnCommit = re.compile(r'r(\d+)_?')
autoListStart = r'.. autogenerated link list'
autoListStartRex = re.compile(autoListStart)
autoListEnd = r'.. end of autogenerated link list'
autoListEndRex = re.compile(autoListEnd)
changeset = []

def killAutoList():
    """Skips a previously generated link list in the standard input.
    """
    for line in sys.stdin:
        if autoListEndRex.match(line):
            break

for line in sys.stdin:
    if autoListStartRex.match(line):
        killAutoList()
    else:
        print svnCommit.sub(r"r\1_", line),
        for match in svnCommit.finditer(line):
            changeset.append( match.group(1) )


print autoListStart
print
for c in sorted(set(changeset)):
    print ".. _r%s: http://dev.plone.org/collective/changeset/%s" % (c,c)
print autoListEnd

    
