# MOVEKIT

**Simple and effective tools for the analysis of movement data**

*Movekit* is an open-source software package for the processing and analysis of movement data, including modules for:

- Data pre-processing (e.g. data checks, smoothing, duplicate removal, interpolation, outlier detection)
- Feature extraction (e.g. speed, acceleration, heading)
- Individual-level movement analysis (e.g. autocorrelation, speed distribution, environment exploration)
- Group-level analysis (e.g. cohesion, polarisation, coordination, leadership)

## Installation
The easiest way to install *movekit* is by using `pip` :

    pip install movekit

## Usage
You can view a demo of common features in this
[Jupyter Notebook](https://github.com/dbvis-ukon/movekit/blob/master/examples/demo.ipynb).

## Development
For an overview of version changes see the [CHANGELOG](https://github.com/dbvis-ukon/movekit/blob/master/CHANGELOG.rst).

Please submit bugs or feature requests to the GitHub issue tracker [here](https://github.com/dbvis-ukon/movekit/issues).

## License
This package was developed by Eren Cakmak, Lukas Weixler, Arjun Majumdar, Jolle Jolles, and Daniel Keim from the [Data Analysis and Visualization Group](https://www.vis.uni-konstanz.de/) and the [Department of Collective Behaviour](http://collectivebehaviour.com) at the University Konstanz, funded by the Deutsche Forschungsgemeinschaft (DFG, German Research Foundation) under Germany's Excellence Strategy – EXC 2117 – 422037984“

Released under a GNU General Public License. See the [LICENSE](LICENSE) file for details.