# coding utf8
import setuptools
from local_reassembly.versions import get_versions

with open('README.md') as f:
    LONG_DESCRIPTION = f.read()

setuptools.setup(
    name="local_reassembly",
    version=get_versions(),
    author="Yuxing Xu",
    author_email="xuyuxing@mail.kib.ac.cn",
    description="Locally reassembling haplotypes from BAM files generated by WGS data.",
    long_description=LONG_DESCRIPTION,
    long_description_content_type='text/markdown',
    url="https://github.com/SouthernCD/local_reassembly",
    include_package_data = True,

    entry_points={
        "console_scripts": ["reloc = local_reassembly.cli:main"]
    },    

    packages=setuptools.find_packages(),

    install_requires=[
        "biopython==1.80",
        "bcbio-gff==0.7.1",
    ],

    python_requires='>=3.5',
)