import os


def get_test_client():
    from grai_client.endpoints.v1.client import ClientV1

    host = os.environ.get("GRAI_HOST", "localhost")
    port = os.environ.get("GRAI_PORT", "8000")
    username = os.environ.get("GRAI_USERNAME", "null@grai.io")
    password = os.environ.get("GRAI_PASSWORD", "super_secret")

    client = ClientV1(host, port)
    client.set_authentication_headers(username=username, password=password)
    return client
