"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemoryDB = exports.RedisDB = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
function setupVpc(parent, props) {
    return props.existingVpc ?? new aws_cdk_lib_1.aws_ec2.Vpc(parent, 'Vpc', {
        subnetConfiguration: [
            {
                cidrMask: 24,
                name: 'Public Subnet',
                subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PUBLIC,
            },
            {
                cidrMask: 24,
                name: 'Isolated Subnet',
                subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_ISOLATED,
            },
        ],
    });
}
class RedisDB extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        let isolatedSubnets = [];
        let redisVpc = setupVpc(this, props);
        redisVpc.isolatedSubnets.forEach(function (value) {
            isolatedSubnets.push(value.subnetId);
        });
        if (isolatedSubnets.length == 0) {
            redisVpc.privateSubnets.forEach(function (value) {
                isolatedSubnets.push(value.subnetId);
            });
        }
        const ecSecurityGroup = props.existingSecurityGroup ?? new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, id + '-RedisDB-SG', {
            vpc: redisVpc,
            description: 'SecurityGroup associated with RedisDB Cluster ' + id,
            allowAllOutbound: false,
        });
        let groupName;
        let ecSubnetGroup;
        if (!props.existingSubnetGroupName) {
            ecSubnetGroup = new aws_cdk_lib_1.aws_elasticache.CfnSubnetGroup(this, id + '-RedisDB-SubnetGroup', {
                description: 'RedisDB Subnet Group',
                subnetIds: isolatedSubnets,
                cacheSubnetGroupName: props.subnetGroupName || 'RedisDBSubnetGroup',
            });
            groupName = ecSubnetGroup.cacheSubnetGroupName;
        }
        else {
            groupName = props.existingSubnetGroupName;
        }
        let elasticacheReplicationGroupName = id + '-RedisDB';
        let redis_cluster = new aws_cdk_lib_1.aws_elasticache.CfnReplicationGroup(this, elasticacheReplicationGroupName, {
            numNodeGroups: props.nodes || 1,
            cacheNodeType: props.nodeType || 'cache.m6g.large',
            engine: 'Redis',
            multiAzEnabled: false,
            autoMinorVersionUpgrade: false,
            cacheParameterGroupName: props.parameterGroupName ?? 'default.redis6.x.cluster.on',
            engineVersion: props.engineVersion ?? '6.x',
            cacheSubnetGroupName: groupName,
            securityGroupIds: [ecSecurityGroup.securityGroupId],
            replicationGroupDescription: 'RedisDB setup by CDK',
            atRestEncryptionEnabled: props.atRestEncryptionEnabled,
            transitEncryptionEnabled: props.transitEncryptionEnabled,
            replicasPerNodeGroup: props.replicas || 0,
            authToken: props.authToken,
        });
        this.replicationGroup = redis_cluster;
        if (!props.existingSubnetGroupName) {
            redis_cluster.node.addDependency(ecSubnetGroup);
        }
        if (typeof props.memoryAutoscalingTarget == 'number') {
            const target = new aws_cdk_lib_1.aws_applicationautoscaling.ScalableTarget(this, 'ScalableTarget', {
                serviceNamespace: aws_cdk_lib_1.aws_applicationautoscaling.ServiceNamespace.ELASTICACHE,
                resourceId: 'replication-group/' + redis_cluster.ref,
                scalableDimension: 'elasticache:replication-group:NodeGroups',
                maxCapacity: props.nodes || 1 * 3,
                minCapacity: props.nodes || 1,
            });
            target.scaleToTrackMetric('MemTracking', {
                targetValue: props.memoryAutoscalingTarget,
                predefinedMetric: aws_cdk_lib_1.aws_applicationautoscaling.PredefinedMetric.ELASTICACHE_DATABASE_MEMORY_USAGE_COUNTED_FOR_EVICT_PERCENTAGE,
            });
        }
        else if (typeof props.replicasCpuAutoscalingTarget == 'number') {
            const target = new aws_cdk_lib_1.aws_applicationautoscaling.ScalableTarget(this, 'ScalableTarget', {
                serviceNamespace: aws_cdk_lib_1.aws_applicationautoscaling.ServiceNamespace.ELASTICACHE,
                resourceId: 'replication-group/' + redis_cluster.ref,
                scalableDimension: 'elasticache:replication-group:group:Replicas',
                maxCapacity: props.nodes || 1 * 3,
                minCapacity: props.nodes || 1,
            });
            target.scaleToTrackMetric('CpuTracking', {
                targetValue: props.replicasCpuAutoscalingTarget,
                predefinedMetric: aws_cdk_lib_1.aws_applicationautoscaling.PredefinedMetric.ELASTICACHE_PRIMARY_ENGINE_CPU_UTILIZATION,
            });
        }
        else if (typeof props.nodesCpuAutoscalingTarget == 'number') {
            const target = new aws_cdk_lib_1.aws_applicationautoscaling.ScalableTarget(this, 'ScalableTarget', {
                serviceNamespace: aws_cdk_lib_1.aws_applicationautoscaling.ServiceNamespace.ELASTICACHE,
                resourceId: 'replication-group/' + redis_cluster.ref,
                scalableDimension: 'elasticache:replication-group:NodeGroups',
                maxCapacity: props.nodes || 1 * 3,
                minCapacity: props.nodes || 1,
            });
            target.scaleToTrackMetric('CpuTracking', {
                targetValue: props.nodesCpuAutoscalingTarget,
                predefinedMetric: aws_cdk_lib_1.aws_applicationautoscaling.PredefinedMetric.ELASTICACHE_PRIMARY_ENGINE_CPU_UTILIZATION,
            });
        }
    }
}
exports.RedisDB = RedisDB;
_a = JSII_RTTI_SYMBOL_1;
RedisDB[_a] = { fqn: "cdk-redisdb.RedisDB", version: "0.0.19" };
class MemoryDB extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        let isolatedSubnets = [];
        let redisVpc = setupVpc(this, props);
        redisVpc.isolatedSubnets.forEach(function (value) {
            isolatedSubnets.push(value.subnetId);
        });
        const ecSecurityGroup = props.existingSecurityGroup ?? new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, id + '-RedisDB-SG', {
            vpc: redisVpc,
            description: 'SecurityGroup associated with RedisDB Cluster ' + id,
            allowAllOutbound: false,
        });
        let groupName;
        let ecSubnetGroup;
        if (!props.existingSubnetGroupName) {
            ecSubnetGroup = new aws_cdk_lib_1.aws_memorydb.CfnSubnetGroup(this, id + '-RedisDB-SubnetGroup', {
                description: 'RedisDB Subnet Group',
                subnetIds: isolatedSubnets,
                subnetGroupName: props.subnetGroupName || 'memorydbsubnetgroup',
            });
            groupName = ecSubnetGroup.subnetGroupName;
        }
        else {
            groupName = props.existingSubnetGroupName;
        }
        /*
        const cfnUser = new memorydb.CfnUser(this, 'memorydb-user', {
          accessString: 'on ~* +@all',
          authenticationMode: {"Passwords":["*****hunter2*****"],"Type":"password"},
          userName: 'admin',
        });
        const cfnACL = new memorydb.CfnACL(this, 'memorydb-acl', {
          aclName: 'myacl',
          userNames: ['admin'],
        });
        */
        const memorydb_cluster = new aws_cdk_lib_1.aws_memorydb.CfnCluster(this, 'memorydb', {
            aclName: 'open-access',
            clusterName: 'clustername',
            nodeType: props.nodeType || 'db.t4g.small',
            autoMinorVersionUpgrade: false,
            description: 'description',
            engineVersion: props.engineVersion ?? '6.2',
            numShards: props.nodes || 1,
            numReplicasPerShard: props.replicas || 0,
            securityGroupIds: [ecSecurityGroup.securityGroupId],
            subnetGroupName: groupName,
            tlsEnabled: true,
        });
        if (!props.existingSubnetGroupName) {
            memorydb_cluster.node.addDependency(ecSubnetGroup);
        }
        this.cluster = memorydb_cluster;
        //memorydb_cluster.node.addDependency(cfnACL);
        //cfnACL.node.addDependency(cfnUser);
    }
}
exports.MemoryDB = MemoryDB;
_b = JSII_RTTI_SYMBOL_1;
MemoryDB[_b] = { fqn: "cdk-redisdb.MemoryDB", version: "0.0.19" };
//# sourceMappingURL=data:application/json;base64,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