import * as elbv2 from '@aws-cdk/aws-elasticloadbalancingv2';
import * as cdk from '@aws-cdk/core';
import { BaseFargateService, BaseFargateServiceProps } from './main';
/**
 * @stability stable
 */
export interface DualNlbFargateServiceProps extends BaseFargateServiceProps {
}
/**
 * @stability stable
 */
export declare class DualNlbFargateService extends BaseFargateService {
    /**
     * The external Nlb.
     *
     * @stability stable
     */
    readonly externalNlb?: elbv2.NetworkLoadBalancer;
    /**
     * The internal Nlb.
     *
     * @stability stable
     */
    readonly internalNlb?: elbv2.NetworkLoadBalancer;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: DualNlbFargateServiceProps);
}
