"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnUserMemberOfGroup = exports.CfnUserMemberOfGroupPropsAccessLevel = exports.toJson_CfnUserMemberOfGroupProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnUserMemberOfGroupProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnUserMemberOfGroupProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'GroupId': obj.groupId,
        'UserId': obj.userId,
        'Username': obj.username,
        'AccessLevel': obj.accessLevel,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnUserMemberOfGroupProps = toJson_CfnUserMemberOfGroupProps;
/* eslint-enable max-len, quote-props */
/**
 * The access level to grant to this user in the group, e.g. 'Guest', 'Developer', or 'Maintainer'. Note the GitLab API may not allow all values.
 *
 * @schema CfnUserMemberOfGroupPropsAccessLevel
 */
var CfnUserMemberOfGroupPropsAccessLevel;
(function (CfnUserMemberOfGroupPropsAccessLevel) {
    /** None */
    CfnUserMemberOfGroupPropsAccessLevel["NONE"] = "None";
    /** Minimal Access */
    CfnUserMemberOfGroupPropsAccessLevel["MINIMAL_ACCESS"] = "Minimal Access";
    /** Guest */
    CfnUserMemberOfGroupPropsAccessLevel["GUEST"] = "Guest";
    /** Reporter */
    CfnUserMemberOfGroupPropsAccessLevel["REPORTER"] = "Reporter";
    /** Developer */
    CfnUserMemberOfGroupPropsAccessLevel["DEVELOPER"] = "Developer";
    /** Maintainer */
    CfnUserMemberOfGroupPropsAccessLevel["MAINTAINER"] = "Maintainer";
    /** Owner */
    CfnUserMemberOfGroupPropsAccessLevel["OWNER"] = "Owner";
    /** Admin */
    CfnUserMemberOfGroupPropsAccessLevel["ADMIN"] = "Admin";
})(CfnUserMemberOfGroupPropsAccessLevel = exports.CfnUserMemberOfGroupPropsAccessLevel || (exports.CfnUserMemberOfGroupPropsAccessLevel = {}));
/**
 * A CloudFormation `GitLab::Groups::UserMemberOfGroup`
 *
 * @cloudformationResource GitLab::Groups::UserMemberOfGroup
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
 */
class CfnUserMemberOfGroup extends cdk.CfnResource {
    /**
     * Create a new `GitLab::Groups::UserMemberOfGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserMemberOfGroup.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnUserMemberOfGroupProps(props) });
        this.props = props;
        this.attrMembershipId = cdk.Token.asString(this.getAtt('MembershipId'));
    }
}
exports.CfnUserMemberOfGroup = CfnUserMemberOfGroup;
_a = JSII_RTTI_SYMBOL_1;
CfnUserMemberOfGroup[_a] = { fqn: "@cdk-cloudformation/gitlab-groups-usermemberofgroup.CfnUserMemberOfGroup", version: "1.0.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnUserMemberOfGroup.CFN_RESOURCE_TYPE_NAME = "GitLab::Groups::UserMemberOfGroup";
//# sourceMappingURL=data:application/json;base64,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