import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Adds a user as a member of a GitLab group
 *
 * @schema CfnUserMemberOfGroupProps
 */
export interface CfnUserMemberOfGroupProps {
    /**
     * ID of the group to which the user should be added
     *
     * @schema CfnUserMemberOfGroupProps#GroupId
     */
    readonly groupId: number;
    /**
     * ID (numeric) of the user to add to the group. Either this or Username but not both should be supplied.
     *
     * @schema CfnUserMemberOfGroupProps#UserId
     */
    readonly userId?: number;
    /**
     * Username (handle, e.g. often written starting with '@') of the user to add to the group. Either this or the UserId but not both should be supplied.
     *
     * @schema CfnUserMemberOfGroupProps#Username
     */
    readonly username?: string;
    /**
     * The access level to grant to this user in the group, e.g. 'Guest', 'Developer', or 'Maintainer'. Note the GitLab API may not allow all values.
     *
     * @schema CfnUserMemberOfGroupProps#AccessLevel
     */
    readonly accessLevel: CfnUserMemberOfGroupPropsAccessLevel;
}
/**
 * Converts an object of type 'CfnUserMemberOfGroupProps' to JSON representation.
 */
export declare function toJson_CfnUserMemberOfGroupProps(obj: CfnUserMemberOfGroupProps | undefined): Record<string, any> | undefined;
/**
 * The access level to grant to this user in the group, e.g. 'Guest', 'Developer', or 'Maintainer'. Note the GitLab API may not allow all values.
 *
 * @schema CfnUserMemberOfGroupPropsAccessLevel
 */
export declare enum CfnUserMemberOfGroupPropsAccessLevel {
    /** None */
    NONE = "None",
    /** Minimal Access */
    MINIMAL_ACCESS = "Minimal Access",
    /** Guest */
    GUEST = "Guest",
    /** Reporter */
    REPORTER = "Reporter",
    /** Developer */
    DEVELOPER = "Developer",
    /** Maintainer */
    MAINTAINER = "Maintainer",
    /** Owner */
    OWNER = "Owner",
    /** Admin */
    ADMIN = "Admin"
}
/**
 * A CloudFormation `GitLab::Groups::UserMemberOfGroup`
 *
 * @cloudformationResource GitLab::Groups::UserMemberOfGroup
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
 */
export declare class CfnUserMemberOfGroup extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "GitLab::Groups::UserMemberOfGroup";
    /**
     * Resource props.
     */
    readonly props: CfnUserMemberOfGroupProps;
    /**
     * Attribute `GitLab::Groups::UserMemberOfGroup.MembershipId`
     * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
     */
    readonly attrMembershipId: string;
    /**
     * Create a new `GitLab::Groups::UserMemberOfGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnUserMemberOfGroupProps);
}
