"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const resourcegroups = require("aws-cdk-lib/aws-resourcegroups");
const utils = require("./common/utils");
class BaseStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.stage = props.stage;
    }
    addBaseTags(model, props) {
        utils.addBaseTags(model, props);
    }
    createResourcesGroup() {
        let cfnGroup = new resourcegroups.CfnGroup(this, `resources-group-${this.stackName}`, {
            name: this.stackName,
            resourceQuery: {
                query: {
                    stackIdentifier: this.stackId,
                },
            },
        });
        return cfnGroup;
    }
}
exports.BaseStack = BaseStack;
_a = JSII_RTTI_SYMBOL_1;
BaseStack[_a] = { fqn: "neulabs-cdk-constructs.stack.BaseStack", version: "0.1.11" };
//# sourceMappingURL=data:application/json;base64,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