"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NewRelicFunction = exports.Function = exports.addNewRelicLayer = exports.getNewRelicLayer = exports.NEW_RELIC_LAYERS_ACCOUNT_ID = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const env_1 = require("../../common/env");
const env = require("../../common/env");
const utils_1 = require("../../common/utils");
exports.NEW_RELIC_LAYERS_ACCOUNT_ID = '451483290750'; // AWS account id of NewRelic where exposed layers https://layers.newrelic-external.com/
function getNewRelicLayer(scope, functionName, layerName, layerVersion, region) {
    return lambda.LayerVersion.fromLayerVersionArn(scope, `new-relic-layer-${functionName}`, `arn:aws:lambda:${region}:${exports.NEW_RELIC_LAYERS_ACCOUNT_ID}:layer:${layerName}:${layerVersion}`);
}
exports.getNewRelicLayer = getNewRelicLayer;
function addNewRelicLayer(scope, lambdaFunction, props) {
    lambdaFunction.addToRolePolicy(new iam.PolicyStatement({
        actions: ['secretsmanager:GetSecretValue'],
        resources: [`arn:aws:secretsmanager:eu-west-1:${env_1.CDK_ACCOUNT_ID}:secret:NEW_RELIC_LICENSE_KEY-??????`],
    }));
    lambdaFunction.addEnvironment('NEW_RELIC_ACCOUNT_ID', props.newRelicAccountId);
    lambdaFunction.addEnvironment('NEW_RELIC_LAMBDA_HANDLER', props.handler);
    lambdaFunction.addEnvironment('NEW_RELIC_LAMBDA_EXTENSION_ENABLED', 'true');
    if (props.newRelicwithExtensionSendLogs) {
        lambdaFunction.addEnvironment('NEW_RELIC_EXTENSION_SEND_FUNCTION_LOGS', 'true');
    }
    const layer = getNewRelicLayer(scope, lambdaFunction.functionName, props.newRelicLayerName, props.newRelicLayerVersion, env_1.CDK_REGION);
    lambdaFunction.addLayers(layer);
}
exports.addNewRelicLayer = addNewRelicLayer;
class Function extends lambda.Function {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.stage = props.stage;
        if (props.withBaseEnvironment) {
            this.addBaseEnvironment();
        }
        if (props.withBaseTags) {
            this.addBaseTags();
        }
    }
    addBaseTags() {
        utils_1.addBaseTags(this);
    }
    addBaseEnvironment() {
        this.addEnvironment('ENVIRONMENT', this.stage);
        this.addEnvironment('TIMESTAMP_DEPLOY_CDK', env.TIMESTAMP_DEPLOY_CDK);
        if (env.BUSINESS_UNIT) {
            this.addEnvironment('BUSINESS_UNIT', env.BUSINESS_UNIT);
        }
        if (env.DOMAIN) {
            this.addEnvironment('DOMAIN', env.DOMAIN);
        }
        if (env.REPOSITORY_NAME) {
            this.addEnvironment('REPOSITORY_NAME', env.REPOSITORY_NAME);
        }
        if (env.REPOSITORY_VERSION) {
            this.addEnvironment('REPOSITORY_VERSION', env.REPOSITORY_VERSION);
        }
    }
}
exports.Function = Function;
_a = JSII_RTTI_SYMBOL_1;
Function[_a] = { fqn: "neulabs-cdk-constructs.aws_lambda.Function", version: "0.1.11" };
class NewRelicFunction extends Function {
    constructor(scope, id, props) {
        const app_handler = props.handler;
        const handler = 'newrelic_lambda_wrapper.handler';
        super(scope, id, { ...props, handler });
        addNewRelicLayer(scope, this, {
            handler: app_handler,
            newRelicLayerName: props.newRelicLayerName,
            newRelicLayerVersion: props.newRelicLayerVersion,
            newRelicAccountId: props.newRelicAccountId,
            newRelicwithExtensionSendLogs: props.newRelicwithExtensionSendLogs,
        });
    }
}
exports.NewRelicFunction = NewRelicFunction;
_b = JSII_RTTI_SYMBOL_1;
NewRelicFunction[_b] = { fqn: "neulabs-cdk-constructs.aws_lambda.NewRelicFunction", version: "0.1.11" };
//# sourceMappingURL=data:application/json;base64,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