# Generated by Django 3.0.10 on 2020-11-07 18:31

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('fsmedhro_core', '0002_alter_field_user_on_fachschaftuser'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Dozent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('titel', models.CharField(blank=True, max_length=30)),
                ('vorname', models.CharField(blank=True, max_length=60)),
                ('nachname', models.CharField(max_length=100)),
                ('aktiv', models.BooleanField(default=True)),
            ],
            options={
                'verbose_name': 'Dozent',
                'verbose_name_plural': 'Dozenten',
                'ordering': ('nachname',),
            },
        ),
        migrations.CreateModel(
            name='Fach',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
            ],
            options={
                'verbose_name': 'Fach',
                'verbose_name_plural': 'Fächer',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Testat',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('active', models.BooleanField(default=True)),
                ('fach', models.ManyToManyField(to='exoral.Fach')),
                ('studienabschnitt', models.ManyToManyField(to='fsmedhro_core.Studienabschnitt')),
                ('studiengang', models.ManyToManyField(to='fsmedhro_core.Studiengang')),
            ],
            options={
                'verbose_name': 'Testat',
                'verbose_name_plural': 'Testate',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Frage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('datum', models.DateField(default=datetime.date.today, verbose_name='Prüfungsdatum')),
                ('text', models.TextField()),
                ('antwort', models.TextField(blank=True)),
                ('punkte', models.PositiveIntegerField(default=1)),
                ('abgestimmte_benutzer', models.ManyToManyField(to=settings.AUTH_USER_MODEL)),
                ('pruefer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='exoral.Dozent', verbose_name='PrüferIn')),
                ('testat', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='exoral.Testat', verbose_name='Testat/Prüfung')),
            ],
            options={
                'verbose_name': 'Frage',
                'verbose_name_plural': 'Fragen',
            },
        ),
        migrations.AddField(
            model_name='dozent',
            name='fach',
            field=models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, to='exoral.Fach'),
        ),
    ]
