"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.jenkinsArtifactsBounds = exports.JenkinsProvider = exports.BaseJenkinsProvider = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("@aws-cdk/aws-codepipeline");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("@aws-cdk/core");
class BaseJenkinsProvider extends core_1.Construct {
    constructor(scope, id, version) {
        super(scope, id);
        this.version = version || '1';
    }
}
exports.BaseJenkinsProvider = BaseJenkinsProvider;
_a = JSII_RTTI_SYMBOL_1;
BaseJenkinsProvider[_a] = { fqn: "@aws-cdk/aws-codepipeline-actions.BaseJenkinsProvider", version: "1.184.1" };
/**
 * A class representing Jenkins providers.
 *
 * @see #import
 */
class JenkinsProvider extends BaseJenkinsProvider {
    constructor(scope, id, props) {
        super(scope, id, props.version);
        this.buildIncluded = false;
        this.testIncluded = false;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_actions_JenkinsProviderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, JenkinsProvider);
            }
            throw error;
        }
        this.providerName = props.providerName;
        this.serverUrl = props.serverUrl;
        if (props.forBuild === true) {
            this._registerBuildProvider();
        }
        if (props.forTest === true) {
            this._registerTestProvider();
        }
    }
    /**
     * Import a Jenkins provider registered either outside the CDK,
     * or in a different CDK Stack.
     *
     * @param scope the parent Construct for the new provider
     * @param id the identifier of the new provider Construct
     * @param attrs the properties used to identify the existing provider
     * @returns a new Construct representing a reference to an existing Jenkins provider
     */
    static fromJenkinsProviderAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_actions_JenkinsProviderAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromJenkinsProviderAttributes);
            }
            throw error;
        }
        return new ImportedJenkinsProvider(scope, id, attrs);
    }
    /**
     * @internal
     */
    _registerBuildProvider() {
        if (this.buildIncluded) {
            return;
        }
        this.buildIncluded = true;
        this.registerJenkinsCustomAction('JenkinsBuildProviderResource', codepipeline.ActionCategory.BUILD);
    }
    /**
     * @internal
     */
    _registerTestProvider() {
        if (this.testIncluded) {
            return;
        }
        this.testIncluded = true;
        this.registerJenkinsCustomAction('JenkinsTestProviderResource', codepipeline.ActionCategory.TEST);
    }
    registerJenkinsCustomAction(id, category) {
        new codepipeline.CustomActionRegistration(this, id, {
            category,
            artifactBounds: exports.jenkinsArtifactsBounds,
            provider: this.providerName,
            version: this.version,
            entityUrl: appendToUrl(this.serverUrl, 'job/{Config:ProjectName}'),
            executionUrl: appendToUrl(this.serverUrl, 'job/{Config:ProjectName}/{ExternalExecutionId}'),
            actionProperties: [
                {
                    name: 'ProjectName',
                    required: true,
                    key: true,
                    queryable: true,
                },
            ],
        });
    }
}
exports.JenkinsProvider = JenkinsProvider;
_b = JSII_RTTI_SYMBOL_1;
JenkinsProvider[_b] = { fqn: "@aws-cdk/aws-codepipeline-actions.JenkinsProvider", version: "1.184.1" };
class ImportedJenkinsProvider extends BaseJenkinsProvider {
    constructor(scope, id, props) {
        super(scope, id, props.version);
        this.providerName = props.providerName;
        this.serverUrl = props.serverUrl;
    }
    _registerBuildProvider() {
    }
    _registerTestProvider() {
    }
}
function appendToUrl(baseUrl, path) {
    return baseUrl.endsWith('/') ? baseUrl + path : `${baseUrl}/${path}`;
}
exports.jenkinsArtifactsBounds = {
    minInputs: 0,
    maxInputs: 5,
    minOutputs: 0,
    maxOutputs: 5,
};
//# sourceMappingURL=data:application/json;base64,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