import pandas as pd
import pytest

from moosir_feature.transformers.tsfresh_features.feature_manager import *


# from src.research.preproc.pipeline_kedro.src.preproc.domain.transformers.tsfresh_features.contexts import *


@pytest.fixture
def ohlc():
    df = pd.DataFrame(data=np.random.rand(100, 4),
                      columns=["Open", "High", "Low", "Close"],
                      index=pd.date_range(start="01/01/2000", periods=100, freq="10T"),
                      )
    df.index.name = "Timestamp"
    return df


"""
todo: test context!!!!
"""


#

def test_feature_manager_calculate_forwards(ohlc: pd.DataFrame):
    # arrange
    win_lens = [80, 90]
    forward_lens = [2, 5]

    feature_names = FEATURES_SCHEMA_DICS.keys()
    # feature_names = ["linear_trend_timewise"]

    # act
    result = calculate_forwards(ohlc=ohlc,
                                win_lens=win_lens,
                                forward_lens=forward_lens,
                                feature_names=feature_names)

    # assert
    print(result)
    print(result.columns)
    assert validate_columns(data=result, feature_names=feature_names, win_lens=win_lens, forward_lens=forward_lens)
    assert len(result) == len(ohlc) - 95, "nan values generated by window still exist"


def test_feature_manager_calculate_features_lags(ohlc: pd.DataFrame):
    # arrange
    win_lens = [80, 90]
    lag_lens = [2, 5]

    feature_names = FEATURES_SCHEMA_DICS.keys()
    # feature_names = ["linear_trend_timewise"]

    # act
    result = calculate_lags(ohlc=ohlc,
                            win_lens=win_lens,
                            lag_lens=lag_lens,
                            feature_names=feature_names)

    # assert
    print(result)
    print(result.columns)
    assert validate_columns(data=result, feature_names=feature_names, win_lens=win_lens, lag_lens=lag_lens)
    assert len(result) == len(ohlc) - 95, "nan values generated by window still exist"


def test_feature_manager_calculate_features_all_indicators(ohlc: pd.DataFrame):
    # arrange
    win_lens = [80, 90]

    feature_names = FEATURES_SCHEMA_DICS.keys()
    # feature_names = ["linear_trend_timewise"]

    # act
    result = calculate_features(ohlc=ohlc,
                                win_lens=win_lens,
                                feature_names=feature_names)

    # assert
    assert validate_columns(data=result, feature_names=feature_names, win_lens=win_lens)
    assert len(result) == len(ohlc) - 90, "nan values generated by window still exist"

#
#
#
#
#
# 
# def test_feature_manager_calculate_features_all_indicators(ohlc: pd.DataFrame):
#     # arrange
#     win_lens = [3, 4]
#
#     feature_names = OPERATORS_IND.keys()
#
#     context = Context()
#
#     # act
#     result = calculate_features(ohlc=ohlc,
#                                 win_lens=win_lens,
#                                 feature_names=feature_names)
#
#     # assert
#     assert context.validate(result, operators=OPERATORS_IND.values(), periods=win_lens)
#     assert len(result) == len(ohlc) - 4, "nan values generated by window still exist"
#
#
