# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pretty_poly']

package_data = \
{'': ['*']}

install_requires = \
['pypng>=0.0.20,<0.0.21', 'svgwrite>=1.4.1,<2.0.0']

entry_points = \
{'console_scripts': ['doctest = run_tests:run_doctest',
                     'examples = examples.make:write_examples',
                     'test = run_tests:test']}

setup_kwargs = {
    'name': 'pretty-poly',
    'version': '0.4.2a1',
    'description': 'Display polyominos and polyomino tilings in various pretty formats.',
    'long_description': '# pretty_poly - a package for displaying polyomino tilings\n\nThis is a Python package for displaying polyomino tilings, expressed as lists of lists of (x, y) tuples, in various ways.\n\n## Example use\n```\n>>> from pretty_poly import make_ascii\n>>> print(make_ascii([[(0, 0), (0, 1), (0, 2), (1, 1)], [(0, 3), (1, 3), (2, 3), (1, 2)], [(1, 0), (2, 0), (3, 0), (2, 1)], [(3, 1), (3, 2), (2, 2)]]))\n+-+-+-+-+\n| |     |\n+ +-+ +-+\n|   | | |\n+ +-+-+ +\n| | |   |\n+-+ +-+-+\n|     |\n+-+-+-+\n\n```\n\n## Example output\nYou can see some examples of images created using this package:\n - ![Colored squares PNG](https://jwg4.github.io/pretty_poly/right_12.png)\n - ![Outlines PNG](https://jwg4.github.io/pretty_poly/lines.png)\n - ![Thick outlines PNG](https://jwg4.github.io/pretty_poly/thick.png)\n\nThese files were created by the code in examples/make.py\n\n## How to cite this code:\n```\n@misc{pretty_poly,\n  author = {Jack Grahl},\n  title = {pretty_poly - a package for displaying polyomino tilings},\n  year = {2021},\n  howpublished = {\\url{https://github.com/jwg4/pretty_poly}},\n  commit = {...}\n}\n```\n',
    'author': 'Jack Grahl',
    'author_email': 'jack.grahl@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/jwg4/pretty_poly',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
