# Generated by Django 2.2.9 on 2020-02-22 13:25

from django.conf import settings
import django.contrib.auth.models
from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields
import django_sso_app.core.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('auth', '0011_update_proxy_permissions'),
    ]

    operations = [
        migrations.CreateModel(
            name='Profile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_active', models.BooleanField(default=True, verbose_name='is active')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='updated at')),
                ('is_public', models.BooleanField(default=False, verbose_name='is public')),
                ('ssn', models.CharField(blank=True, max_length=255, null=True, verbose_name='social security number')),
                ('phone', models.CharField(blank=True, max_length=255, null=True, verbose_name='phone')),
                ('first_name', models.CharField(blank=True, max_length=255, null=True, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=255, null=True, verbose_name='last name')),
                ('description', models.TextField(blank=True, null=True, verbose_name='description')),
                ('picture', models.TextField(blank=True, null=True, verbose_name='picture')),
                ('birthdate', models.DateField(blank=True, null=True, verbose_name='birthdate')),
                ('latitude', models.FloatField(blank=True, null=True, verbose_name='latitude')),
                ('longitude', models.FloatField(blank=True, null=True, verbose_name='longitude')),
                ('country', django_countries.fields.CountryField(blank=True, max_length=2, null=True, verbose_name='country')),
                ('address', models.TextField(blank=True, null=True, verbose_name='address')),
                ('language', models.CharField(blank=True, max_length=3, null=True, verbose_name='language')),
                ('sso_id', models.CharField(db_index=True, default=django_sso_app.core.apps.profiles.models._get_new_uuid, max_length=36, unique=True, verbose_name='sso id')),
                ('sso_rev', models.PositiveIntegerField(default=1, verbose_name='sso revision')),
                ('apigw_consumer_id', models.CharField(blank=True, max_length=36, null=True, verbose_name='API gateway consumer id')),
                ('unsubscribed_at', models.DateTimeField(blank=True, null=True, verbose_name='unsubscription date')),
                ('user', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='sso_app_profile', to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'verbose_name': 'Profile',
            },
        ),
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_active', models.BooleanField(default=True, verbose_name='is active')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='updated at')),
                ('name', models.CharField(max_length=32, null=True, unique=True, verbose_name='name')),
                ('service_url', models.CharField(max_length=255, unique=True, verbose_name='service url')),
                ('picture', models.TextField(blank=True, null=True, verbose_name='picture')),
                ('cookie_domain', models.CharField(blank=True, max_length=255, null=True, verbose_name='cookie domain')),
                ('redirect_wait', models.PositiveIntegerField(default=2000, verbose_name='redirect wait')),
                ('subscription_required', models.BooleanField(default=False, verbose_name='subscription required')),
                ('is_public', models.BooleanField(default=True, verbose_name='is public')),
            ],
            options={
                'verbose_name': 'Service',
            },
        ),
        migrations.CreateModel(
            name='Status',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='updated at')),
                ('shape', models.CharField(default='backend_only', max_length=255)),
            ],
            options={
                'verbose_name': 'Status',
            },
            bases=(django_sso_app.core.models.UuidPKModel, models.Model),
        ),
        migrations.CreateModel(
            name='Group',
            fields=[
            ],
            options={
                'verbose_name': 'Group',
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('auth.group',),
            managers=[
                ('objects', django.contrib.auth.models.GroupManager()),
            ],
        ),
        migrations.CreateModel(
            name='TOS',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_active', models.BooleanField(default=True, verbose_name='is active')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='updated at')),
                ('language', models.CharField(max_length=35, verbose_name='language')),
                ('text', models.TextField(default='', verbose_name='text')),
                ('service', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='terms_of_service', to='django_sso_app.Service', verbose_name='service')),
            ],
            options={
                'verbose_name': 'TOS',
            },
        ),
        migrations.CreateModel(
            name='Subscription',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_active', models.BooleanField(default=True, verbose_name='is active')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='updated at')),
                ('is_public', models.BooleanField(default=False, verbose_name='is public')),
                ('unsubscribed_at', models.DateTimeField(blank=True, null=True, verbose_name='unsubscribed at')),
                ('profile', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='subscriptions', to='django_sso_app.Profile', to_field='sso_id', verbose_name='profile')),
                ('service', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='subscriptions', to='django_sso_app.Service', verbose_name='service')),
            ],
            options={
                'verbose_name': 'Subscription',
            },
        ),
        migrations.AddField(
            model_name='service',
            name='groups',
            field=models.ManyToManyField(blank=True, related_name='sso_app_services', to='django_sso_app.Group', verbose_name='groups'),
        ),
        migrations.CreateModel(
            name='Device',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_active', models.BooleanField(default=True, verbose_name='is active')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('fingerprint', models.CharField(max_length=32, verbose_name='fingerprint')),
                ('user_agent', models.CharField(blank=True, max_length=32, null=True, verbose_name='user agent')),
                ('apigw_jwt_id', models.CharField(blank=True, max_length=36, null=True, verbose_name='apigw_jwt_id')),
                ('apigw_jwt_key', models.CharField(blank=True, max_length=32, null=True, verbose_name='apigw_jwt_key')),
                ('apigw_jwt_secret', models.CharField(blank=True, max_length=32, null=True, verbose_name='apigw_jwt_secret')),
                ('profile', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='devices', to='django_sso_app.Profile', verbose_name='profile')),
            ],
            options={
                'verbose_name': 'Device',
            },
        ),
        migrations.CreateModel(
            name='Passepartout',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_active', models.BooleanField(default=True, verbose_name='is active')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='updated at')),
                ('deleted', models.BooleanField(default=False, verbose_name='deleted')),
                ('token', models.CharField(db_index=True, max_length=36, unique=True, verbose_name='token')),
                ('jwt', models.TextField(blank=True, null=True, verbose_name='jwt')),
                ('bumps', models.PositiveIntegerField(default=0, verbose_name='bumps')),
                ('device', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_sso_app.Device', verbose_name='device')),
            ],
            options={
                'verbose_name': 'Passepartout',
                'unique_together': {('token', 'deleted')},
            },
        ),
    ]
