/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.testdriver;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.EnvironmentVariableResolver;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.StandardModuleURIResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.streams.Predicates;
import net.sf.saxon.s9api.streams.Steps;
import net.sf.saxon.testdriver.Environment;
import net.sf.saxon.testdriver.ErrorCollector;
import net.sf.saxon.testdriver.QT3TestReport;
import net.sf.saxon.testdriver.Spec;
import net.sf.saxon.testdriver.TestDriver;
import net.sf.saxon.testdriver.TestOutcome;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.XPathException;

public class QT3TestDriverHE
extends TestDriver {
    public static String RNS = "http://www.w3.org/2012/08/qt-fots-results";
    public static String CNS = "http://www.w3.org/2010/09/qt-fots-catalog";
    private Map<String, Dependency> dependencyMap = new HashMap<String, Dependency>();

    public Map<String, Dependency> getDependencyMap() {
        return this.dependencyMap;
    }

    @Override
    public String catalogNamespace() {
        return CNS;
    }

    @Override
    public void go(String[] args) throws Exception {
        super.go(args);
    }

    @Override
    public void processSpec(String specStr) {
        switch (specStr) {
            case "XP20": {
                this.spec = Spec.XP20;
                break;
            }
            case "XP30": {
                this.spec = Spec.XP30;
                break;
            }
            case "XP31": {
                this.spec = Spec.XP31;
                break;
            }
            case "XQ10": {
                this.spec = Spec.XQ10;
                break;
            }
            case "XQ30": {
                this.spec = Spec.XQ30;
                break;
            }
            case "XQ31": {
                this.spec = Spec.XQ31;
                break;
            }
            case "XT30": {
                this.spec = Spec.XT30;
                break;
            }
            default: {
                throw new IllegalArgumentException("The specific language must be one of the following: XP20, XP30, XP31, XQ10, XQ30, XQ31, XT30");
            }
        }
        this.resultsDoc = new QT3TestReport(this, this.spec);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("-?")) {
            QT3TestDriverHE.usage();
            return;
        }
        new QT3TestDriverHE().go(args);
    }

    public static void usage() {
        System.err.println("java net.sf.saxon.testdriver.QT3TestSuiteDriverHE testsuiteDir catalog [-o:resultsdir] [-s:testSetName] [-t:testNamePattern] [-unfolded] [-bytecode:on|off|debug] [-tree] [-lang:XP20|XP30|XQ10|XQ30]");
    }

    @Override
    protected void createGlobalEnvironments(XdmNode catalog, XPathCompiler xpc) throws SaxonApiException {
        Environment environment = null;
        for (XdmNode env : catalog.select(Steps.descendant((String)"environment")).asList()) {
            try {
                environment = Environment.processEnvironment(this, xpc, env, this.globalEnvironments, (Environment)this.localEnvironments.get("default"));
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
                System.err.println("Failed to load environment");
            }
        }
        try {
            this.buildDependencyMap(this.driverProc, catalog, environment);
        }
        catch (Exception ex) {
            System.err.println("Environment map error" + ex.getMessage());
            ex.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean ensureDependencySatisfied(XdmNode dependency, Environment env) {
        String type = dependency.attribute("type");
        String value = dependency.attribute("value");
        boolean inverse = "false".equals(dependency.attribute("satisfied"));
        if ("saxon:config".equals(type)) {
            final String name = dependency.attribute("name");
            final Object oldValue = env.processor.getConfigurationProperty(name);
            env.processor.setConfigurationProperty(name, (Object)value);
            env.resetActions.add(new Environment.ResetAction(){

                @Override
                public void reset(Environment env) {
                    env.processor.setConfigurationProperty(name, oldValue);
                }
            });
            return true;
        }
        if ("xml-version".equals(type)) {
            if (value.equals("1.0:4-") && !inverse) {
                return false;
            }
            if (value.contains("1.1") && !inverse) {
                if (this.treeModel.getName().equals("JDOM")) return false;
                if (this.treeModel.getName().equals("JDOM2")) return false;
                if (this.treeModel.getName().equals("XOM")) return false;
                if (this.treeModel.getName().equals("Axiom")) {
                    return false;
                }
                if (env == null) return false;
                env.processor.setXmlVersion("1.1");
                return true;
            } else {
                if (!value.contains("1.0")) return true;
                if (inverse) return true;
                if (env == null) return false;
                env.processor.setXmlVersion("1.0");
            }
            return true;
        }
        if ("xsd-version".equals(type)) {
            final String old = (String)env.processor.getConfigurationProperty(Feature.XSD_VERSION);
            if ("1.1".equals(value)) {
                if (env == null) return false;
                env.processor.setConfigurationProperty(Feature.XSD_VERSION, (Object)(inverse ? "1.0" : "1.1"));
            } else if ("1.0".equals(value)) {
                if (env == null) return false;
                env.processor.setConfigurationProperty(Feature.XSD_VERSION, (Object)(inverse ? "1.1" : "1.0"));
            }
            env.resetActions.add(new Environment.ResetAction(){

                @Override
                public void reset(Environment env) {
                    env.processor.setConfigurationProperty(Feature.XSD_VERSION, (Object)old);
                }
            });
            return true;
        }
        if ("limits".equals(type)) {
            if (!"year_lt_0".equals(value)) {
                if (!"big_integer".equals(value)) return false;
            }
            if (inverse) return false;
            return true;
        }
        if ("spec".equals(type)) {
            return QT3TestDriverHE.isApplicableToSpecVersion(value, this.spec);
        }
        if ("collection-stability".equals(type)) {
            if ("false".equals(value) == inverse) return false;
            return true;
        }
        if ("default-language".equals(type)) {
            final String old = (String)env.processor.getConfigurationProperty(Feature.DEFAULT_LANGUAGE);
            if (value.equals(old)) return true;
            env.processor.setConfigurationProperty(Feature.DEFAULT_LANGUAGE, (Object)value);
            env.resetActions.add(new Environment.ResetAction(){

                @Override
                public void reset(Environment env) {
                    env.processor.setConfigurationProperty(Feature.DEFAULT_LANGUAGE, (Object)old);
                }
            });
            return true;
        }
        if ("directory-as-collection-uri".equals(type)) {
            if ("true".equals(value) == inverse) return false;
            return true;
        }
        if ("language".equals(type)) {
            return this.isSupportedLanguage(value);
        }
        if ("calendar".equals(type)) {
            if (("AD".equals(value) || "ISO".equals(value)) == inverse) return false;
            return true;
        }
        if ("format-integer-sequence".equals(type)) {
            if (inverse) return false;
            return true;
        }
        if ("unicode-normalization-form".equals(type)) {
            if (value.equalsIgnoreCase("FULLY-NORMALIZED") != inverse) return false;
            return true;
        }
        if ("feature".equals(type)) {
            String edition = env.processor.getSaxonEdition();
            if ("namespace-axis".equals(value)) {
                if (inverse) return false;
                return true;
            }
            if ("higherOrderFunctions".equals(value)) {
                return (edition.equals("PE") || edition.equals("EE")) ^ inverse;
            }
            if ("schemaImport".equals(value)) return this.makeSchemaAware(env, inverse);
            if ("schemaValidation".equals(value)) return this.makeSchemaAware(env, inverse);
            if ("schemaAware".equals(value)) {
                return this.makeSchemaAware(env, inverse);
            }
            if ("xpath-1.0-compatibility".equals(value)) {
                if (env == null) return false;
                if (env.processor.getSaxonEdition().equals("HE")) return false;
                env.xpathCompiler.setBackwardsCompatible(!inverse);
                return true;
            }
            if ("staticTyping".equals(value)) {
                return inverse;
            }
            if ("remote_http".equals(value)) {
                if (inverse) return false;
                return true;
            }
            if ("moduleImport".equals(value)) {
                if (inverse) return false;
                return true;
            }
            if ("schema-location-hint".equals(value)) {
                return (edition.equals("PE") || edition.equals("EE")) ^ inverse;
            }
            if ("infoset-dtd".equals(value)) {
                if (this.treeModel != TreeModel.TINY_TREE && this.treeModel != TreeModel.LINKED_TREE) {
                    if (this.treeModel != TreeModel.TINY_TREE_CONDENSED) return inverse;
                }
                if (inverse) return false;
                return true;
            }
            if ("serialization".equals(value)) {
                return true;
            }
            if ("non_unicode_codepoint_collation".equals(value)) {
                if (inverse) return false;
                return true;
            }
            if ("non_empty_sequence_collection".equals(value)) {
                if (inverse) return false;
                return true;
            }
            if ("fn-transform-XSLT".equals(value)) {
                if (inverse) return false;
                return true;
            }
            if ("fn-transform-XSLT30".equals(value)) {
                if (inverse) return false;
                return true;
            }
            if ("fn-load-xquery-module".equals(value)) {
                return edition.equals("EE") ^ inverse;
            }
            if ("fn-format-integer-CLDR".equals(value)) {
                return (edition.equals("PE") || edition.equals("EE")) ^ inverse;
            }
            if ("simple-uca-fallback".equals(value)) {
                if (inverse) return false;
                return true;
            }
            if ("advanced-uca-fallback".equals(value)) {
                return (edition.equals("PE") || edition.equals("EE")) ^ inverse;
            }
            this.println("**** feature = " + value + "  ????");
            return false;
        }
        this.println("**** dependency not recognized: " + type);
        return false;
    }

    protected boolean makeSchemaAware(Environment env, boolean inverse) {
        return inverse;
    }

    protected boolean isSupportedLanguage(String language) {
        return "en".equals(language);
    }

    @Override
    protected void runTestCase(XdmNode testCase, XPathCompiler xpc) throws SaxonApiException {
        boolean run = true;
        Object specOpt = null;
        XPathCompiler xpath = this.driverProc.newXPathCompiler();
        String testCaseName = testCase.attribute("name");
        String testSetName = testCase.getParent().attribute("name");
        XdmNode resultElement = testCase.select(Steps.child((String)"result")).asNode();
        boolean needSerializedResult = resultElement.select(Steps.descendant((String)"assert-serialization-error")).exists() || resultElement.select(Steps.descendant((String)"serialization-matches")).exists();
        boolean needResultValue = true;
        if (needSerializedResult) {
            needResultValue = resultElement.select(Steps.descendant((Predicate)Predicates.isElement()).where(Predicates.not(Predicates.hasLocalName((String)"serialization-matches").or(Predicates.hasLocalName((String)"assert-serialization-error")).or(Predicates.hasLocalName((String)"any-of")).or(Predicates.hasLocalName((String)"all-of"))))).exists();
        }
        XdmNode alternativeResult = null;
        XdmNode optimization = null;
        String hostLang = this.spec.shortSpecName;
        String langVersion = this.spec.version;
        Environment env = this.getEnvironment(testCase, xpc);
        if (env == null) {
            this.writeTestcaseElement(testCaseName, "notRun", "test catalog error");
            ++this.notrun;
            return;
        }
        if (env.failedToBuild) {
            this.writeTestcaseElement(testCaseName, "fail", "unable to build environment");
            this.noteFailure(testSetName, testCaseName);
            return;
        }
        if (!env.usable) {
            this.writeTestcaseElement(testCaseName, "n/a", "environment dependencies not satisfied");
            ++this.notrun;
            return;
        }
        env.xpathCompiler.setBackwardsCompatible(false);
        env.processor.setXmlVersion("1.0");
        List dependencies = testCase.getParent().select(Steps.child((String)"dependency")).asList();
        dependencies.addAll(testCase.select(Steps.child((String)"dependency")).asList());
        for (XdmNode dependency : dependencies) {
            boolean applicable;
            String type = dependency.attribute("type");
            if (type == null) {
                throw new IllegalStateException("dependency/@type is missing");
            }
            String value = dependency.attribute("value");
            if (value == null) {
                throw new IllegalStateException("dependency/@value is missing");
            }
            if (type.equals("spec") && !(applicable = QT3TestDriverHE.isApplicableToSpecVersion(value, this.spec))) {
                this.writeTestcaseElement(testCaseName, "n/a", "not" + this.spec.specAndVersion);
                ++this.notrun;
                return;
            }
            if (langVersion.equals("3.0") || langVersion.equals("3.1")) {
                EnvironmentVariableResolver resolver = new EnvironmentVariableResolver(){

                    public Set<String> getAvailableEnvironmentVariables() {
                        HashSet<String> strings = new HashSet<String>();
                        strings.add("QTTEST");
                        strings.add("QTTEST2");
                        strings.add("QTTESTEMPTY");
                        return strings;
                    }

                    public String getEnvironmentVariable(String name) {
                        if (name.equals("QTTEST")) {
                            return "42";
                        }
                        if (name.equals("QTTEST2")) {
                            return "other";
                        }
                        if (name.equals("QTTESTEMPTY")) {
                            return "";
                        }
                        return null;
                    }
                };
                env.processor.setConfigurationProperty("http://saxon.sf.net/feature/environmentVariableResolver", (Object)resolver);
            }
            if (this.ensureDependencySatisfied(dependency, env)) continue;
            if ("false".equals(dependency.attribute("satisfied"))) {
                type = "!" + type;
            }
            this.println("*** Dependency not satisfied: " + type + ":" + value);
            this.writeTestcaseElement(testCaseName, "n/a", "dependency not satisfied: " + type + ":" + value);
            ++this.notrun;
            return;
        }
        XdmNode exceptionElement = (XdmNode)this.exceptionsMap.get(testCaseName);
        if (exceptionElement == null) {
            exceptionElement = (XdmNode)this.exceptionsMap.get("$" + testSetName);
        }
        if (exceptionElement != null) {
            Optional config = exceptionElement.select(Steps.child((String)"configuration")).asOptionalNode();
            String runAtt = exceptionElement.attribute("run");
            Optional reasonMsg = exceptionElement.select(Steps.child((String)"reason")).asOptionalString();
            String reportAtt = exceptionElement.attribute("report");
            if (reportAtt == null) {
                reportAtt = "";
            }
            if (config.isPresent()) {
                XdmItem paramValue = xpath.evaluateSingle("param[@name='not-unfolded' and @value='yes']/@name", (XdmItem)config.get());
                if (this.unfolded && paramValue != null) {
                    this.writeTestcaseElement(testCaseName, "notRun", reasonMsg.orElse("no reason given"));
                    ++this.notrun;
                    return;
                }
            }
            if ("false".equals(runAtt)) {
                this.writeTestcaseElement(testCaseName, reportAtt, reasonMsg.orElse("no reason given"));
                ++this.notrun;
                return;
            }
            alternativeResult = exceptionElement.select(Steps.child((String)"result")).asOptionalNode().orElse(null);
            optimization = exceptionElement.select(Steps.child((String)"optimization")).asOptionalNode().orElse(null);
        }
        if (run && (specOpt == null || specOpt == this.spec)) {
            TestOutcome outcome = new TestOutcome(this);
            String exp = null;
            try {
                exp = xpc.evaluate("if (test/@file) then unparsed-text(resolve-uri(test/@file, base-uri(.))) else string(test)", (XdmItem)testCase).toString();
            }
            catch (SaxonApiException err) {
                this.println("*** Failed to read query: " + err.getMessage());
                if (err.getErrorCode().getLocalName().equals("FOUT1190")) {
                    outcome.setException(new SaxonApiException((Throwable)new XPathException(err.getMessage(), "XPST0003")));
                }
                outcome.setException(err);
            }
            if (exp != null && env.processor.getSaxonEdition().equals("HE") && testSetName.equals("app-spec-examples")) {
                if (exp.contains("http://www.w3.org/2013/collation/UCA?lang=en;alternate=blanked;strength=primary")) {
                    this.writeTestcaseElement(testCaseName, "notRun", "requires ICU");
                    ++this.notrun;
                    return;
                }
                if (exp.contains("validate lax")) {
                    this.writeTestcaseElement(testCaseName, "notRun", "requires schema-awareness");
                    ++this.notrun;
                    return;
                }
                if (exp.contains("'fallback':function($s)")) {
                    this.writeTestcaseElement(testCaseName, "notRun", "requires HOF");
                    ++this.notrun;
                    return;
                }
            }
            if (outcome.getException() == null) {
                switch (hostLang) {
                    case "XP": 
                    case "XT": {
                        XPathCompiler testXpc = env.xpathCompiler;
                        testXpc.setLanguageVersion(langVersion);
                        testXpc.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
                        testXpc.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
                        testXpc.declareNamespace("map", "http://www.w3.org/2005/xpath-functions/map");
                        testXpc.declareNamespace("array", "http://www.w3.org/2005/xpath-functions/array");
                        this.copySchemaNamespaces(env, testXpc);
                        ModuleResolver mr = new ModuleResolver(xpc);
                        mr.setTestCase(testCase);
                        testXpc.getProcessor().getUnderlyingConfiguration().setModuleURIResolver((ModuleURIResolver)mr);
                        try {
                            XPathSelector selector = testXpc.compile(exp).load();
                            for (QName varName : env.params.keySet()) {
                                selector.setVariable(varName, env.params.get(varName));
                            }
                            if (env.contextItem != null) {
                                selector.setContextItem(env.contextItem);
                            }
                            selector.setURIResolver((URIResolver)new TestURIResolver(env));
                            if (env.unparsedTextResolver != null) {
                                selector.getUnderlyingXPathContext().setUnparsedTextURIResolver(env.unparsedTextResolver);
                            }
                            XdmValue result = selector.evaluate();
                            outcome.setPrincipalResult(result);
                        }
                        catch (SaxonApiException err) {
                            this.println(err.getMessage());
                            outcome.setException(err);
                        }
                        catch (Exception err) {
                            this.println(err.getMessage());
                            err.printStackTrace();
                            this.writeTestcaseElement(testCaseName, "fail", "*** crashed: " + err.getMessage());
                        }
                        break;
                    }
                    case "XQ": {
                        String vars;
                        XQueryCompiler testXqc = env.xqueryCompiler;
                        testXqc.setLanguageVersion(langVersion);
                        testXqc.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
                        testXqc.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
                        testXqc.declareNamespace("map", "http://www.w3.org/2005/xpath-functions/map");
                        testXqc.declareNamespace("array", "http://www.w3.org/2005/xpath-functions/array");
                        ErrorCollector errorCollector = new ErrorCollector();
                        testXqc.setErrorListener((ErrorListener)((Object)errorCollector));
                        String decVars = env.paramDecimalDeclarations.toString();
                        if (!decVars.isEmpty()) {
                            int x = exp.indexOf("(:%DECL%:)");
                            exp = x < 0 ? decVars + exp : exp.substring(0, x) + decVars + exp.substring(x + 13);
                        }
                        if (!(vars = env.paramDeclarations.toString()).isEmpty()) {
                            int x = exp.indexOf("(:%VARDECL%:)");
                            exp = x < 0 ? vars + exp : exp.substring(0, x) + vars + exp.substring(x + 13);
                        }
                        ModuleResolver mr = new ModuleResolver(xpc);
                        mr.setTestCase(testCase);
                        testXqc.getProcessor().getUnderlyingConfiguration().setModuleURIResolver((ModuleURIResolver)mr);
                        testXqc.setModuleURIResolver((ModuleURIResolver)mr);
                        try {
                            testXqc.getUnderlyingStaticContext().setModuleLocation((Location)new ExplicitLocation(testXqc.getBaseURI().toString(), testCase.getLineNumber(), -1));
                            XQueryExecutable q = null;
                            try {
                                q = testXqc.compile(exp);
                            }
                            catch (SaxonApiException e) {
                                this.println("Static error in query");
                                throw e;
                            }
                            if (optimization != null) {
                                XdmDestination expDest = new XdmDestination();
                                Configuration config = this.driverProc.getUnderlyingConfiguration();
                                try {
                                    Receiver receiver = expDest.getReceiver(config.makePipelineConfiguration(), config.obtainDefaultSerializationProperties());
                                    ExpressionPresenter presenter = new ExpressionPresenter(config, receiver);
                                    q.getUnderlyingCompiledQuery().explain(presenter);
                                    presenter.close();
                                }
                                catch (XPathException e) {
                                    e.printStackTrace();
                                }
                                XdmNode explanation = expDest.getXdmNode();
                                XPathCompiler assertXpc = xpc.getProcessor().newXPathCompiler();
                                XdmItem optResult = assertXpc.evaluateSingle(optimization.attribute("assert"), (XdmItem)explanation);
                                if (((XdmAtomicValue)optResult).getBooleanValue()) {
                                    this.println("Optimization result OK");
                                } else {
                                    this.println("Failed optimization test {" + optimization.attribute("assert") + "}");
                                    this.driverProc.writeXdmValue((XdmValue)explanation, (Destination)this.driverProc.newSerializer((OutputStream)System.err));
                                    this.writeTestcaseElement(testCaseName, "fail", "Failed optimization assertions");
                                    this.noteFailure(testSetName, testCaseName);
                                    return;
                                }
                            }
                            XQueryEvaluator selector = q.load();
                            for (QName varName : env.params.keySet()) {
                                selector.setExternalVariable(varName, env.params.get(varName));
                            }
                            if (env.contextItem != null) {
                                selector.setContextItem(env.contextItem);
                            }
                            selector.setURIResolver((URIResolver)new TestURIResolver(env));
                            if (env.unparsedTextResolver != null) {
                                selector.getUnderlyingQueryContext().setUnparsedTextURIResolver(env.unparsedTextResolver);
                            }
                            if (needSerializedResult) {
                                StringWriter sw = new StringWriter();
                                Serializer serializer = env.processor.newSerializer((Writer)sw);
                                selector.setDestination((Destination)serializer);
                                selector.run();
                                outcome.setPrincipalSerializedResult(sw.toString());
                            }
                            if (!needResultValue) break;
                            XdmValue result = selector.evaluate();
                            outcome.setPrincipalResult(result);
                        }
                        catch (SaxonApiException err) {
                            this.println("in TestSet " + testSetName);
                            this.println(err.getMessage());
                            outcome.setException(err);
                            outcome.setErrorsReported(errorCollector.getErrorCodes());
                        }
                        catch (LicenseException err) {
                            this.println("in TestSet " + testSetName);
                            this.println(err.getMessage());
                            XPathException xe = new XPathException(err.getMessage(), "XPST0075");
                            outcome.setException(new SaxonApiException((Throwable)xe));
                            try {
                                errorCollector.error((TransformerException)((Object)xe));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            outcome.setErrorsReported(errorCollector.getErrorCodes());
                        }
                        break;
                    }
                    default: {
                        this.writeTestcaseElement(testCaseName, "notRun", "No processor found");
                        ++this.notrun;
                        return;
                    }
                }
            }
            for (Environment.ResetAction action : env.resetActions) {
                action.reset(env);
            }
            env.resetActions.clear();
            XdmNode assertion = alternativeResult != null ? (XdmNode)xpc.evaluateSingle("*[1]", (XdmItem)alternativeResult) : (XdmNode)xpc.evaluateSingle("result/*[1]", (XdmItem)testCase);
            if (assertion == null) {
                this.println("*** No assertions found for test case " + testCaseName);
                this.writeTestcaseElement(testCaseName, "disputed", "No assertions in test case");
                this.noteFailure(testSetName, testCaseName);
                return;
            }
            XPathCompiler assertXpc = env.processor.newXPathCompiler();
            assertXpc.setLanguageVersion("3.1");
            assertXpc.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
            assertXpc.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
            assertXpc.declareNamespace("math", "http://www.w3.org/2005/xpath-functions/math");
            assertXpc.declareNamespace("map", "http://www.w3.org/2005/xpath-functions/map");
            assertXpc.declareNamespace("array", "http://www.w3.org/2005/xpath-functions/array");
            assertXpc.declareNamespace("j", "http://www.w3.org/2005/xpath-functions");
            assertXpc.declareVariable(new QName("result"));
            assertXpc.setBaseURI(assertion.getBaseURI());
            this.copySchemaNamespaces(env, assertXpc);
            boolean success = outcome.testAssertion(assertion, outcome, outcome.getPrincipalResultDoc(), assertXpc, xpath, this.debug);
            if (success) {
                ++this.successes;
                this.writeTestcaseElement(testCaseName, "pass", null);
            } else {
                XdmItem expectedError = xpc.evaluateSingle("result//error/@code", (XdmItem)testCase);
                if (outcome.isException()) {
                    if (expectedError != null) {
                        ++this.wrongErrorResults;
                        ++this.successes;
                        if (outcome.getWrongErrorMessage() != null) {
                            outcome.setComment(outcome.getWrongErrorMessage());
                            this.writeTestcaseElement(testCaseName, "wrongError", outcome.getComment());
                        } else {
                            this.writeTestcaseElement(testCaseName, "wrongError", "Expected error:" + expectedError.getStringValue() + ", got " + outcome.getException().getErrorCode());
                        }
                        this.println("*** TEST WRONG ERRORCODE: result " + outcome.getException().getErrorCode() + " Expected error:" + expectedError.getStringValue());
                    } else {
                        this.noteFailure(testSetName, testCaseName);
                        this.writeTestcaseElement(testCaseName, "fail", "Expected success, got " + outcome.getException().getErrorCode());
                        this.println("*** TEST-FAILURE: result " + outcome.getException().getErrorCode() + " Expected success.");
                    }
                } else {
                    this.noteFailure(testSetName, testCaseName);
                    if (expectedError == null) {
                        this.writeTestcaseElement(testCaseName, "fail", "Wrong results, got " + this.truncate(outcome.serialize(assertXpc.getProcessor(), outcome.getPrincipalResultDoc())));
                    } else {
                        this.writeTestcaseElement(testCaseName, "fail", "Expected error:" + expectedError.getStringValue() + ", got " + this.truncate(outcome.serialize(assertXpc.getProcessor(), outcome.getPrincipalResultDoc())));
                    }
                    if (this.debug) {
                        try {
                            this.println("*** TEST-FAILURE. Result:");
                            StringWriter sw = new StringWriter();
                            this.driverSerializer.setOutputWriter((Writer)sw);
                            this.driverSerializer.serializeXdmValue(outcome.getPrincipalResult());
                            this.println(sw.toString());
                            this.println("<=======");
                        }
                        catch (Exception exception) {}
                    } else {
                        this.println("*** TEST-FAILURE (use -debug to show actual result)");
                    }
                }
            }
        }
    }

    private static boolean isApplicableToSpecVersion(String value, Spec spec) {
        boolean applicable = false;
        if (!value.contains(spec.shortSpecName)) {
            applicable = false;
        } else if (value.contains(spec.specAndVersion)) {
            applicable = true;
        } else if ((spec.specAndVersion.equals("XQ30") || spec.specAndVersion.equals("XQ31")) && (value.contains("XQ10+") || value.contains("XQ30+"))) {
            applicable = true;
        } else if ((spec.specAndVersion.equals("XP30") || spec.specAndVersion.equals("XP31")) && (value.contains("XP20+") || value.contains("XP30+"))) {
            applicable = true;
        }
        return applicable;
    }

    private String truncate(String in) {
        if (in.length() > 80) {
            return in.substring(0, 80) + "...";
        }
        return in;
    }

    @Override
    protected void writeResultFilePreamble(Processor processor, XdmNode catalog) throws IOException, SaxonApiException, XMLStreamException {
        this.resultsDoc.writeResultFilePreamble(processor, catalog);
    }

    @Override
    protected void writeResultFilePostamble() throws XMLStreamException {
        this.resultsDoc.writeResultFilePostamble();
        if (this.requestedTestSet != null) {
            System.err.println("Failing tests: ");
            for (Map.Entry entry : this.failSummary.entrySet()) {
                System.err.println("  " + (String)entry.getKey());
            }
        } else {
            System.err.println("Failures by Test Set: ");
            for (Map.Entry entry : this.failSummary.entrySet()) {
                System.err.println("  " + (String)entry.getKey() + " : " + entry.getValue());
            }
        }
    }

    @Override
    protected void startTestSetElement(XdmNode testSetNode) {
        this.resultsDoc.startTestSetElement(testSetNode);
    }

    @Override
    protected void writeTestSetEndElement() {
        this.resultsDoc.endElement();
    }

    private void writeTestcaseElement(String name, String result, String comment) {
        this.resultsDoc.writeTestcaseElement(name, result, comment);
    }

    public static Sequence<?> lazyLiteral(Sequence value) {
        return value;
    }

    private void buildDependencyMap(Processor processor, XdmNode catalog, Environment env) throws SaxonApiException {
        XQueryCompiler xqCompiler = processor.newXQueryCompiler();
        xqCompiler.setBaseURI(new File(System.getProperty("user.dir")).toURI());
        XQueryEvaluator eval = xqCompiler.compile("        declare namespace fots = \"http://www.w3.org/2010/09/qt-fots-catalog\";\n        let $testsets := //fots:test-set/@file/doc(resolve-uri(., exactly-one(base-uri(.))))\n        for $dependencyTS in $testsets//fots:dependency\n        let $type := $dependencyTS/@type\n        let $name := $dependencyTS/@name\n        let $value := $dependencyTS/@value\n        group by $type, $value\n        order by $type, $value\n        return <dependency type='{$type}' name='{$name}' value='{$value}' />").load();
        eval.setContextItem((XdmItem)catalog);
        XdmValue result = eval.evaluate();
        for (XdmItem item : result) {
            XdmNode node = (XdmNode)item;
            String type = node.attribute("type");
            String value = node.attribute("value");
            this.addDependency(type, value, this.ensureDependencySatisfied(node, env));
        }
    }

    public void addDependency(String depStr, String value, boolean satisfied) {
        if (!this.dependencyMap.containsKey(value)) {
            Dependency dep = new Dependency();
            dep.dType = depStr;
            dep.satisfied = satisfied;
            this.dependencyMap.put(value, dep);
        }
    }

    protected class Dependency {
        public String dType;
        public boolean satisfied;

        protected Dependency() {
        }
    }

    public static class TestURIResolver
    implements URIResolver {
        Environment env;

        public TestURIResolver(Environment env) {
            this.env = env;
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            try {
                String abs = ResolveURI.makeAbsolute((String)href, (String)base).toString();
                XdmNode node = this.env.sourceDocs.get(abs);
                if (node == null && (node = this.env.sourceDocs.get(href)) == null) {
                    return null;
                }
                return node.asSource();
            }
            catch (URISyntaxException e) {
                throw new XPathException("Invalid URI: " + e.getMessage(), "FODC0005");
            }
        }
    }

    public static class ModuleResolver
    extends StandardModuleURIResolver {
        XPathCompiler catXPC;
        XdmNode testCase;

        public ModuleResolver(XPathCompiler xpc) {
            super(xpc.getProcessor().getUnderlyingConfiguration());
            this.catXPC = xpc;
        }

        public void setTestCase(XdmNode testCase) {
            this.testCase = testCase;
        }

        public StreamSource[] resolve(String moduleURI, String baseURI, String[] locations) throws XPathException {
            try {
                XdmValue files = this.testCase.select(Steps.child((String)"module").where(Predicates.attributeEq((String)"uri", (String)moduleURI)).then(Steps.attribute((String)"file")).then(Steps.atomize())).asXdmValue();
                if (files.size() == 0) {
                    throw new XPathException("Failed to find module entry for " + moduleURI);
                }
                StreamSource[] ss = new StreamSource[files.size()];
                for (int i = 0; i < files.size(); ++i) {
                    URI uri = this.testCase.getBaseURI().resolve(files.itemAt(i).toString());
                    ss[i] = this.getQuerySource(uri);
                }
                return ss;
            }
            catch (SaxonApiUncheckedException e) {
                throw new XPathException((Throwable)e);
            }
        }
    }
}

