"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Jest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const semver = require("semver");
const tasks_1 = require("./tasks");
const typescript_1 = require("./typescript");
const DEFAULT_TEST_REPORTS_DIR = 'test-reports';
/**
 * (experimental) Installs the following npm scripts:.
 *
 * - `test` will run `jest --passWithNoTests`
 * - `test:watch` will run `jest --watch`
 * - `test:update` will run `jest -u`
 *
 * @experimental
 */
class Jest {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2;
        this.project = project;
        const jestDep = options.jestVersion ? `jest@${options.jestVersion}` : 'jest';
        project.addDevDeps(jestDep);
        this.jestConfig = options.jestConfig;
        this.typescriptConfig = options.typescriptConfig;
        this.ignorePatterns = (_d = (_c = (_b = this.jestConfig) === null || _b === void 0 ? void 0 : _b.testPathIgnorePatterns) !== null && _c !== void 0 ? _c : options.ignorePatterns) !== null && _d !== void 0 ? _d : ['/node_modules/'];
        this.watchIgnorePatterns = (_f = (_e = this.jestConfig) === null || _e === void 0 ? void 0 : _e.watchPathIgnorePatterns) !== null && _f !== void 0 ? _f : ['/node_modules/'];
        this.coverageReporters = (_h = (_g = this.jestConfig) === null || _g === void 0 ? void 0 : _g.coverageReporters) !== null && _h !== void 0 ? _h : ['json', 'lcov', 'clover'];
        this.testMatch = (_k = (_j = this.jestConfig) === null || _j === void 0 ? void 0 : _j.testMatch) !== null && _k !== void 0 ? _k : ['**\/__tests__/**\/*.[jt]s?(x)', '**\/?(*.)+(spec|test).[tj]s?(x)'];
        const coverageDirectory = (_m = (_l = this.jestConfig) === null || _l === void 0 ? void 0 : _l.coverageDirectory) !== null && _m !== void 0 ? _m : 'coverage';
        this.reporters = [];
        if ((_o = options.preserveDefaultReporters) !== null && _o !== void 0 ? _o : true) {
            this.reporters.unshift('default');
        }
        this.config = {
            ...this.jestConfig,
            clearMocks: (_q = (_p = this.jestConfig) === null || _p === void 0 ? void 0 : _p.clearMocks) !== null && _q !== void 0 ? _q : true,
            collectCoverage: (_t = (_r = options.coverage) !== null && _r !== void 0 ? _r : (_s = this.jestConfig) === null || _s === void 0 ? void 0 : _s.collectCoverage) !== null && _t !== void 0 ? _t : true,
            coverageReporters: this.coverageReporters,
            coverageDirectory: coverageDirectory,
            coveragePathIgnorePatterns: (_v = (_u = this.jestConfig) === null || _u === void 0 ? void 0 : _u.coveragePathIgnorePatterns) !== null && _v !== void 0 ? _v : this.ignorePatterns,
            testPathIgnorePatterns: this.ignorePatterns,
            watchPathIgnorePatterns: this.watchIgnorePatterns,
            testMatch: this.testMatch,
            reporters: this.reporters,
            snapshotResolver: (() => this._snapshotResolver),
        };
        if ((_w = options.junitReporting) !== null && _w !== void 0 ? _w : true) {
            const reportsDir = DEFAULT_TEST_REPORTS_DIR;
            this.addReporter([
                'jest-junit',
                { outputDirectory: reportsDir },
            ]);
            project.addDevDeps('jest-junit@^12');
            project.gitignore.exclude('# jest-junit artifacts', `/${reportsDir}/`, 'junit.xml');
            (_x = project.npmignore) === null || _x === void 0 ? void 0 : _x.exclude('# jest-junit artifacts', `/${reportsDir}/`, 'junit.xml');
        }
        if ((_y = this.jestConfig) === null || _y === void 0 ? void 0 : _y.reporters) {
            for (const reporter of this.jestConfig.reporters) {
                this.addReporter(reporter);
            }
        }
        if ((_z = this.jestConfig) === null || _z === void 0 ? void 0 : _z.coverageThreshold) {
            this.config.coverageThreshold = {
                global: (_0 = this.jestConfig) === null || _0 === void 0 ? void 0 : _0.coverageThreshold,
            };
        }
        this.configureTestCommand();
        project.addFields({ jest: this.config });
        const coverageDirectoryPath = path.posix.join('/', coverageDirectory);
        (_1 = project.npmignore) === null || _1 === void 0 ? void 0 : _1.exclude(coverageDirectoryPath);
        project.gitignore.exclude(coverageDirectoryPath);
        if ((_2 = options.coverageText) !== null && _2 !== void 0 ? _2 : true) {
            this.coverageReporters.push('text');
        }
    }
    /**
     * (experimental) Adds a test match pattern.
     *
     * @param pattern glob pattern to match for tests.
     * @experimental
     */
    addTestMatch(pattern) {
        this.testMatch.push(pattern);
    }
    /**
     * (experimental) Adds a watch ignore pattern.
     *
     * @param pattern The pattern (regular expression).
     * @experimental
     */
    addWatchIgnorePattern(pattern) {
        this.watchIgnorePatterns.push(pattern);
    }
    /**
     * @experimental
     */
    addIgnorePattern(pattern) {
        this.ignorePatterns.push(pattern);
    }
    /**
     * @experimental
     */
    addReporter(reporter) {
        this.reporters.push(reporter);
    }
    /**
     * @experimental
     */
    addSnapshotResolver(file) {
        this._snapshotResolver = file;
    }
    /**
     * (experimental) Merges passed in typescript config options with jest configured typescript options from .projenrc Add Jest config settings for typescript options.
     *
     * @param options TypescriptConfigOptions.
     * @experimental
     */
    generateTypescriptConfig(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j;
        const tsconfig = new typescript_1.TypescriptConfig(this.project, {
            fileName: (_b = options.fileName) !== null && _b !== void 0 ? _b : 'tsconfig.jest.json',
            include: [
                ...options.include ? options.include : [],
                ...((_c = this.typescriptConfig) === null || _c === void 0 ? void 0 : _c.include) ? (_d = this.typescriptConfig) === null || _d === void 0 ? void 0 : _d.include : [],
            ],
            exclude: [
                ...options.exclude ? options.exclude : [],
                ...((_e = this.typescriptConfig) === null || _e === void 0 ? void 0 : _e.exclude) ? (_f = this.typescriptConfig) === null || _f === void 0 ? void 0 : _f.exclude : [],
            ],
            compilerOptions: {
                ...options.compilerOptions,
                ...(_g = this.typescriptConfig) === null || _g === void 0 ? void 0 : _g.compilerOptions,
            },
        });
        this.config.preset = 'ts-jest';
        // only process .ts files
        this.config.testMatch = (_j = (_h = this.jestConfig) === null || _h === void 0 ? void 0 : _h.testMatch) !== null && _j !== void 0 ? _j : [
            '**/__tests__/**/*.ts?(x)',
            '**/?(*.)+(spec|test).ts?(x)',
        ];
        // specify tsconfig.json
        this.config.globals = {
            'ts-jest': {
                tsconfig: tsconfig.fileName,
            },
        };
        // add relevant deps
        this.project.addDevDeps('@types/jest', 'ts-jest');
        return tsconfig;
    }
    configureTestCommand() {
        const jestOpts = ['--passWithNoTests', '--all'];
        // if the project has anti-tamper configured, it should be safe to always run tests
        // with --updateSnapshot because if we forget to commit a snapshot change the CI build will fail.
        if (this.project.antitamper) {
            jestOpts.push('--updateSnapshot');
        }
        // as recommended in the jest docs, node > 14 may use native v8 coverage collection
        // https://jestjs.io/docs/en/cli#--coverageproviderprovider
        if (this.project.package.minNodeVersion && semver.gte(this.project.package.minNodeVersion, '14.0.0')) {
            jestOpts.push('--coverageProvider=v8');
        }
        this.project.testTask.exec(`jest ${jestOpts.join(' ')}`);
        this.project.addTask('test:watch', {
            description: 'Run jest in watch mode',
            category: tasks_1.TaskCategory.TEST,
            exec: 'jest --watch',
        });
        this.project.addTask('test:update', {
            description: 'Update jest snapshots',
            category: tasks_1.TaskCategory.TEST,
            exec: 'jest --updateSnapshot',
        });
    }
}
exports.Jest = Jest;
_a = JSII_RTTI_SYMBOL_1;
Jest[_a] = { fqn: "projen.Jest", version: "0.17.62" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiamVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9qZXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkJBQTZCO0FBQzdCLGlDQUFpQztBQUVqQyxtQ0FBdUM7QUFDdkMsNkNBQXlFO0FBRXpFLE1BQU0sd0JBQXdCLEdBQUcsY0FBYyxDQUFDOzs7Ozs7Ozs7O0FBdWhCaEQsTUFBYSxJQUFJOzs7O0lBZ0JmLFlBQVksT0FBb0IsRUFBRSxVQUF1QixFQUFFOztRQUN6RCxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU8sQ0FBQztRQUV2QixNQUFNLE9BQU8sR0FBRyxPQUFPLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxRQUFRLE9BQU8sQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDO1FBQzdFLE9BQU8sQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUM7UUFFNUIsSUFBSSxDQUFDLFVBQVUsR0FBRyxPQUFPLENBQUMsVUFBVSxDQUFDO1FBQ3JDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxPQUFPLENBQUMsZ0JBQWdCLENBQUM7UUFFakQsSUFBSSxDQUFDLGNBQWMscUJBQUcsSUFBSSxDQUFDLFVBQVUsMENBQUUsc0JBQXNCLG1DQUFJLE9BQU8sQ0FBQyxjQUFjLG1DQUFJLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztRQUM5RyxJQUFJLENBQUMsbUJBQW1CLGVBQUcsSUFBSSxDQUFDLFVBQVUsMENBQUUsdUJBQXVCLG1DQUFJLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztRQUMxRixJQUFJLENBQUMsaUJBQWlCLGVBQUcsSUFBSSxDQUFDLFVBQVUsMENBQUUsaUJBQWlCLG1DQUFJLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxRQUFRLENBQUMsQ0FBQztRQUMxRixJQUFJLENBQUMsU0FBUyxlQUFHLElBQUksQ0FBQyxVQUFVLDBDQUFFLFNBQVMsbUNBQUksQ0FBQywrQkFBK0IsRUFBRSxpQ0FBaUMsQ0FBQyxDQUFDO1FBRXBILE1BQU0saUJBQWlCLGVBQUcsSUFBSSxDQUFDLFVBQVUsMENBQUUsaUJBQWlCLG1DQUFJLFVBQVUsQ0FBQztRQUUzRSxJQUFJLENBQUMsU0FBUyxHQUFHLEVBQUUsQ0FBQztRQUVwQixVQUFJLE9BQU8sQ0FBQyx3QkFBd0IsbUNBQUksSUFBSSxFQUFFO1lBQzVDLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxDQUFDO1NBQ25DO1FBRUQsSUFBSSxDQUFDLE1BQU0sR0FBRztZQUNaLEdBQUcsSUFBSSxDQUFDLFVBQVU7WUFDbEIsVUFBVSxjQUFFLElBQUksQ0FBQyxVQUFVLDBDQUFFLFVBQVUsbUNBQUksSUFBSTtZQUMvQyxlQUFlLGNBQUUsT0FBTyxDQUFDLFFBQVEseUNBQUksSUFBSSxDQUFDLFVBQVUsMENBQUUsZUFBZSxtQ0FBSSxJQUFJO1lBQzdFLGlCQUFpQixFQUFFLElBQUksQ0FBQyxpQkFBaUI7WUFDekMsaUJBQWlCLEVBQUUsaUJBQWlCO1lBQ3BDLDBCQUEwQixjQUFFLElBQUksQ0FBQyxVQUFVLDBDQUFFLDBCQUEwQixtQ0FBSSxJQUFJLENBQUMsY0FBYztZQUM5RixzQkFBc0IsRUFBRSxJQUFJLENBQUMsY0FBYztZQUMzQyx1QkFBdUIsRUFBRSxJQUFJLENBQUMsbUJBQW1CO1lBQ2pELFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7WUFDekIsZ0JBQWdCLEVBQUUsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQVE7U0FDbkMsQ0FBQztRQUV2QixVQUFJLE9BQU8sQ0FBQyxjQUFjLG1DQUFJLElBQUksRUFBRTtZQUNsQyxNQUFNLFVBQVUsR0FBRyx3QkFBd0IsQ0FBQztZQUU1QyxJQUFJLENBQUMsV0FBVyxDQUFDO2dCQUNmLFlBQVk7Z0JBQ1osRUFBRSxlQUFlLEVBQUUsVUFBVSxFQUFFO2FBQ2hDLENBQUMsQ0FBQztZQUVILE9BQU8sQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztZQUVyQyxPQUFPLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FDdkIsd0JBQXdCLEVBQ3hCLElBQUksVUFBVSxHQUFHLEVBQ2pCLFdBQVcsQ0FDWixDQUFDO1lBQ0YsTUFBQSxPQUFPLENBQUMsU0FBUywwQ0FBRSxPQUFPLENBQ3hCLHdCQUF3QixFQUN4QixJQUFJLFVBQVUsR0FBRyxFQUNqQixXQUFXLEVBQ1g7U0FDSDtRQUVELFVBQUksSUFBSSxDQUFDLFVBQVUsMENBQUUsU0FBUyxFQUFFO1lBQzlCLEtBQUssTUFBTSxRQUFRLElBQUksSUFBSSxDQUFDLFVBQVUsQ0FBQyxTQUFTLEVBQUU7Z0JBQ2hELElBQUksQ0FBQyxXQUFXLENBQUMsUUFBUSxDQUFDLENBQUM7YUFDNUI7U0FDRjtRQUVELFVBQUksSUFBSSxDQUFDLFVBQVUsMENBQUUsaUJBQWlCLEVBQUU7WUFDdEMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxpQkFBaUIsR0FBRztnQkFDOUIsTUFBTSxRQUFFLElBQUksQ0FBQyxVQUFVLDBDQUFFLGlCQUFpQjthQUMzQyxDQUFDO1NBQ0g7UUFFRCxJQUFJLENBQUMsb0JBQW9CLEVBQUUsQ0FBQztRQUU1QixPQUFPLENBQUMsU0FBUyxDQUFDLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQyxDQUFDO1FBRXpDLE1BQU0scUJBQXFCLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLGlCQUFpQixDQUFDLENBQUM7UUFDdEUsTUFBQSxPQUFPLENBQUMsU0FBUywwQ0FBRSxPQUFPLENBQUMscUJBQXFCLEVBQUU7UUFDbEQsT0FBTyxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMscUJBQXFCLENBQUMsQ0FBQztRQUVqRCxVQUFJLE9BQU8sQ0FBQyxZQUFZLG1DQUFJLElBQUksRUFBRTtZQUNoQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1NBQ3JDO0lBQ0gsQ0FBQzs7Ozs7OztJQU1NLFlBQVksQ0FBQyxPQUFlO1FBQ2pDLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQy9CLENBQUM7Ozs7Ozs7SUFNTSxxQkFBcUIsQ0FBQyxPQUFlO1FBQzFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDekMsQ0FBQzs7OztJQUVNLGdCQUFnQixDQUFDLE9BQWU7UUFDckMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDcEMsQ0FBQzs7OztJQUVNLFdBQVcsQ0FBQyxRQUFzQjtRQUN2QyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUNoQyxDQUFDOzs7O0lBRU0sbUJBQW1CLENBQUMsSUFBWTtRQUNyQyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFDO0lBQ2hDLENBQUM7Ozs7Ozs7SUFPTSx3QkFBd0IsQ0FBQyxPQUFnQzs7UUFDOUQsTUFBTSxRQUFRLEdBQUcsSUFBSSw2QkFBZ0IsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFO1lBQ2xELFFBQVEsUUFBRSxPQUFPLENBQUMsUUFBUSxtQ0FBSSxvQkFBb0I7WUFDbEQsT0FBTyxFQUFFO2dCQUNQLEdBQUcsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRTtnQkFDekMsR0FBRyxPQUFBLElBQUksQ0FBQyxnQkFBZ0IsMENBQUUsT0FBTyxFQUFDLENBQUMsT0FBQyxJQUFJLENBQUMsZ0JBQWdCLDBDQUFFLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRTthQUN4RTtZQUNELE9BQU8sRUFBRTtnQkFDUCxHQUFHLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUU7Z0JBQ3pDLEdBQUcsT0FBQSxJQUFJLENBQUMsZ0JBQWdCLDBDQUFFLE9BQU8sRUFBQyxDQUFDLE9BQUMsSUFBSSxDQUFDLGdCQUFnQiwwQ0FBRSxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUU7YUFDeEU7WUFDRCxlQUFlLEVBQUU7Z0JBQ2YsR0FBRyxPQUFPLENBQUMsZUFBZTtnQkFDMUIsU0FBRyxJQUFJLENBQUMsZ0JBQWdCLDBDQUFFLGVBQWU7YUFDMUM7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sR0FBRyxTQUFTLENBQUM7UUFFL0IseUJBQXlCO1FBQ3pCLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxlQUFHLElBQUksQ0FBQyxVQUFVLDBDQUFFLFNBQVMsbUNBQUk7WUFDcEQsMEJBQTBCO1lBQzFCLDZCQUE2QjtTQUM5QixDQUFDO1FBRUYsd0JBQXdCO1FBQ3hCLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBTyxHQUFHO1lBQ3BCLFNBQVMsRUFBRTtnQkFDVCxRQUFRLEVBQUUsUUFBUSxDQUFDLFFBQVE7YUFDNUI7U0FDRixDQUFDO1FBRUYsb0JBQW9CO1FBQ3BCLElBQUksQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUNyQixhQUFhLEVBQ2IsU0FBUyxDQUNWLENBQUM7UUFFRixPQUFPLFFBQVEsQ0FBQztJQUNsQixDQUFDO0lBRU8sb0JBQW9CO1FBQzFCLE1BQU0sUUFBUSxHQUFHLENBQUMsbUJBQW1CLEVBQUUsT0FBTyxDQUFDLENBQUM7UUFFaEQsbUZBQW1GO1FBQ25GLGlHQUFpRztRQUNqRyxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsVUFBVSxFQUFFO1lBQzNCLFFBQVEsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FBQztTQUNuQztRQUVELG1GQUFtRjtRQUNuRiwyREFBMkQ7UUFDM0QsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxjQUFjLElBQUksTUFBTSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxjQUFjLEVBQUUsUUFBUSxDQUFDLEVBQUU7WUFDcEcsUUFBUSxDQUFDLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO1NBQ3hDO1FBRUQsSUFBSSxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLFFBQVEsUUFBUSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLENBQUM7UUFFekQsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsWUFBWSxFQUFFO1lBQ2pDLFdBQVcsRUFBRSx3QkFBd0I7WUFDckMsUUFBUSxFQUFFLG9CQUFZLENBQUMsSUFBSTtZQUMzQixJQUFJLEVBQUUsY0FBYztTQUNyQixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxhQUFhLEVBQUU7WUFDbEMsV0FBVyxFQUFFLHVCQUF1QjtZQUNwQyxRQUFRLEVBQUUsb0JBQVksQ0FBQyxJQUFJO1lBQzNCLElBQUksRUFBRSx1QkFBdUI7U0FDOUIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUF6TUgsb0JBME1DIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCAqIGFzIHNlbXZlciBmcm9tICdzZW12ZXInO1xuaW1wb3J0IHsgTm9kZVByb2plY3QgfSBmcm9tICcuL25vZGUtcHJvamVjdCc7XG5pbXBvcnQgeyBUYXNrQ2F0ZWdvcnkgfSBmcm9tICcuL3Rhc2tzJztcbmltcG9ydCB7IFR5cGVzY3JpcHRDb25maWcsIFR5cGVzY3JpcHRDb25maWdPcHRpb25zIH0gZnJvbSAnLi90eXBlc2NyaXB0JztcblxuY29uc3QgREVGQVVMVF9URVNUX1JFUE9SVFNfRElSID0gJ3Rlc3QtcmVwb3J0cyc7XG5cbi8vIFB1bGxlZCBmcm9tIGh0dHBzOi8vamVzdGpzLmlvL2RvY3MvZW4vY29uZmlndXJhdGlvblxuZXhwb3J0IGludGVyZmFjZSBKZXN0Q29uZmlnT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhdXRvbW9jaz86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBiYWlsPzogYm9vbGVhbiB8IG51bWJlcjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjYWNoZURpcmVjdG9yeT86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNsZWFyTW9ja3M/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY29sbGVjdENvdmVyYWdlPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY29sbGVjdENvdmVyYWdlRnJvbT86IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNvdmVyYWdlRGlyZWN0b3J5Pzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY292ZXJhZ2VQYXRoSWdub3JlUGF0dGVybnM/OiBzdHJpbmdbXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNvdmVyYWdlUHJvdmlkZXI/OiAnYmFiZWwnIHwgJ3Y4JztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjb3ZlcmFnZVJlcG9ydGVycz86IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY292ZXJhZ2VUaHJlc2hvbGQ/OiBDb3ZlcmFnZVRocmVzaG9sZDtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkZXBlbmRlbmN5RXh0cmFjdG9yPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkaXNwbGF5TmFtZT86IHN0cmluZyB8IGFueTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBlcnJvck9uRGVwcmVjYXRlZD86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGV4dHJhR2xvYmFscz86IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBmb3JjZUNvdmVyYWdlTWF0Y2g/OiBzdHJpbmdbXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZ2xvYmFscz86IGFueTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBnbG9iYWxTZXR1cD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGdsb2JhbFRlYXJkb3duPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaGFzdGU/OiBIYXN0ZUNvbmZpZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGluamVjdEdsb2JhbHM/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWF4Q29uY3VycmVuY3k/OiBudW1iZXI7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbW9kdWxlRGlyZWN0b3JpZXM/OiBzdHJpbmdbXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1vZHVsZUZpbGVFeHRlbnNpb25zPzogc3RyaW5nW107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbW9kdWxlTmFtZU1hcHBlcj86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIHwgc3RyaW5nW10gfTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1vZHVsZVBhdGhJZ25vcmVQYXR0ZXJucz86IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtb2R1bGVQYXRocz86IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBub3RpZnk/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBub3RpZnlNb2RlPzogJ2Fsd2F5cycgfCAnZmFpbHVyZScgfCAnc3VjY2VzcycgfCAnY2hhbmdlJyB8ICdzdWNjZXNzLWNoYW5nZScgfCAnZmFpbHVyZS1jaGFuZ2UnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHByZXNldD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwcmV0dGllclBhdGg/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwcm9qZWN0cz86IEFycmF5PHN0cmluZyB8IHsgW2tleTogc3RyaW5nXTogYW55IH0+O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlcG9ydGVycz86IEplc3RSZXBvcnRlcltdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlc2V0TW9ja3M/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmVzZXRNb2R1bGVzPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmVzb2x2ZXI/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZXN0b3JlTW9ja3M/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcm9vdERpcj86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcm9vdHM/OiBzdHJpbmdbXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcnVubmVyPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNldHVwRmlsZXM/OiBzdHJpbmdbXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNldHVwRmlsZXNBZnRlckVudj86IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzbG93VGVzdFRocmVzaG9sZD86IG51bWJlcjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzbmFwc2hvdFJlc29sdmVyPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc25hcHNob3RTZXJpYWxpemVycz86IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRlc3RFbnZpcm9ubWVudD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0ZXN0RW52aXJvbm1lbnRPcHRpb25zPzogYW55O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGVzdEZhaWx1cmVFeGl0Q29kZT86IG51bWJlcjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRlc3RNYXRjaD86IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0ZXN0UGF0aElnbm9yZVBhdHRlcm5zPzogc3RyaW5nW107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0ZXN0UmVnZXg/OiBzdHJpbmcgfCBzdHJpbmdbXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0ZXN0UmVzdWx0c1Byb2Nlc3Nvcj86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRlc3RSdW5uZXI/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0ZXN0U2VxdWVuY2VyPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0ZXN0VGltZW91dD86IG51bWJlcjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRlc3RVUkw/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRpbWVycz86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdHJhbnNmb3JtPzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfCBbc3RyaW5nLCBhbnldIH07XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRyYW5zZm9ybUlnbm9yZVBhdHRlcm5zPzogc3RyaW5nW107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdW5tb2NrZWRNb2R1bGVQYXRoUGF0dGVybnM/OiBzdHJpbmdbXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB2ZXJib3NlPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHdhdGNoUGF0aElnbm9yZVBhdHRlcm5zPzogc3RyaW5nW107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHdhdGNoUGx1Z2lucz86IFtzdHJpbmcgfCBbc3RyaW5nLCBhbnldXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgd2F0Y2htYW4/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBFc2NhcGUgaGF0Y2ggdG8gYWxsb3cgYW55IHZhbHVlXG4gICAqL1xuICByZWFkb25seSBbbmFtZTogc3RyaW5nXTogYW55O1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEplc3RPcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY292ZXJhZ2U/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY292ZXJhZ2VUZXh0PzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaWdub3JlUGF0dGVybnM/OiBzdHJpbmdbXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkganVuaXRSZXBvcnRpbmc/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHByZXNlcnZlRGVmYXVsdFJlcG9ydGVycz86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGplc3RWZXJzaW9uPzogc3RyaW5nO1xuXG4gIHJlYWRvbmx5IGplc3RDb25maWc/OiBKZXN0Q29uZmlnT3B0aW9ucztcblxuICByZWFkb25seSB0eXBlc2NyaXB0Q29uZmlnPzogVHlwZXNjcmlwdENvbmZpZ09wdGlvbnM7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQ292ZXJhZ2VUaHJlc2hvbGQge1xuICByZWFkb25seSBicmFuY2hlcz86IG51bWJlcjtcbiAgcmVhZG9ubHkgZnVuY3Rpb25zPzogbnVtYmVyO1xuICByZWFkb25seSBsaW5lcz86IG51bWJlcjtcbiAgcmVhZG9ubHkgc3RhdGVtZW50cz86IG51bWJlcjtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBIYXN0ZUNvbmZpZyB7XG4gIHJlYWRvbmx5IGNvbXB1dGVTaGExPzogYm9vbGVhbjtcbiAgcmVhZG9ubHkgZGVmYXVsdFBsYXRmb3JtPzogc3RyaW5nIHwgdW5kZWZpbmVkO1xuICByZWFkb25seSBoYXN0ZUltcGxNb2R1bGVQYXRoPzogc3RyaW5nO1xuICByZWFkb25seSBwbGF0Zm9ybXM/OiBBcnJheTxzdHJpbmc+O1xuICByZWFkb25seSB0aHJvd09uTW9kdWxlQ29sbGlzaW9uPzogYm9vbGVhbjtcbn1cblxudHlwZSBKZXN0UmVwb3J0ZXIgPSBbc3RyaW5nLCB7IFtrZXk6IHN0cmluZ106IGFueSB9XSB8IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEplc3Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBjb25maWc6IGFueTtcblxuICBwcml2YXRlIHJlYWRvbmx5IHRlc3RNYXRjaDogc3RyaW5nW11cbiAgcHJpdmF0ZSByZWFkb25seSBpZ25vcmVQYXR0ZXJuczogc3RyaW5nW107XG4gIHByaXZhdGUgcmVhZG9ubHkgd2F0Y2hJZ25vcmVQYXR0ZXJuczogc3RyaW5nW107XG4gIHByaXZhdGUgcmVhZG9ubHkgY292ZXJhZ2VSZXBvcnRlcnM6IHN0cmluZ1tdO1xuICBwcml2YXRlIHJlYWRvbmx5IHByb2plY3Q6IE5vZGVQcm9qZWN0O1xuICBwcml2YXRlIHJlYWRvbmx5IHJlcG9ydGVyczogSmVzdFJlcG9ydGVyW107XG4gIHByaXZhdGUgcmVhZG9ubHkgamVzdENvbmZpZz86IEplc3RDb25maWdPcHRpb25zO1xuICBwcml2YXRlIHJlYWRvbmx5IHR5cGVzY3JpcHRDb25maWc/OiBUeXBlc2NyaXB0Q29uZmlnT3B0aW9ucztcbiAgcHJpdmF0ZSBfc25hcHNob3RSZXNvbHZlcjogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IE5vZGVQcm9qZWN0LCBvcHRpb25zOiBKZXN0T3B0aW9ucyA9IHt9KSB7XG4gICAgdGhpcy5wcm9qZWN0ID0gcHJvamVjdDtcblxuICAgIGNvbnN0IGplc3REZXAgPSBvcHRpb25zLmplc3RWZXJzaW9uID8gYGplc3RAJHtvcHRpb25zLmplc3RWZXJzaW9ufWAgOiAnamVzdCc7XG4gICAgcHJvamVjdC5hZGREZXZEZXBzKGplc3REZXApO1xuXG4gICAgdGhpcy5qZXN0Q29uZmlnID0gb3B0aW9ucy5qZXN0Q29uZmlnO1xuICAgIHRoaXMudHlwZXNjcmlwdENvbmZpZyA9IG9wdGlvbnMudHlwZXNjcmlwdENvbmZpZztcblxuICAgIHRoaXMuaWdub3JlUGF0dGVybnMgPSB0aGlzLmplc3RDb25maWc/LnRlc3RQYXRoSWdub3JlUGF0dGVybnMgPz8gb3B0aW9ucy5pZ25vcmVQYXR0ZXJucyA/PyBbJy9ub2RlX21vZHVsZXMvJ107XG4gICAgdGhpcy53YXRjaElnbm9yZVBhdHRlcm5zID0gdGhpcy5qZXN0Q29uZmlnPy53YXRjaFBhdGhJZ25vcmVQYXR0ZXJucyA/PyBbJy9ub2RlX21vZHVsZXMvJ107XG4gICAgdGhpcy5jb3ZlcmFnZVJlcG9ydGVycyA9IHRoaXMuamVzdENvbmZpZz8uY292ZXJhZ2VSZXBvcnRlcnMgPz8gWydqc29uJywgJ2xjb3YnLCAnY2xvdmVyJ107XG4gICAgdGhpcy50ZXN0TWF0Y2ggPSB0aGlzLmplc3RDb25maWc/LnRlc3RNYXRjaCA/PyBbJyoqXFwvX190ZXN0c19fLyoqXFwvKi5banRdcz8oeCknLCAnKipcXC8/KCouKSsoc3BlY3x0ZXN0KS5bdGpdcz8oeCknXTtcblxuICAgIGNvbnN0IGNvdmVyYWdlRGlyZWN0b3J5ID0gdGhpcy5qZXN0Q29uZmlnPy5jb3ZlcmFnZURpcmVjdG9yeSA/PyAnY292ZXJhZ2UnO1xuXG4gICAgdGhpcy5yZXBvcnRlcnMgPSBbXTtcblxuICAgIGlmIChvcHRpb25zLnByZXNlcnZlRGVmYXVsdFJlcG9ydGVycyA/PyB0cnVlKSB7XG4gICAgICB0aGlzLnJlcG9ydGVycy51bnNoaWZ0KCdkZWZhdWx0Jyk7XG4gICAgfVxuXG4gICAgdGhpcy5jb25maWcgPSB7XG4gICAgICAuLi50aGlzLmplc3RDb25maWcsXG4gICAgICBjbGVhck1vY2tzOiB0aGlzLmplc3RDb25maWc/LmNsZWFyTW9ja3MgPz8gdHJ1ZSxcbiAgICAgIGNvbGxlY3RDb3ZlcmFnZTogb3B0aW9ucy5jb3ZlcmFnZSA/PyB0aGlzLmplc3RDb25maWc/LmNvbGxlY3RDb3ZlcmFnZSA/PyB0cnVlLFxuICAgICAgY292ZXJhZ2VSZXBvcnRlcnM6IHRoaXMuY292ZXJhZ2VSZXBvcnRlcnMsXG4gICAgICBjb3ZlcmFnZURpcmVjdG9yeTogY292ZXJhZ2VEaXJlY3RvcnksXG4gICAgICBjb3ZlcmFnZVBhdGhJZ25vcmVQYXR0ZXJuczogdGhpcy5qZXN0Q29uZmlnPy5jb3ZlcmFnZVBhdGhJZ25vcmVQYXR0ZXJucyA/PyB0aGlzLmlnbm9yZVBhdHRlcm5zLFxuICAgICAgdGVzdFBhdGhJZ25vcmVQYXR0ZXJuczogdGhpcy5pZ25vcmVQYXR0ZXJucyxcbiAgICAgIHdhdGNoUGF0aElnbm9yZVBhdHRlcm5zOiB0aGlzLndhdGNoSWdub3JlUGF0dGVybnMsXG4gICAgICB0ZXN0TWF0Y2g6IHRoaXMudGVzdE1hdGNoLFxuICAgICAgcmVwb3J0ZXJzOiB0aGlzLnJlcG9ydGVycyxcbiAgICAgIHNuYXBzaG90UmVzb2x2ZXI6ICgoKSA9PiB0aGlzLl9zbmFwc2hvdFJlc29sdmVyKSBhcyBhbnksXG4gICAgfSBhcyBKZXN0Q29uZmlnT3B0aW9ucztcblxuICAgIGlmIChvcHRpb25zLmp1bml0UmVwb3J0aW5nID8/IHRydWUpIHtcbiAgICAgIGNvbnN0IHJlcG9ydHNEaXIgPSBERUZBVUxUX1RFU1RfUkVQT1JUU19ESVI7XG5cbiAgICAgIHRoaXMuYWRkUmVwb3J0ZXIoW1xuICAgICAgICAnamVzdC1qdW5pdCcsXG4gICAgICAgIHsgb3V0cHV0RGlyZWN0b3J5OiByZXBvcnRzRGlyIH0sXG4gICAgICBdKTtcblxuICAgICAgcHJvamVjdC5hZGREZXZEZXBzKCdqZXN0LWp1bml0QF4xMicpO1xuXG4gICAgICBwcm9qZWN0LmdpdGlnbm9yZS5leGNsdWRlKFxuICAgICAgICAnIyBqZXN0LWp1bml0IGFydGlmYWN0cycsXG4gICAgICAgIGAvJHtyZXBvcnRzRGlyfS9gLFxuICAgICAgICAnanVuaXQueG1sJyxcbiAgICAgICk7XG4gICAgICBwcm9qZWN0Lm5wbWlnbm9yZT8uZXhjbHVkZShcbiAgICAgICAgJyMgamVzdC1qdW5pdCBhcnRpZmFjdHMnLFxuICAgICAgICBgLyR7cmVwb3J0c0Rpcn0vYCxcbiAgICAgICAgJ2p1bml0LnhtbCcsXG4gICAgICApO1xuICAgIH1cblxuICAgIGlmICh0aGlzLmplc3RDb25maWc/LnJlcG9ydGVycykge1xuICAgICAgZm9yIChjb25zdCByZXBvcnRlciBvZiB0aGlzLmplc3RDb25maWcucmVwb3J0ZXJzKSB7XG4gICAgICAgIHRoaXMuYWRkUmVwb3J0ZXIocmVwb3J0ZXIpO1xuICAgICAgfVxuICAgIH1cblxuICAgIGlmICh0aGlzLmplc3RDb25maWc/LmNvdmVyYWdlVGhyZXNob2xkKSB7XG4gICAgICB0aGlzLmNvbmZpZy5jb3ZlcmFnZVRocmVzaG9sZCA9IHtcbiAgICAgICAgZ2xvYmFsOiB0aGlzLmplc3RDb25maWc/LmNvdmVyYWdlVGhyZXNob2xkLFxuICAgICAgfTtcbiAgICB9XG5cbiAgICB0aGlzLmNvbmZpZ3VyZVRlc3RDb21tYW5kKCk7XG5cbiAgICBwcm9qZWN0LmFkZEZpZWxkcyh7IGplc3Q6IHRoaXMuY29uZmlnIH0pO1xuXG4gICAgY29uc3QgY292ZXJhZ2VEaXJlY3RvcnlQYXRoID0gcGF0aC5wb3NpeC5qb2luKCcvJywgY292ZXJhZ2VEaXJlY3RvcnkpO1xuICAgIHByb2plY3QubnBtaWdub3JlPy5leGNsdWRlKGNvdmVyYWdlRGlyZWN0b3J5UGF0aCk7XG4gICAgcHJvamVjdC5naXRpZ25vcmUuZXhjbHVkZShjb3ZlcmFnZURpcmVjdG9yeVBhdGgpO1xuXG4gICAgaWYgKG9wdGlvbnMuY292ZXJhZ2VUZXh0ID8/IHRydWUpIHtcbiAgICAgIHRoaXMuY292ZXJhZ2VSZXBvcnRlcnMucHVzaCgndGV4dCcpO1xuICAgIH1cbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYWRkVGVzdE1hdGNoKHBhdHRlcm46IHN0cmluZykge1xuICAgIHRoaXMudGVzdE1hdGNoLnB1c2gocGF0dGVybik7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBhZGRXYXRjaElnbm9yZVBhdHRlcm4ocGF0dGVybjogc3RyaW5nKSB7XG4gICAgdGhpcy53YXRjaElnbm9yZVBhdHRlcm5zLnB1c2gocGF0dGVybik7XG4gIH1cblxuICBwdWJsaWMgYWRkSWdub3JlUGF0dGVybihwYXR0ZXJuOiBzdHJpbmcpIHtcbiAgICB0aGlzLmlnbm9yZVBhdHRlcm5zLnB1c2gocGF0dGVybik7XG4gIH1cblxuICBwdWJsaWMgYWRkUmVwb3J0ZXIocmVwb3J0ZXI6IEplc3RSZXBvcnRlcikge1xuICAgIHRoaXMucmVwb3J0ZXJzLnB1c2gocmVwb3J0ZXIpO1xuICB9XG5cbiAgcHVibGljIGFkZFNuYXBzaG90UmVzb2x2ZXIoZmlsZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fc25hcHNob3RSZXNvbHZlciA9IGZpbGU7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgZ2VuZXJhdGVUeXBlc2NyaXB0Q29uZmlnKG9wdGlvbnM6IFR5cGVzY3JpcHRDb25maWdPcHRpb25zKSB7XG4gICAgY29uc3QgdHNjb25maWcgPSBuZXcgVHlwZXNjcmlwdENvbmZpZyh0aGlzLnByb2plY3QsIHtcbiAgICAgIGZpbGVOYW1lOiBvcHRpb25zLmZpbGVOYW1lID8/ICd0c2NvbmZpZy5qZXN0Lmpzb24nLFxuICAgICAgaW5jbHVkZTogW1xuICAgICAgICAuLi5vcHRpb25zLmluY2x1ZGUgPyBvcHRpb25zLmluY2x1ZGUgOiBbXSxcbiAgICAgICAgLi4udGhpcy50eXBlc2NyaXB0Q29uZmlnPy5pbmNsdWRlID8gdGhpcy50eXBlc2NyaXB0Q29uZmlnPy5pbmNsdWRlIDogW10sXG4gICAgICBdLFxuICAgICAgZXhjbHVkZTogW1xuICAgICAgICAuLi5vcHRpb25zLmV4Y2x1ZGUgPyBvcHRpb25zLmV4Y2x1ZGUgOiBbXSxcbiAgICAgICAgLi4udGhpcy50eXBlc2NyaXB0Q29uZmlnPy5leGNsdWRlID8gdGhpcy50eXBlc2NyaXB0Q29uZmlnPy5leGNsdWRlIDogW10sXG4gICAgICBdLFxuICAgICAgY29tcGlsZXJPcHRpb25zOiB7XG4gICAgICAgIC4uLm9wdGlvbnMuY29tcGlsZXJPcHRpb25zLFxuICAgICAgICAuLi50aGlzLnR5cGVzY3JpcHRDb25maWc/LmNvbXBpbGVyT3B0aW9ucyxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICB0aGlzLmNvbmZpZy5wcmVzZXQgPSAndHMtamVzdCc7XG5cbiAgICAvLyBvbmx5IHByb2Nlc3MgLnRzIGZpbGVzXG4gICAgdGhpcy5jb25maWcudGVzdE1hdGNoID0gdGhpcy5qZXN0Q29uZmlnPy50ZXN0TWF0Y2ggPz8gW1xuICAgICAgJyoqL19fdGVzdHNfXy8qKi8qLnRzPyh4KScsXG4gICAgICAnKiovPygqLikrKHNwZWN8dGVzdCkudHM/KHgpJyxcbiAgICBdO1xuXG4gICAgLy8gc3BlY2lmeSB0c2NvbmZpZy5qc29uXG4gICAgdGhpcy5jb25maWcuZ2xvYmFscyA9IHtcbiAgICAgICd0cy1qZXN0Jzoge1xuICAgICAgICB0c2NvbmZpZzogdHNjb25maWcuZmlsZU5hbWUsXG4gICAgICB9LFxuICAgIH07XG5cbiAgICAvLyBhZGQgcmVsZXZhbnQgZGVwc1xuICAgIHRoaXMucHJvamVjdC5hZGREZXZEZXBzKFxuICAgICAgJ0B0eXBlcy9qZXN0JyxcbiAgICAgICd0cy1qZXN0JyxcbiAgICApO1xuXG4gICAgcmV0dXJuIHRzY29uZmlnO1xuICB9XG5cbiAgcHJpdmF0ZSBjb25maWd1cmVUZXN0Q29tbWFuZCgpIHtcbiAgICBjb25zdCBqZXN0T3B0cyA9IFsnLS1wYXNzV2l0aE5vVGVzdHMnLCAnLS1hbGwnXTtcblxuICAgIC8vIGlmIHRoZSBwcm9qZWN0IGhhcyBhbnRpLXRhbXBlciBjb25maWd1cmVkLCBpdCBzaG91bGQgYmUgc2FmZSB0byBhbHdheXMgcnVuIHRlc3RzXG4gICAgLy8gd2l0aCAtLXVwZGF0ZVNuYXBzaG90IGJlY2F1c2UgaWYgd2UgZm9yZ2V0IHRvIGNvbW1pdCBhIHNuYXBzaG90IGNoYW5nZSB0aGUgQ0kgYnVpbGQgd2lsbCBmYWlsLlxuICAgIGlmICh0aGlzLnByb2plY3QuYW50aXRhbXBlcikge1xuICAgICAgamVzdE9wdHMucHVzaCgnLS11cGRhdGVTbmFwc2hvdCcpO1xuICAgIH1cblxuICAgIC8vIGFzIHJlY29tbWVuZGVkIGluIHRoZSBqZXN0IGRvY3MsIG5vZGUgPiAxNCBtYXkgdXNlIG5hdGl2ZSB2OCBjb3ZlcmFnZSBjb2xsZWN0aW9uXG4gICAgLy8gaHR0cHM6Ly9qZXN0anMuaW8vZG9jcy9lbi9jbGkjLS1jb3ZlcmFnZXByb3ZpZGVycHJvdmlkZXJcbiAgICBpZiAodGhpcy5wcm9qZWN0LnBhY2thZ2UubWluTm9kZVZlcnNpb24gJiYgc2VtdmVyLmd0ZSh0aGlzLnByb2plY3QucGFja2FnZS5taW5Ob2RlVmVyc2lvbiwgJzE0LjAuMCcpKSB7XG4gICAgICBqZXN0T3B0cy5wdXNoKCctLWNvdmVyYWdlUHJvdmlkZXI9djgnKTtcbiAgICB9XG5cbiAgICB0aGlzLnByb2plY3QudGVzdFRhc2suZXhlYyhgamVzdCAke2plc3RPcHRzLmpvaW4oJyAnKX1gKTtcblxuICAgIHRoaXMucHJvamVjdC5hZGRUYXNrKCd0ZXN0OndhdGNoJywge1xuICAgICAgZGVzY3JpcHRpb246ICdSdW4gamVzdCBpbiB3YXRjaCBtb2RlJyxcbiAgICAgIGNhdGVnb3J5OiBUYXNrQ2F0ZWdvcnkuVEVTVCxcbiAgICAgIGV4ZWM6ICdqZXN0IC0td2F0Y2gnLFxuICAgIH0pO1xuXG4gICAgdGhpcy5wcm9qZWN0LmFkZFRhc2soJ3Rlc3Q6dXBkYXRlJywge1xuICAgICAgZGVzY3JpcHRpb246ICdVcGRhdGUgamVzdCBzbmFwc2hvdHMnLFxuICAgICAgY2F0ZWdvcnk6IFRhc2tDYXRlZ29yeS5URVNULFxuICAgICAgZXhlYzogJ2plc3QgLS11cGRhdGVTbmFwc2hvdCcsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==