"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("..");
const util_1 = require("./util");
test('json object can be mutated before synthesis', () => {
    const prj = new util_1.TestProject();
    const obj = {
        hello: 'world',
    };
    new __1.JsonFile(prj, 'my/json/file.json', { obj, marker: false });
    // mutate obj (should be reflected in the output)
    obj.anotherField = {
        foo: 1234,
    };
    expect(util_1.synthSnapshot(prj)['my/json/file.json']).toStrictEqual({
        hello: 'world',
        anotherField: { foo: 1234 },
    });
});
test('omitEmpty', () => {
    // GIVEN
    const p = new util_1.TestProject();
    // WHEN
    new __1.JsonFile(p, 'file.json', {
        omitEmpty: true,
        obj: {
            hello: 1234,
            empty: {},
            array_with_undefined: [undefined, 123, 456],
            child: {
                with: 'hello',
                empty: {
                    subchild: {},
                },
                empty_strings_are_not_omitted: '',
                zeros_are_not_omitted: 0,
                empty_array: [],
                array_with_empty_objects: [{}, 123],
                array_with_empty_subobjects: [
                    {
                        i_am_empty: {},
                        i_am_not: 'hi there',
                    },
                    {
                        just: 1234,
                    },
                ],
            },
        },
        marker: false,
    });
    // THEN
    expect(util_1.synthSnapshot(p)['file.json']).toStrictEqual({
        hello: 1234,
        array_with_undefined: [123, 456],
        child: {
            with: 'hello',
            empty_strings_are_not_omitted: '',
            zeros_are_not_omitted: 0,
            array_with_empty_objects: [123],
            array_with_empty_subobjects: [
                {
                    i_am_not: 'hi there',
                },
                {
                    just: 1234,
                },
            ],
        },
    });
});
test('json file can contain projen marker', () => {
    const prj = new util_1.TestProject();
    const obj = {};
    new __1.JsonFile(prj, 'my/json/file-marker.json', { obj, marker: true });
    const output = util_1.synthSnapshot(prj)['my/json/file-marker.json'];
    expect(output['//']).toBe(__1.JsonFile.PROJEN_MARKER);
});
//# sourceMappingURL=data:application/json;base64,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