/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.runtime;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;
import textworldexpress.generator.GameGenerator;
import textworldexpress.generator.GameGenerator$;
import textworldexpress.runtime.PythonInterface$;
import textworldexpress.struct.StepResult;
import textworldexpress.struct.StepResult$;
import textworldexpress.struct.TextGame;

public class PythonInterface {
    private final String ERROR_MESSAGE_UNINITIALIZED;
    private String errorStr = "";
    private GameGenerator gameGenerator = null;
    private TextGame game = null;
    private String[] goldPath = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    private Map<String, Object> properties = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    private StepResult curStepResult = null;

    public static void main(String[] args) {
        PythonInterface$.MODULE$.main(args);
    }

    public static void printUsage() {
        PythonInterface$.MODULE$.printUsage();
    }

    public static Tuple2<Map<String, Object>, String> parseParamStr(String strIn) {
        return PythonInterface$.MODULE$.parseParamStr(strIn);
    }

    public String ERROR_MESSAGE_UNINITIALIZED() {
        return this.ERROR_MESSAGE_UNINITIALIZED;
    }

    public String errorStr() {
        return this.errorStr;
    }

    public void errorStr_$eq(String x$1) {
        this.errorStr = x$1;
    }

    public GameGenerator gameGenerator() {
        return this.gameGenerator;
    }

    public void gameGenerator_$eq(GameGenerator x$1) {
        this.gameGenerator = x$1;
    }

    public TextGame game() {
        return this.game;
    }

    public void game_$eq(TextGame x$1) {
        this.game = x$1;
    }

    public String[] goldPath() {
        return this.goldPath;
    }

    public void goldPath_$eq(String[] x$1) {
        this.goldPath = x$1;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public void properties_$eq(Map<String, Object> x$1) {
        this.properties = x$1;
    }

    public StepResult curStepResult() {
        return this.curStepResult;
    }

    public void curStepResult_$eq(StepResult x$1) {
        this.curStepResult = x$1;
    }

    public String load(String gameName, String paramStr) {
        this.game_$eq(null);
        this.goldPath_$eq((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        this.errorStr_$eq("");
        this.curStepResult_$eq(null);
        this.gameGenerator_$eq(null);
        Tuple2<Map<String, Object>, String> tuple2 = PythonInterface$.MODULE$.parseParamStr(paramStr);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map<String, Object> _props = tuple2._1();
        String propErrorStr = tuple2._2();
        Tuple2<Map<String, Object>, String> tuple22 = new Tuple2<Map<String, Object>, String>(_props, propErrorStr);
        Tuple2<Map<String, Object>, String> tuple23 = tuple22;
        Map<String, Object> _props2 = tuple23._1();
        String propErrorStr2 = tuple23._2();
        if (propErrorStr2.length() > 0) {
            return this.errorStr();
        }
        this.properties_$eq(_props2);
        Tuple2<Object, GameGenerator> tuple24 = GameGenerator$.MODULE$.mkGameGenerator(gameName, this.properties());
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        boolean success = tuple24._1$mcZ$sp();
        GameGenerator gameGenerator = tuple24._2();
        Tuple2<Boolean, GameGenerator> tuple25 = new Tuple2<Boolean, GameGenerator>(BoxesRunTime.boxToBoolean(success), gameGenerator);
        Tuple2<Boolean, GameGenerator> tuple26 = tuple25;
        boolean success2 = tuple26._1$mcZ$sp();
        GameGenerator gameGenerator2 = tuple26._2();
        if (!success2) {
            Predef$.MODULE$.println("ERROR creating Game Generator: ");
            Predef$.MODULE$.println(gameGenerator2.errorStr());
            this.errorStr_$eq(gameGenerator2.errorStr());
            return this.errorStr();
        }
        this.gameGenerator_$eq(gameGenerator2);
        return "";
    }

    public StepResult loadAndMake(String gameName, String gameFold, int seed, String paramStr, boolean generateGoldPath) {
        String errMsg;
        String string = errMsg = this.load(gameName, paramStr);
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            return StepResult$.MODULE$.mkErrorMessage(errMsg);
        }
        return this.generateNewGame(seed, gameFold, generateGoldPath);
    }

    public String loadJSON(String gameName, String gameFold, int seed, String paramStr, boolean generateGoldPath) {
        StepResult stepResult = this.loadAndMake(gameName, gameFold, seed, paramStr, generateGoldPath);
        return stepResult.toJSON();
    }

    public StepResult generateNewGame(int seed, String gameFold, boolean generateGoldPath) {
        if (this.gameGenerator() == null) {
            this.errorStr_$eq("ERROR: Game generator is not initialized.  Call load() before attempting to generate new games.");
            return StepResult$.MODULE$.mkErrorMessage(this.errorStr());
        }
        if (generateGoldPath) {
            Tuple2<TextGame, String[]> tuple2 = this.gameGenerator().mkGameWithGoldPath(seed, gameFold);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TextGame _game = tuple2._1();
            String[] _goldPath = tuple2._2();
            Tuple2<TextGame, String[]> tuple22 = new Tuple2<TextGame, String[]>(_game, _goldPath);
            Tuple2<TextGame, String[]> tuple23 = tuple22;
            TextGame _game2 = tuple23._1();
            String[] _goldPath2 = tuple23._2();
            this.game_$eq(_game2);
            this.goldPath_$eq(_goldPath2);
            if (this.goldPath().length == 0) {
                this.errorStr_$eq("ERROR: Unable to generate gold path.");
            }
        } else {
            this.game_$eq(this.gameGenerator().mkGame(seed, gameFold));
        }
        this.curStepResult_$eq(this.game().initalStep());
        return this.curStepResult();
    }

    public String generateNewGameJSON(int seed, String gameFold, boolean generateGoldPath) {
        StepResult stepResult = this.generateNewGame(seed, gameFold, generateGoldPath);
        return stepResult.toJSON();
    }

    public StepResult resetWithRandomSeed(String gameFold, boolean generateGoldPath) {
        int randSeed;
        block5: {
            randSeed = -1;
            String string = gameFold;
            switch (string == null ? 0 : string.hashCode()) {
                case 99349: {
                    if (!"dev".equals(string)) break;
                    randSeed = this.getRandomSeedDev();
                    break block5;
                }
                case 3556498: {
                    if (!"test".equals(string)) break;
                    randSeed = this.getRandomSeedTest();
                    break block5;
                }
                case 110621192: {
                    if (!"train".equals(string)) break;
                    randSeed = this.getRandomSeedTrain();
                    break block5;
                }
            }
            this.errorStr_$eq(new StringBuilder(67).append("ERROR: Unknown game fold (").append(gameFold).append(").  Valid options are (train, dev, test).").toString());
            return StepResult$.MODULE$.mkErrorMessage(this.errorStr());
        }
        return this.generateNewGame(randSeed, gameFold, generateGoldPath);
    }

    public String resetWithRandomSeedJSON(String gameFold, boolean generateGoldPath) {
        StepResult stepResult = this.resetWithRandomSeed(gameFold, generateGoldPath);
        return stepResult.toJSON();
    }

    public void shutdown() {
        throw scala.sys.package$.MODULE$.exit(0);
    }

    public List<String> getGameNames() {
        return JavaConverters$.MODULE$.seqAsJavaListConverter(Predef$.MODULE$.wrapRefArray((Object[])GameGenerator$.MODULE$.VALID_GAME_NAMES()).toList()).asJava();
    }

    public String getGenerationPropertiesJSON() {
        if (this.game() == null) {
            return "{}";
        }
        Map<String, Object> props = this.game().getGenerationProperties();
        ArrayBuffer propStrs = new ArrayBuffer();
        props.keySet().foreach((Function1<String, ArrayBuffer> & Serializable)propName -> (ArrayBuffer)propStrs.append(new StringBuilder(4).append("\"").append((String)propName).append("\": ").append(props.apply((String)propName)).toString()));
        return new StringBuilder(2).append("{").append(propStrs.mkString(", ")).append("}").toString();
    }

    public String getTaskDescription() {
        if (this.game() == null) {
            return "Task description unavailable -- game is not initialized.";
        }
        return this.game().getTaskDescription();
    }

    public String getObjectTree(String path) {
        if (this.game() == null) {
            return "Object tree unavailable -- game is not initialized. Call env.reset first.";
        }
        String objTree = this.game().getObjectTree();
        String string = path;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return objTree;
        }
        PrintWriter pw = new PrintWriter(path);
        pw.print(objTree);
        pw.close();
        return "";
    }

    public String getObjectTree$default$1() {
        return "";
    }

    public List<Object> getSeedsTrain() {
        return JavaConverters$.MODULE$.seqAsJavaListConverter(package$.MODULE$.Range().apply(0, 1000).toList()).asJava();
    }

    public List<Object> getSeedsDev() {
        return JavaConverters$.MODULE$.seqAsJavaListConverter(package$.MODULE$.Range().apply(10000, 11000).toList()).asJava();
    }

    public List<Object> getSeedsTest() {
        return JavaConverters$.MODULE$.seqAsJavaListConverter(package$.MODULE$.Range().apply(20000, 21000).toList()).asJava();
    }

    public int getRandomSeedTrain() {
        int randSeed = Random$.MODULE$.nextInt(1000) + 0;
        return randSeed;
    }

    public int getRandomSeedDev() {
        int randSeed = Random$.MODULE$.nextInt(1000) + 10000;
        return randSeed;
    }

    public int getRandomSeedTest() {
        int randSeed = Random$.MODULE$.nextInt(1000) + 20000;
        return randSeed;
    }

    public List<String> getGoldActionSequence() {
        return JavaConverters$.MODULE$.seqAsJavaListConverter(Predef$.MODULE$.wrapRefArray((Object[])this.goldPath()).toList()).asJava();
    }

    public boolean getCompleted() {
        if (this.curStepResult() == null) {
            return true;
        }
        return this.curStepResult().taskSuccess() || this.curStepResult().taskFailure();
    }

    public StepResult step(String userInputString) {
        String string = this.errorStr();
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            return StepResult$.MODULE$.mkErrorMessage(this.errorStr());
        }
        if (this.game() == null) {
            return StepResult$.MODULE$.mkErrorMessage(this.ERROR_MESSAGE_UNINITIALIZED());
        }
        String userInputSanitized = userInputString.trim();
        if (!ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(this.curStepResult().validActions()), userInputSanitized)) {
            return StepResult$.MODULE$.mkInvalidStep(this.curStepResult());
        }
        this.curStepResult_$eq(this.game().step(userInputSanitized));
        return this.curStepResult();
    }

    public String stepJSON(String userInputString) {
        StepResult stepResult = this.step(userInputString);
        return stepResult.toJSON();
    }

    public PythonInterface() {
        this.ERROR_MESSAGE_UNINITIALIZED = "ERROR: Interface is not initialized -- call reset() before beginning.";
    }
}

