/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.generator;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import textworldexpress.generator.GameGenerator;
import textworldexpress.generator.GameGeneratorArithmetic;
import textworldexpress.generator.GameGeneratorCoin;
import textworldexpress.generator.GameGeneratorCookingWorld;
import textworldexpress.generator.GameGeneratorMapReader;
import textworldexpress.generator.GameGeneratorPeckingOrder;
import textworldexpress.generator.GameGeneratorSimonSays;
import textworldexpress.generator.GameGeneratorSimonSaysMemory;
import textworldexpress.generator.GameGeneratorSorting;
import textworldexpress.generator.GameGeneratorTWC;

public final class GameGenerator$ {
    public static final GameGenerator$ MODULE$ = new GameGenerator$();
    private static final String[] VALID_GAME_NAMES = (String[])((Object[])new String[]{"cookingworld", "twc", "coin", "mapreader", "arithmetic", "sorting", "simonsays", "peckingorder"});

    public String[] VALID_GAME_NAMES() {
        return VALID_GAME_NAMES;
    }

    private GameGenerator mkCookingWorld(Map<String, Object> properties) {
        String[] knownPropertyNames = (String[])((Object[])new String[]{"numLocations", "numDistractorItems", "numIngredients", "includeDoors", "limitInventorySize"});
        int numLocations = BoxesRunTime.unboxToInt(properties.getOrElse("numLocations", () -> 11));
        int numDistractorItems = BoxesRunTime.unboxToInt(properties.getOrElse("numDistractorItems", () -> 10));
        int numIngredients = BoxesRunTime.unboxToInt(properties.getOrElse("numIngredients", () -> 3));
        boolean includeDoors = BoxesRunTime.unboxToInt(properties.getOrElse("includeDoors", () -> 1)) == 1;
        boolean limitInventorySize = BoxesRunTime.unboxToInt(properties.getOrElse("limitInventorySize", () -> 1)) == 1;
        GameGeneratorCookingWorld game = new GameGeneratorCookingWorld(numLocations, numDistractorItems, numIngredients, includeDoors, limitInventorySize);
        properties.keySet().foreach((Function1<String, Object> & Serializable)propName -> {
            GameGenerator$.$anonfun$mkCookingWorld$6(knownPropertyNames, game, propName);
            return BoxedUnit.UNIT;
        });
        return game;
    }

    private GameGenerator mkTWC(Map<String, Object> properties) {
        String[] knownPropertyNames = (String[])((Object[])new String[]{"numLocations", "numItemsToPutAway", "includeDoors", "limitInventorySize"});
        int numLocations = BoxesRunTime.unboxToInt(properties.getOrElse("numLocations", () -> 3));
        int numItemsToPutAway = BoxesRunTime.unboxToInt(properties.getOrElse("numItemsToPutAway", () -> 4));
        boolean includeDoors = BoxesRunTime.unboxToInt(properties.getOrElse("includeDoors", () -> 0)) == 1;
        boolean limitInventorySize = BoxesRunTime.unboxToInt(properties.getOrElse("limitInventorySize", () -> 0)) == 1;
        GameGeneratorTWC game = new GameGeneratorTWC(numLocations, numItemsToPutAway, includeDoors, limitInventorySize);
        properties.keySet().foreach((Function1<String, Object> & Serializable)propName -> {
            GameGenerator$.$anonfun$mkTWC$5(knownPropertyNames, game, propName);
            return BoxedUnit.UNIT;
        });
        return game;
    }

    private GameGenerator mkCoin(Map<String, Object> properties) {
        String[] knownPropertyNames = (String[])((Object[])new String[]{"numLocations", "numDistractorItems", "includeDoors", "limitInventorySize"});
        int numLocations = BoxesRunTime.unboxToInt(properties.getOrElse("numLocations", () -> 11));
        int numDistractorItems = BoxesRunTime.unboxToInt(properties.getOrElse("numDistractorItems", () -> 0));
        boolean includeDoors = BoxesRunTime.unboxToInt(properties.getOrElse("includeDoors", () -> 1)) == 1;
        boolean limitInventorySize = BoxesRunTime.unboxToInt(properties.getOrElse("limitInventorySize", () -> 1)) == 1;
        GameGeneratorCoin game = new GameGeneratorCoin(numLocations, numDistractorItems, includeDoors, limitInventorySize);
        properties.keySet().foreach((Function1<String, Object> & Serializable)propName -> {
            GameGenerator$.$anonfun$mkCoin$5(knownPropertyNames, game, propName);
            return BoxedUnit.UNIT;
        });
        return game;
    }

    private GameGenerator mkMapReader(Map<String, Object> properties) {
        String[] knownPropertyNames = (String[])((Object[])new String[]{"numLocations", "maxDistractorItemsPerLocation", "includeDoors", "limitInventorySize", "maxDistanceApart"});
        int numLocations = BoxesRunTime.unboxToInt(properties.getOrElse("numLocations", () -> 15));
        int maxDistanceApart = BoxesRunTime.unboxToInt(properties.getOrElse("maxDistanceApart", () -> 4));
        int maxDistractorItemsPerLocation = BoxesRunTime.unboxToInt(properties.getOrElse("maxDistractorItemsPerLocation", () -> 3));
        boolean includeDoors = BoxesRunTime.unboxToInt(properties.getOrElse("includeDoors", () -> 0)) == 1;
        boolean limitInventorySize = BoxesRunTime.unboxToInt(properties.getOrElse("limitInventorySize", () -> 0)) == 1;
        GameGeneratorMapReader game = new GameGeneratorMapReader(numLocations, maxDistanceApart, maxDistractorItemsPerLocation, includeDoors, limitInventorySize);
        properties.keySet().foreach((Function1<String, Object> & Serializable)propName -> {
            GameGenerator$.$anonfun$mkMapReader$6(knownPropertyNames, game, propName);
            return BoxedUnit.UNIT;
        });
        return game;
    }

    private GameGenerator mkArithmetic(Map<String, Object> properties) {
        Object[] knownPropertyNames = (Object[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
        GameGeneratorArithmetic game = new GameGeneratorArithmetic();
        properties.keySet().foreach((Function1<String, Object> & Serializable)propName -> {
            GameGenerator$.$anonfun$mkArithmetic$1(knownPropertyNames, game, propName);
            return BoxedUnit.UNIT;
        });
        return game;
    }

    private GameGenerator mkSorting(Map<String, Object> properties) {
        Object[] knownPropertyNames = (Object[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
        GameGeneratorSorting game = new GameGeneratorSorting();
        properties.keySet().foreach((Function1<String, Object> & Serializable)propName -> {
            GameGenerator$.$anonfun$mkSorting$1(knownPropertyNames, game, propName);
            return BoxedUnit.UNIT;
        });
        return game;
    }

    private GameGenerator mkSimonSays(Map<String, Object> properties) {
        String[] knownPropertyNames = (String[])((Object[])new String[]{"gameLength", "numDistractors", "memorization", "verbose"});
        int gameLength = BoxesRunTime.unboxToInt(properties.getOrElse("gameLength", () -> 5));
        int numDistractors = BoxesRunTime.unboxToInt(properties.getOrElse("numDistractors", () -> 3));
        boolean memorization = BoxesRunTime.unboxToInt(properties.getOrElse("memorization", () -> 0)) == 1;
        int verbose = BoxesRunTime.unboxToInt(properties.getOrElse("verbose", () -> 0));
        GameGenerator game = memorization ? new GameGeneratorSimonSaysMemory(gameLength, numDistractors, verbose) : new GameGeneratorSimonSays(gameLength, numDistractors);
        properties.keySet().foreach((Function1<String, Object> & Serializable)propName -> {
            GameGenerator$.$anonfun$mkSimonSays$5(knownPropertyNames, game, propName);
            return BoxedUnit.UNIT;
        });
        return game;
    }

    private GameGenerator mkPeckingOrder(Map<String, Object> properties) {
        Object[] knownPropertyNames = (Object[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
        GameGeneratorPeckingOrder game = new GameGeneratorPeckingOrder();
        properties.keySet().foreach((Function1<String, Object> & Serializable)propName -> {
            GameGenerator$.$anonfun$mkPeckingOrder$1(knownPropertyNames, game, propName);
            return BoxedUnit.UNIT;
        });
        return game;
    }

    public Tuple2<Object, GameGenerator> mkGameGenerator(String gameName, Map<String, Object> properties) {
        String string = gameName.toLowerCase();
        switch (string == null ? 0 : string.hashCode()) {
            case -2024581756: {
                if (!"sorting".equals(string)) break;
                GameGenerator game = this.mkSorting(properties);
                return new Tuple2<Object, GameGenerator>(BoxesRunTime.boxToBoolean(!game.isInvalid()), game);
            }
            case -1722707767: {
                if (!"peckingorder".equals(string)) break;
                GameGenerator game = this.mkPeckingOrder(properties);
                return new Tuple2<Object, GameGenerator>(BoxesRunTime.boxToBoolean(!game.isInvalid()), game);
            }
            case -509396822: {
                if (!"arithmetic".equals(string)) break;
                GameGenerator game = this.mkArithmetic(properties);
                return new Tuple2<Object, GameGenerator>(BoxesRunTime.boxToBoolean(!game.isInvalid()), game);
            }
            case 115264: {
                if (!"twc".equals(string)) break;
                GameGenerator game = this.mkTWC(properties);
                return new Tuple2<Object, GameGenerator>(BoxesRunTime.boxToBoolean(!game.isInvalid()), game);
            }
            case 3059345: {
                if (!"coin".equals(string)) break;
                GameGenerator game = this.mkCoin(properties);
                return new Tuple2<Object, GameGenerator>(BoxesRunTime.boxToBoolean(!game.isInvalid()), game);
            }
            case 1786022175: {
                if (!"mapreader".equals(string)) break;
                GameGenerator game = this.mkMapReader(properties);
                return new Tuple2<Object, GameGenerator>(BoxesRunTime.boxToBoolean(!game.isInvalid()), game);
            }
            case 2048657464: {
                if (!"cookingworld".equals(string)) break;
                GameGenerator game = this.mkCookingWorld(properties);
                return new Tuple2<Object, GameGenerator>(BoxesRunTime.boxToBoolean(!game.isInvalid()), game);
            }
            case 2144225246: {
                if (!"simonsays".equals(string)) break;
                GameGenerator game = this.mkSimonSays(properties);
                return new Tuple2<Object, GameGenerator>(BoxesRunTime.boxToBoolean(!game.isInvalid()), game);
            }
        }
        GameGenerator game = this.mkCoin((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        game.errorStr_$eq(new StringBuilder(45).append(game.errorStr()).append("ERROR: Unknown game (").append(gameName).append(").  Valid game names: ").append(Predef$.MODULE$.wrapRefArray((Object[])this.VALID_GAME_NAMES()).mkString(", ")).append(". ").toString());
        return new Tuple2<Object, GameGenerator>(BoxesRunTime.boxToBoolean(false), game);
    }

    public static final /* synthetic */ void $anonfun$mkCookingWorld$6(String[] knownPropertyNames$1, GameGeneratorCookingWorld game$1, String propName) {
        block0: {
            if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(knownPropertyNames$1), propName)) break block0;
            game$1.errorStr_$eq(new StringBuilder(52).append(game$1.errorStr()).append("Unrecognized property name (").append(propName).append(").  Known properties: ").append(Predef$.MODULE$.wrapRefArray((Object[])knownPropertyNames$1).mkString(", ")).append(". ").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$mkTWC$5(String[] knownPropertyNames$2, GameGeneratorTWC game$2, String propName) {
        block0: {
            if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(knownPropertyNames$2), propName)) break block0;
            game$2.errorStr_$eq(new StringBuilder(52).append(game$2.errorStr()).append("Unrecognized property name (").append(propName).append(").  Known properties: ").append(Predef$.MODULE$.wrapRefArray((Object[])knownPropertyNames$2).mkString(", ")).append(". ").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$mkCoin$5(String[] knownPropertyNames$3, GameGeneratorCoin game$3, String propName) {
        block0: {
            if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(knownPropertyNames$3), propName)) break block0;
            game$3.errorStr_$eq(new StringBuilder(52).append(game$3.errorStr()).append("Unrecognized property name (").append(propName).append(").  Known properties: ").append(Predef$.MODULE$.wrapRefArray((Object[])knownPropertyNames$3).mkString(", ")).append(". ").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$mkMapReader$6(String[] knownPropertyNames$4, GameGeneratorMapReader game$4, String propName) {
        block0: {
            if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(knownPropertyNames$4), propName)) break block0;
            game$4.errorStr_$eq(new StringBuilder(52).append(game$4.errorStr()).append("Unrecognized property name (").append(propName).append(").  Known properties: ").append(Predef$.MODULE$.wrapRefArray((Object[])knownPropertyNames$4).mkString(", ")).append(". ").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$mkArithmetic$1(Object[] knownPropertyNames$5, GameGeneratorArithmetic game$5, String propName) {
        block0: {
            if (Predef$.MODULE$.copyArrayToImmutableIndexedSeq(knownPropertyNames$5).contains(propName)) break block0;
            game$5.errorStr_$eq(new StringBuilder(56).append(game$5.errorStr()).append("Unrecognized property name (").append(propName).append(").  Known properties: ").append(Predef$.MODULE$.copyArrayToImmutableIndexedSeq(knownPropertyNames$5).mkString(", ")).append("None. ").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$mkSorting$1(Object[] knownPropertyNames$6, GameGeneratorSorting game$6, String propName) {
        block0: {
            if (Predef$.MODULE$.copyArrayToImmutableIndexedSeq(knownPropertyNames$6).contains(propName)) break block0;
            game$6.errorStr_$eq(new StringBuilder(56).append(game$6.errorStr()).append("Unrecognized property name (").append(propName).append(").  Known properties: ").append(Predef$.MODULE$.copyArrayToImmutableIndexedSeq(knownPropertyNames$6).mkString(", ")).append("None. ").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$mkSimonSays$5(String[] knownPropertyNames$7, GameGenerator game$7, String propName) {
        block0: {
            if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(knownPropertyNames$7), propName)) break block0;
            game$7.errorStr_$eq(new StringBuilder(56).append(game$7.errorStr()).append("Unrecognized property name (").append(propName).append(").  Known properties: ").append(Predef$.MODULE$.wrapRefArray((Object[])knownPropertyNames$7).mkString(", ")).append("None. ").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$mkPeckingOrder$1(Object[] knownPropertyNames$8, GameGeneratorPeckingOrder game$8, String propName) {
        block0: {
            if (Predef$.MODULE$.copyArrayToImmutableIndexedSeq(knownPropertyNames$8).contains(propName)) break block0;
            game$8.errorStr_$eq(new StringBuilder(56).append(game$8.errorStr()).append("Unrecognized property name (").append(propName).append(").  Known properties: ").append(Predef$.MODULE$.copyArrayToImmutableIndexedSeq(knownPropertyNames$8).mkString(", ")).append("None. ").toString());
        }
    }

    private GameGenerator$() {
    }
}

