/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.games;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.Random;
import scala.util.control.Breaks$;
import textworldexpress.data.SortingProblemGenerator$;
import textworldexpress.games.SortingGame;
import textworldexpress.games.SortingGame$;
import textworldexpress.goldagent.SortingGoldAgent;
import textworldexpress.objects.Backyard;
import textworldexpress.objects.Bathroom;
import textworldexpress.objects.Bedroom;
import textworldexpress.objects.Box;
import textworldexpress.objects.Corridor;
import textworldexpress.objects.Driveway;
import textworldexpress.objects.FastObject;
import textworldexpress.objects.Kitchen;
import textworldexpress.objects.Kitchen$;
import textworldexpress.objects.LaundryRoom;
import textworldexpress.objects.LivingRoom;
import textworldexpress.objects.Pantry;
import textworldexpress.objects.Room;
import textworldexpress.objects.Street;
import textworldexpress.objects.Supermarket;
import textworldexpress.preprocessing.SortingProblem;

public class SortingGameGenerator {
    public Tuple3<ArrayBuffer<Room>, FastObject[], Box> mkEnvironment(Random r, int seed, String fold) {
        ArrayBuffer<Room> locations = new ArrayBuffer<Room>();
        int randLocationIdx = r.nextInt(11);
        Object object = randLocationIdx == 0 ? locations.append(new Kitchen(r, false, Kitchen$.MODULE$.$lessinit$greater$default$3())) : BoxedUnit.UNIT;
        Object object2 = randLocationIdx == 1 ? locations.append(new Pantry(r)) : BoxedUnit.UNIT;
        Object object3 = randLocationIdx == 2 ? locations.append(new Corridor(r)) : BoxedUnit.UNIT;
        Object object4 = randLocationIdx == 3 ? locations.append(new Bedroom(r)) : BoxedUnit.UNIT;
        Object object5 = randLocationIdx == 4 ? locations.append(new Backyard(r)) : BoxedUnit.UNIT;
        Object object6 = randLocationIdx == 5 ? locations.append(new LivingRoom(r)) : BoxedUnit.UNIT;
        Object object7 = randLocationIdx == 6 ? locations.append(new Bathroom(r)) : BoxedUnit.UNIT;
        Object object8 = randLocationIdx == 7 ? locations.append(new LaundryRoom(r)) : BoxedUnit.UNIT;
        Object object9 = randLocationIdx == 8 ? locations.append(new Driveway(r)) : BoxedUnit.UNIT;
        Object object10 = randLocationIdx == 9 ? locations.append(new Street(r)) : BoxedUnit.UNIT;
        Object object11 = randLocationIdx == 10 ? locations.append(new Supermarket(r)) : BoxedUnit.UNIT;
        Box answerBox = new Box();
        ((FastObject)locations.apply(0)).addObject(answerBox);
        Option<SortingProblem> sortingProblem = SortingProblemGenerator$.MODULE$.getProblem(seed, fold);
        FastObject[] itemsToSortInOrder = sortingProblem.get().orderedItems();
        FastObject[] objectsToPlace = (FastObject[])((IterableOnceOps)r.shuffle(Predef$.MODULE$.wrapRefArray((Object[])itemsToSortInOrder).toList(), BuildFrom$.MODULE$.buildFromIterableOps())).toArray(ClassTag$.MODULE$.apply(FastObject.class));
        Room qual$1 = (Room)locations.apply(0);
        ListBuffer<FastObject> x$1 = qual$1.collectVisibleObjects$default$1();
        ListBuffer<FastObject> visibleObjects = qual$1.collectVisibleObjects(x$1);
        ArrayBuffer validContainers = new ArrayBuffer();
        visibleObjects.foreach((Function1<FastObject, Object> & Serializable)obj -> {
            Object object;
            if (obj.isContainer() && obj.isOpen()) {
                String string = obj.name();
                String string2 = answerBox.name();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    object = validContainers.append(obj);
                    return object;
                }
            }
            object = BoxedUnit.UNIT;
            return object;
        });
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(objectsToPlace), (Function1<FastObject, Object> & Serializable)obj -> {
            SortingGameGenerator.$anonfun$mkEnvironment$2(validContainers, r, locations, obj);
            return BoxedUnit.UNIT;
        });
        return new Tuple3<ArrayBuffer<Room>, FastObject[], Box>(locations, itemsToSortInOrder, answerBox);
    }

    public SortingGame mkGame(long seed, String fold) {
        Integer n;
        Map props = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        props.update("seed", BoxesRunTime.boxToInteger((int)seed));
        String string = fold;
        String string2 = "train";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            n = BoxesRunTime.boxToInteger(1);
        } else {
            String string3 = fold;
            String string4 = "dev";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                n = BoxesRunTime.boxToInteger(2);
            } else {
                String string5 = fold;
                String string6 = "test";
                n = !(string5 != null ? !string5.equals(string6) : string6 != null) ? BoxesRunTime.boxToInteger(3) : BoxesRunTime.boxToInteger(-1);
            }
        }
        props.update("gameSet", n);
        Random r = new Random(seed);
        Tuple3<ArrayBuffer<Room>, FastObject[], Box> tuple3 = this.mkEnvironment(r, (int)seed, fold);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ArrayBuffer<Room> locations = tuple3._1();
        FastObject[] itemsToSort = tuple3._2();
        Box answerBox = tuple3._3();
        Tuple3<ArrayBuffer<Room>, FastObject[], Box> tuple32 = new Tuple3<ArrayBuffer<Room>, FastObject[], Box>(locations, itemsToSort, answerBox);
        Tuple3<ArrayBuffer<Room>, FastObject[], Box> tuple33 = tuple32;
        ArrayBuffer<Room> locations2 = tuple33._1();
        FastObject[] itemsToSort2 = tuple33._2();
        Box answerBox2 = tuple33._3();
        props.update("hidden_problemsize", BoxesRunTime.boxToInteger(itemsToSort2.length));
        Room[] x$1 = (Room[])locations2.toArray(ClassTag$.MODULE$.apply(Room.class));
        FastObject[] x$2 = itemsToSort2;
        Box x$3 = answerBox2;
        scala.collection.immutable.Map<String, Object> x$4 = props.toMap($less$colon$less$.MODULE$.refl());
        long x$5 = SortingGame$.MODULE$.$lessinit$greater$default$4();
        SortingGame game = new SortingGame(x$1, x$2, x$3, x$5, x$4);
        return game;
    }

    public Tuple2<SortingGame, String[]> mkGameWithGoldPath(long seed, String fold) {
        int MAX_ATTEMPTS = 50;
        Random rg = new Random();
        IntRef attempts = IntRef.create(0);
        ObjectRef<String[]> goldPath = ObjectRef.create((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        Breaks$.MODULE$.breakable(() -> {
            while (attempts$1.elem < MAX_ATTEMPTS) {
                SortingGame game = this.mkGame(seed, fold);
                SortingGoldAgent goldAgent = new SortingGoldAgent(game);
                Tuple2<Object, String[]> tuple2 = goldAgent.mkGoldPath(rg);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                boolean success = tuple2._1$mcZ$sp();
                String[] _goldPath = tuple2._2();
                Tuple2<Boolean, String[]> tuple22 = new Tuple2<Boolean, String[]>(BoxesRunTime.boxToBoolean(success), _goldPath);
                Tuple2<Boolean, String[]> tuple23 = tuple22;
                boolean success2 = tuple23._1$mcZ$sp();
                String[] _goldPath2 = tuple23._2();
                if (success2) {
                    goldPath$1.elem = _goldPath2;
                }
                if (success2) {
                    throw Breaks$.MODULE$.break();
                }
                ++attempts$1.elem;
            }
            Predef$.MODULE$.println(new StringBuilder(91).append("ERROR: Unknown error: Gold path could not be generated after maximum number of attempts (").append(MAX_ATTEMPTS).append(").").toString());
        });
        SortingGame game = this.mkGame(seed, fold);
        return new Tuple2<SortingGame, String[]>(game, (String[])goldPath.elem);
    }

    public static final /* synthetic */ void $anonfun$mkEnvironment$2(ArrayBuffer validContainers$1, Random r$1, ArrayBuffer locations$1, FastObject obj) {
        if (validContainers$1.length() > 0) {
            FastObject randContainer = (FastObject)validContainers$1.apply(r$1.nextInt(validContainers$1.length()));
            randContainer.addObject(obj);
        } else {
            ((FastObject)locations$1.apply(0)).addObject(obj);
        }
    }
}

