/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.games;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.BuildFrom$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Random;
import textworldexpress.games.SimonSaysGameScoring;
import textworldexpress.objects.FastObject;
import textworldexpress.struct.ActionHistory;
import textworldexpress.struct.GameScore;
import textworldexpress.struct.Scorer;
import textworldexpress.struct.StepResult;
import textworldexpress.struct.TextGame;

public class SimonSaysMemoryGame
extends TextGame {
    private final String[] goldActionSequence;
    private final String[] possibleActions;
    private final long seed;
    private final Map<String, Object> generationProperties;
    private ListBuffer<Tuple3<String, Object, FastObject[]>> lastValidActions;
    private ArrayBuffer<ActionHistory> history;
    private final Scorer scorer;
    private final Random random;
    private int currentStep;
    private final int ACTION_SIMONSAYS;
    private final int ACTION_INVALID;

    public String[] goldActionSequence() {
        return this.goldActionSequence;
    }

    public String[] possibleActions() {
        return this.possibleActions;
    }

    public Map<String, Object> generationProperties() {
        return this.generationProperties;
    }

    public ListBuffer<Tuple3<String, Object, FastObject[]>> lastValidActions() {
        return this.lastValidActions;
    }

    public void lastValidActions_$eq(ListBuffer<Tuple3<String, Object, FastObject[]>> x$1) {
        this.lastValidActions = x$1;
    }

    public ArrayBuffer<ActionHistory> history() {
        return this.history;
    }

    public Scorer scorer() {
        return this.scorer;
    }

    public Random random() {
        return this.random;
    }

    public int currentStep() {
        return this.currentStep;
    }

    public void currentStep_$eq(int x$1) {
        this.currentStep = x$1;
    }

    @Override
    public Map<String, Object> getGenerationProperties() {
        return this.generationProperties();
    }

    @Override
    public String getTaskDescription() {
        return "Your task is to do exactly what Simon says.";
    }

    public GameScore getScore() {
        return this.scorer().getCurrentScore();
    }

    public String actionSimonSays(FastObject[] params) {
        return this.actionSimonSays();
    }

    public String actionSimonSays() {
        return "";
    }

    public int ACTION_SIMONSAYS() {
        return this.ACTION_SIMONSAYS;
    }

    public int ACTION_INVALID() {
        return this.ACTION_INVALID;
    }

    public String runAction(int actionIdx, FastObject[] params) {
        int n = actionIdx;
        if (this.ACTION_SIMONSAYS() == n) {
            return this.actionSimonSays(params);
        }
        return "That is not a command that I recognize.";
    }

    public ListBuffer<Tuple3<String, Object, FastObject[]>> mkActions(ListBuffer<FastObject> visibleObjects) {
        ListBuffer<Tuple3<String, Object, FastObject[]>> actionsOut = new ListBuffer<Tuple3<String, Object, FastObject[]>>();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.possibleActions().length).foreach((Function1<Object, ListBuffer> & Serializable)i -> SimonSaysMemoryGame.$anonfun$mkActions$1(this, actionsOut, BoxesRunTime.unboxToInt(i)));
        return actionsOut;
    }

    public String mkObservation(String curAction, int curStage) {
        if (curStage == 0) {
            return new StringBuilder(42).append("Simon says, take these actions in order: ").append(Predef$.MODULE$.wrapRefArray((Object[])this.goldActionSequence()).mkString(", ")).append(".").toString();
        }
        if (curStage >= this.goldActionSequence().length) {
            return "Simon says, you have completed the game.  You win!";
        }
        String string = curAction;
        String string2 = this.goldActionSequence()[curStage - 1];
        if (string == null ? string2 != null : !string.equals(string2)) {
            return "Incorrect!";
        }
        if (BoxesRunTime.unboxToInt(this.generationProperties().apply("verbose")) == 1) {
            return "Correct!";
        }
        return "";
    }

    @Override
    public StepResult initalStep() {
        return this.step("", -1, (FastObject[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FastObject.class)));
    }

    @Override
    public StepResult step(String actionStr) {
        Object object = new Object();
        try {
            this.lastValidActions().foreach((Function1<Tuple3, Object> & Serializable)action -> {
                SimonSaysMemoryGame.$anonfun$step$1(this, actionStr, object, action);
                return BoxedUnit.UNIT;
            });
            return this.step(actionStr, this.ACTION_INVALID(), (FastObject[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FastObject.class)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (StepResult)ex.value();
        }
    }

    public StepResult step(String actionStr, int actionNumber, FastObject[] actionParams) {
        if (actionNumber >= 0) {
            String string = this.runAction(actionNumber, actionParams);
        }
        boolean wasValidAction = actionNumber != this.ACTION_INVALID();
        ListBuffer<Tuple3<String, Object, FastObject[]>> validActions = this.mkActions((ListBuffer<FastObject>)ListBuffer$.MODULE$.empty());
        this.lastValidActions_$eq(validActions);
        ObjectRef validActionStrs = ObjectRef.create(new ArrayBuffer(validActions.length()));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), validActions.length()).foreach((Function1<Object, ArrayBuffer> & Serializable)i -> SimonSaysMemoryGame.$anonfun$step$2(validActionStrs, validActions, BoxesRunTime.unboxToInt(i)));
        validActionStrs.elem = (ArrayBuffer)this.random().shuffle((ArrayBuffer)validActionStrs.elem, BuildFrom$.MODULE$.buildFromIterableOps());
        String freeLookStr = "";
        String inventoryStr = "";
        String observationStr = this.mkObservation(actionStr, this.currentStep());
        this.history().append(new ActionHistory(actionStr, observationStr, this.getScore()));
        this.scorer().doScoring();
        GameScore curScores = this.getScore();
        this.history().remove(this.history().size() - 1);
        this.history().append(new ActionHistory(actionStr, observationStr, curScores));
        this.currentStep_$eq(this.currentStep() + 1);
        StepResult result = new StepResult(observationStr, freeLookStr, inventoryStr, (String[])((ArrayBuffer)validActionStrs.elem).toArray(ClassTag$.MODULE$.apply(String.class)), curScores.scoreRaw(), curScores.scoreNormalized(), curScores.taskSuccess(), curScores.taskFailure(), wasValidAction);
        return result;
    }

    public static final /* synthetic */ ListBuffer $anonfun$mkActions$1(SimonSaysMemoryGame $this, ListBuffer actionsOut$1, int i) {
        String possibleActionStr = $this.possibleActions()[i];
        return (ListBuffer)actionsOut$1.append(new Tuple3<String, Integer, Object>(possibleActionStr, BoxesRunTime.boxToInteger($this.ACTION_SIMONSAYS()), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FastObject.class))));
    }

    public static final /* synthetic */ void $anonfun$step$1(SimonSaysMemoryGame $this, String actionStr$1, Object nonLocalReturnKey1$1, Tuple3 action) {
        Object T1 = action._1();
        String string = actionStr$1;
        if (!(T1 != null ? !T1.equals(string) : string != null)) {
            throw new NonLocalReturnControl<StepResult>(nonLocalReturnKey1$1, $this.step(actionStr$1, BoxesRunTime.unboxToInt(action._2()), (FastObject[])action._3()));
        }
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$step$2(ObjectRef validActionStrs$1, ListBuffer validActions$1, int i) {
        return (ArrayBuffer)((ArrayBuffer)validActionStrs$1.elem).append(((Tuple3)validActions$1.apply(i))._1());
    }

    public SimonSaysMemoryGame(String[] goldActionSequence, String[] possibleActions, long seed, Map<String, Object> generationProperties) {
        this.goldActionSequence = goldActionSequence;
        this.possibleActions = possibleActions;
        this.seed = seed;
        this.generationProperties = generationProperties;
        this.lastValidActions = ListBuffer$.MODULE$.empty();
        this.history = new ArrayBuffer();
        this.scorer = new SimonSaysGameScoring(goldActionSequence, this.history());
        this.random = new Random(seed);
        this.currentStep = 0;
        this.ACTION_SIMONSAYS = 18;
        this.ACTION_INVALID = 0;
    }
}

