/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.games;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Random;
import scala.util.control.Breaks$;
import textworldexpress.games.PeckingOrderGame;
import textworldexpress.goldagent.PeckingOrderGoldAgent;
import textworldexpress.objects.Backyard;
import textworldexpress.objects.Bathroom;
import textworldexpress.objects.Bedroom;
import textworldexpress.objects.Corridor;
import textworldexpress.objects.DoorMaker;
import textworldexpress.objects.Driveway;
import textworldexpress.objects.FastObject;
import textworldexpress.objects.Instructions;
import textworldexpress.objects.Kitchen;
import textworldexpress.objects.Kitchen$;
import textworldexpress.objects.LaundryRoom;
import textworldexpress.objects.LivingRoom;
import textworldexpress.objects.Pantry;
import textworldexpress.objects.Room;
import textworldexpress.objects.Street;
import textworldexpress.objects.Supermarket;

public class PeckingOrderGameGenerator {
    private final DoorMaker doorMaker = new DoorMaker();

    public Tuple3<ArrayBuffer<Room>, FastObject[], Instructions> mkEnvironment(Random r, int seed, String fold) {
        ArrayBuffer<Room> locations = new ArrayBuffer<Room>();
        int randLocationIdx = r.nextInt(11);
        Object object = randLocationIdx == 0 ? locations.append(new Kitchen(r, false, Kitchen$.MODULE$.$lessinit$greater$default$3())) : BoxedUnit.UNIT;
        Object object2 = randLocationIdx == 1 ? locations.append(new Pantry(r)) : BoxedUnit.UNIT;
        Object object3 = randLocationIdx == 2 ? locations.append(new Corridor(r)) : BoxedUnit.UNIT;
        Object object4 = randLocationIdx == 3 ? locations.append(new Bedroom(r)) : BoxedUnit.UNIT;
        Object object5 = randLocationIdx == 4 ? locations.append(new Backyard(r)) : BoxedUnit.UNIT;
        Object object6 = randLocationIdx == 5 ? locations.append(new LivingRoom(r)) : BoxedUnit.UNIT;
        Object object7 = randLocationIdx == 6 ? locations.append(new Bathroom(r)) : BoxedUnit.UNIT;
        Object object8 = randLocationIdx == 7 ? locations.append(new LaundryRoom(r)) : BoxedUnit.UNIT;
        Object object9 = randLocationIdx == 8 ? locations.append(new Driveway(r)) : BoxedUnit.UNIT;
        Object object10 = randLocationIdx == 9 ? locations.append(new Street(r)) : BoxedUnit.UNIT;
        Object object11 = randLocationIdx == 10 ? locations.append(new Supermarket(r)) : BoxedUnit.UNIT;
        Instructions instructionBook = new Instructions();
        instructionBook.isMovable_$eq(false);
        ((FastObject)locations.apply(0)).addObject(instructionBook);
        FastObject[] taskObjects = this.mkTaskObjects(r, fold);
        FastObject[] objectsToPlace = (FastObject[])((IterableOnceOps)r.shuffle(Predef$.MODULE$.wrapRefArray((Object[])taskObjects).toList(), BuildFrom$.MODULE$.buildFromIterableOps())).toArray(ClassTag$.MODULE$.apply(FastObject.class));
        Room qual$1 = (Room)locations.apply(0);
        ListBuffer<FastObject> x$1 = qual$1.collectVisibleObjects$default$1();
        ListBuffer<FastObject> visibleObjects = qual$1.collectVisibleObjects(x$1);
        ArrayBuffer validContainers = new ArrayBuffer();
        visibleObjects.foreach((Function1<FastObject, Object> & Serializable)obj -> obj.isContainer() && obj.isOpen() ? validContainers.append(obj) : BoxedUnit.UNIT);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(objectsToPlace), (Function1<FastObject, Object> & Serializable)obj -> {
            PeckingOrderGameGenerator.$anonfun$mkEnvironment$2(validContainers, r, locations, obj);
            return BoxedUnit.UNIT;
        });
        return new Tuple3<ArrayBuffer<Room>, FastObject[], Instructions>(locations, taskObjects, instructionBook);
    }

    public FastObject[] mkTaskObjects(Random r, String gameFold) {
        Tuple2[] tuple2Array;
        Tuple2[] objectNamesTrain = (Tuple2[])((Object[])new Tuple2[]{new Tuple2<String, String>("apple", "apples"), new Tuple2<String, String>("orange", "oranges"), new Tuple2<String, String>("grape", "grapes"), new Tuple2<String, String>("tangerine", "tangerines"), new Tuple2<String, String>("banana", "bananas"), new Tuple2<String, String>("pineapple", "pineapples"), new Tuple2<String, String>("papaya", "papayas"), new Tuple2<String, String>("peach", "peaches"), new Tuple2<String, String>("strawberry", "strawberries"), new Tuple2<String, String>("grapefruit", "grapefruits")});
        Tuple2[] objectNamesDev = (Tuple2[])((Object[])new Tuple2[]{new Tuple2<String, String>("broccoli", "brocollis"), new Tuple2<String, String>("onion", "onions"), new Tuple2<String, String>("cucumber", "cucumbers"), new Tuple2<String, String>("potato", "potatoes"), new Tuple2<String, String>("cucumber", "cucumbers"), new Tuple2<String, String>("coconut", "coconuts"), new Tuple2<String, String>("watermelon", "watermelons"), new Tuple2<String, String>("mango", "mangos"), new Tuple2<String, String>("olive", "olives"), new Tuple2<String, String>("lime", "limes"), new Tuple2<String, String>("pear", "pears")});
        Tuple2[] objectNamesTest = (Tuple2[])((Object[])new Tuple2[]{new Tuple2<String, String>("pepper", "peppers"), new Tuple2<String, String>("tomato", "tomatoes"), new Tuple2<String, String>("eggplant", "eggplants"), new Tuple2<String, String>("squash", "squashes"), new Tuple2<String, String>("pumpkin", "pumpkins"), new Tuple2<String, String>("pea", "peas"), new Tuple2<String, String>("avocado", "avocados"), new Tuple2<String, String>("cabbage", "cabbages"), new Tuple2<String, String>("prune", "prunes"), new Tuple2<String, String>("blueberry", "blueberries")});
        int numObjects = 4;
        String string = gameFold;
        String string2 = "train";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            tuple2Array = objectNamesTrain;
        } else {
            String string3 = gameFold;
            String string4 = "dev";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                tuple2Array = objectNamesDev;
            } else {
                String string5 = gameFold;
                String string6 = "test";
                tuple2Array = !(string5 != null ? !string5.equals(string6) : string6 != null) ? objectNamesTest : (Tuple2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class));
            }
        }
        Tuple2[] objectNames = tuple2Array;
        Tuple2[] shuffled = (Tuple2[])((IterableOnceOps)r.shuffle((IterableOnce)r.shuffle(Predef$.MODULE$.wrapRefArray((Object[])objectNames).toList(), BuildFrom$.MODULE$.buildFromIterableOps()), BuildFrom$.MODULE$.buildFromIterableOps())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        ArrayBuffer objectsOut = new ArrayBuffer();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numObjects).foreach((Function1<Object, ArrayBuffer> & Serializable)i -> PeckingOrderGameGenerator.$anonfun$mkTaskObjects$1(shuffled, objectsOut, BoxesRunTime.unboxToInt(i)));
        return (FastObject[])objectsOut.toArray(ClassTag$.MODULE$.apply(FastObject.class));
    }

    public PeckingOrderGame mkGame(long seed, String fold) {
        Integer n;
        Map props = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        props.update("seed", BoxesRunTime.boxToInteger((int)seed));
        String string = fold;
        String string2 = "train";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            n = BoxesRunTime.boxToInteger(1);
        } else {
            String string3 = fold;
            String string4 = "dev";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                n = BoxesRunTime.boxToInteger(2);
            } else {
                String string5 = fold;
                String string6 = "test";
                n = !(string5 != null ? !string5.equals(string6) : string6 != null) ? BoxesRunTime.boxToInteger(3) : BoxesRunTime.boxToInteger(-1);
            }
        }
        props.update("gameSet", n);
        Random r = new Random(seed);
        Tuple3<ArrayBuffer<Room>, FastObject[], Instructions> tuple3 = this.mkEnvironment(r, (int)seed, fold);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ArrayBuffer<Room> locations = tuple3._1();
        FastObject[] taskObjects = tuple3._2();
        Instructions instructionBook = tuple3._3();
        Tuple3<ArrayBuffer<Room>, FastObject[], Instructions> tuple32 = new Tuple3<ArrayBuffer<Room>, FastObject[], Instructions>(locations, taskObjects, instructionBook);
        Tuple3<ArrayBuffer<Room>, FastObject[], Instructions> tuple33 = tuple32;
        ArrayBuffer<Room> locations2 = tuple33._1();
        FastObject[] taskObjects2 = tuple33._2();
        Instructions instructionBook2 = tuple33._3();
        PeckingOrderGame game = new PeckingOrderGame((Room[])locations2.toArray(ClassTag$.MODULE$.apply(Room.class)), taskObjects2, instructionBook2, seed, props.toMap($less$colon$less$.MODULE$.refl()));
        return game;
    }

    public Tuple2<PeckingOrderGame, String[]> mkGameWithGoldPath(long seed, String fold) {
        int MAX_ATTEMPTS = 50;
        Random rg = new Random();
        IntRef attempts = IntRef.create(0);
        ObjectRef<String[]> goldPath = ObjectRef.create((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        Breaks$.MODULE$.breakable(() -> {
            while (attempts$1.elem < MAX_ATTEMPTS) {
                PeckingOrderGame game = this.mkGame(seed, fold);
                PeckingOrderGoldAgent goldAgent = new PeckingOrderGoldAgent(game);
                Tuple2<Object, String[]> tuple2 = goldAgent.mkGoldPath(rg);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                boolean success = tuple2._1$mcZ$sp();
                String[] _goldPath = tuple2._2();
                Tuple2<Boolean, String[]> tuple22 = new Tuple2<Boolean, String[]>(BoxesRunTime.boxToBoolean(success), _goldPath);
                Tuple2<Boolean, String[]> tuple23 = tuple22;
                boolean success2 = tuple23._1$mcZ$sp();
                String[] _goldPath2 = tuple23._2();
                if (success2) {
                    goldPath$1.elem = _goldPath2;
                }
                if (success2) {
                    throw Breaks$.MODULE$.break();
                }
                ++attempts$1.elem;
            }
            Predef$.MODULE$.println(new StringBuilder(91).append("ERROR: Unknown error: Gold path could not be generated after maximum number of attempts (").append(MAX_ATTEMPTS).append(").").toString());
        });
        PeckingOrderGame game = this.mkGame(seed, fold);
        return new Tuple2<PeckingOrderGame, String[]>(game, (String[])goldPath.elem);
    }

    public static final /* synthetic */ void $anonfun$mkEnvironment$2(ArrayBuffer validContainers$1, Random r$1, ArrayBuffer locations$1, FastObject obj) {
        if (validContainers$1.length() > 0) {
            FastObject randContainer = (FastObject)validContainers$1.apply(r$1.nextInt(validContainers$1.length()));
            randContainer.addObject(obj);
        } else {
            ((FastObject)locations$1.apply(0)).addObject(obj);
        }
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$mkTaskObjects$1(Tuple2[] shuffled$1, ArrayBuffer objectsOut$1, int i) {
        String objName = (String)shuffled$1[i]._1();
        FastObject obj = new FastObject(objName);
        obj.isMovable_$eq(true);
        return (ArrayBuffer)objectsOut$1.append(obj);
    }
}

