/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.games;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcZ$sp;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Random;
import textworldexpress.data.RecipeIngredient;
import textworldexpress.games.CookingWorldGameScoring;
import textworldexpress.objects.FastObject;
import textworldexpress.objects.Meal;
import textworldexpress.objects.Room;
import textworldexpress.struct.ActionHistory;
import textworldexpress.struct.GameScore;
import textworldexpress.struct.StepResult;
import textworldexpress.struct.TextGame;

public class CookingWorldGame
extends TextGame {
    private final Room[] locations;
    private final ArrayBuffer<RecipeIngredient> recipe;
    private final ArrayBuffer<FastObject> taskObjects;
    private final boolean limitInventorySize;
    private final long seed;
    private final Map<String, Object> generationProperties;
    private FastObject agentInventory;
    private Room agentLocation;
    private final ArrayBuffer<FastObject> deletedObjects;
    private final CookingWorldGameScoring scorer;
    private Option<FastObject> meal;
    private ListBuffer<Tuple3<String, Object, FastObject[]>> lastValidActions;
    private ArrayBuffer<ActionHistory> history;
    private final int inventoryMaxCapacity;
    private final Random random;
    private final int ACTION_TAKE;
    private final int ACTION_PUTIN;
    private final int ACTION_OPEN;
    private final int ACTION_CLOSE;
    private final int ACTION_EAT;
    private final int ACTION_COOK;
    private final int ACTION_CHOP;
    private final int ACTION_SLICE;
    private final int ACTION_DICE;
    private final int ACTION_LOOKAROUND;
    private final int ACTION_MOVE;
    private final int ACTION_READ;
    private final int ACTION_PREPAREMEAL;
    private final int ACTION_INVENTORY;
    private final int ACTION_EXAMINE;
    private final int ACTION_OPENDOOR;
    private final int ACTION_CLOSEDOOR;
    private final int ACTION_INVALID;

    public Room[] locations() {
        return this.locations;
    }

    public ArrayBuffer<RecipeIngredient> recipe() {
        return this.recipe;
    }

    public ArrayBuffer<FastObject> taskObjects() {
        return this.taskObjects;
    }

    public Map<String, Object> generationProperties() {
        return this.generationProperties;
    }

    public FastObject agentInventory() {
        return this.agentInventory;
    }

    public Room agentLocation() {
        return this.agentLocation;
    }

    public void agentLocation_$eq(Room x$1) {
        this.agentLocation = x$1;
    }

    public ArrayBuffer<FastObject> deletedObjects() {
        return this.deletedObjects;
    }

    public CookingWorldGameScoring scorer() {
        return this.scorer;
    }

    public Option<FastObject> meal() {
        return this.meal;
    }

    public void meal_$eq(Option<FastObject> x$1) {
        this.meal = x$1;
    }

    public ListBuffer<Tuple3<String, Object, FastObject[]>> lastValidActions() {
        return this.lastValidActions;
    }

    public void lastValidActions_$eq(ListBuffer<Tuple3<String, Object, FastObject[]>> x$1) {
        this.lastValidActions = x$1;
    }

    public ArrayBuffer<ActionHistory> history() {
        return this.history;
    }

    public int inventoryMaxCapacity() {
        return this.inventoryMaxCapacity;
    }

    public Random random() {
        return this.random;
    }

    @Override
    public Map<String, Object> getGenerationProperties() {
        return this.generationProperties();
    }

    @Override
    public String getTaskDescription() {
        return "You are hungry! Let's cook a delicious meal. Check the cookbook in the kitchen for the recipe. Once done, enjoy your meal!";
    }

    public ListBuffer<FastObject> getVisibleObjects() {
        Room qual$1 = this.agentLocation();
        ListBuffer<FastObject> x$1 = qual$1.collectVisibleObjects$default$1();
        return qual$1.collectVisibleObjects(x$1);
    }

    public String getCurrentRoomDescription() {
        return this.agentLocation().getDescription();
    }

    public boolean agentHasKnife() {
        Object object = new Object();
        try {
            this.agentInventory().contents().foreach((Function1<FastObject, Object> & Serializable)obj -> {
                CookingWorldGame.$anonfun$agentHasKnife$1(object, obj);
                return BoxedUnit.UNIT;
            });
            return false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return ex.value$mcZ$sp();
        }
    }

    public GameScore getScore() {
        return this.scorer().getCurrentScore();
    }

    @Override
    public String getObjectTree() {
        scala.collection.mutable.StringBuilder os = new scala.collection.mutable.StringBuilder();
        os.append("{");
        os.append(new StringBuilder(21).append("\"player_location\":\"").append(this.agentLocation().name()).append("\",").toString());
        ArrayBuffer inventoryJSON = new ArrayBuffer();
        this.agentInventory().contents().foreach((Function1<FastObject, ArrayBuffer> & Serializable)obj -> (ArrayBuffer)inventoryJSON.append(new StringBuilder(4).append("\"").append(obj.name()).append("\": ").append(obj.toJSON()).toString()));
        os.append(new StringBuilder(13).append("\"inventory\": ").append(inventoryJSON.mkString("{", ",", "},")).toString());
        ArrayBuffer locations_json = new ArrayBuffer();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(this.locations()), (Function1<Room, ArrayBuffer> & Serializable)loc -> (ArrayBuffer)locations_json.append(new StringBuilder(4).append("\"").append(loc.name()).append("\": ").append(loc.toJSON()).toString()));
        os.append(new StringBuilder(13).append("\"locations\": ").append(locations_json.mkString("{", ",", "},")).toString());
        ArrayBuffer recipeJSON = new ArrayBuffer();
        this.recipe().foreach((Function1<RecipeIngredient, ArrayBuffer> & Serializable)ingredient -> (ArrayBuffer)recipeJSON.append(new StringBuilder(31).append("{\"name\": \"").append(ingredient.name()).append("\", \"preparation\": \"").append(ingredient.preparation().mkString(", ")).append("\"}").toString()));
        os.append(new StringBuilder(10).append("\"recipe\": ").append(recipeJSON.mkString("[", ",", "],")).toString());
        ArrayBuffer deletedObjectsJSON = new ArrayBuffer();
        this.deletedObjects().foreach((Function1<FastObject, ArrayBuffer> & Serializable)obj -> (ArrayBuffer)deletedObjectsJSON.append(new StringBuilder(4).append("\"").append(obj.name()).append("\": ").append(obj.toJSON()).toString()));
        os.append(new StringBuilder(19).append("\"deleted_objects\": ").append(deletedObjectsJSON.mkString("{", ",", "}")).toString());
        os.append("}");
        return os.toString();
    }

    public String actionTake(FastObject[] params) {
        return this.actionTake(params[0]);
    }

    public String actionTake(FastObject obj) {
        int numItemsInInventory = this.agentInventory().contents().size();
        if (this.limitInventorySize && numItemsInInventory >= this.inventoryMaxCapacity()) {
            return new StringBuilder(83).append("Your inventory currently has ").append(numItemsInInventory).append(" items, and is full.  You can't pick up another item. ").toString();
        }
        obj.removeFromCurrentContainer();
        this.agentInventory().addObject(obj);
        return new StringBuilder(14).append("You take the ").append(obj.name()).append(".").toString();
    }

    public String actionPutIn(FastObject[] params) {
        return this.actionPutIn(params[0], params[1]);
    }

    public String actionPutIn(FastObject invObject, FastObject newContainer) {
        invObject.removeFromCurrentContainer();
        newContainer.addObject(invObject);
        return new StringBuilder(21).append("You put the ").append(invObject.name()).append(" in the ").append(newContainer.name()).append(".").toString();
    }

    public String actionOpenContainer(FastObject[] params) {
        return this.actionOpenContainer(params[0]);
    }

    public String actionOpenContainer(FastObject obj) {
        obj.isOpen_$eq(true);
        if (obj.contents().isEmpty()) {
            return new StringBuilder(33).append("You open the ").append(obj.name()).append(". It's empty inside.").toString();
        }
        scala.collection.mutable.StringBuilder os = new scala.collection.mutable.StringBuilder();
        os.append(new StringBuilder(15).append("You open the ").append(obj.name()).append(". ").toString());
        os.append(new StringBuilder(14).append("The ").append(obj.name()).append(" contains ").toString());
        os.append(new StringBuilder(1).append(((IterableOnceOps)obj.contents().map((Function1<FastObject, String> & Serializable)x$1 -> x$1.getDescription())).mkString(", ")).append(".").toString());
        return os.toString();
    }

    public String actionCloseContainer(FastObject[] params) {
        return this.actionCloseContainer(params[0]);
    }

    public String actionCloseContainer(FastObject obj) {
        obj.isOpen_$eq(false);
        return new StringBuilder(15).append("You close the ").append(obj.name()).append(".").toString();
    }

    public String actionEat(FastObject[] params) {
        return this.actionEat(params[0]);
    }

    public String actionEat(FastObject obj) {
        obj.removeFromCurrentContainer();
        obj.isDeleted_$eq(true);
        obj.isEaten_$eq(true);
        this.deletedObjects().append(obj);
        return new StringBuilder(31).append("You eat the ").append(obj.name()).append(".  It is delicious.").toString();
    }

    public String actionCook(FastObject[] params) {
        return this.actionCook(params[0], params[1]);
    }

    public String actionCook(FastObject obj, FastObject device) {
        block6: {
            block5: {
                obj.isRaw_$eq(false);
                String string = device.name();
                String string2 = "stove";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    obj.isFried_$eq(true);
                    return new StringBuilder(23).append("You fry the ").append(obj.name()).append(" with the ").append(device.name()).append(".").toString();
                }
                String string3 = device.name();
                String string4 = "oven";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    obj.isRoasted_$eq(true);
                    return new StringBuilder(25).append("You roast the ").append(obj.name()).append(" with the ").append(device.name()).append(".").toString();
                }
                String string5 = device.name();
                String string6 = "barbeque";
                if (!(string5 == null ? string6 != null : !string5.equals(string6))) break block5;
                String string7 = device.name();
                String string8 = "toaster";
                if (string7 != null ? !string7.equals(string8) : string8 != null) break block6;
            }
            obj.isGrilled_$eq(true);
            return new StringBuilder(25).append("You grill the ").append(obj.name()).append(" with the ").append(device.name()).append(".").toString();
        }
        return new StringBuilder(24).append("You cook the ").append(obj.name()).append(" with the ").append(device.name()).append(".").toString();
    }

    public String actionChop(FastObject[] params) {
        return this.actionChop(params[0]);
    }

    public String actionChop(FastObject obj) {
        obj.isChopped_$eq(true);
        obj.isCut_$eq(true);
        return new StringBuilder(14).append("You chop the ").append(obj.name()).append(".").toString();
    }

    public String actionSlice(FastObject[] params) {
        return this.actionSlice(params[0]);
    }

    public String actionSlice(FastObject obj) {
        obj.isSliced_$eq(true);
        obj.isCut_$eq(true);
        return new StringBuilder(15).append("You slice the ").append(obj.name()).append(".").toString();
    }

    public String actionDice(FastObject[] params) {
        return this.actionDice(params[0]);
    }

    public String actionDice(FastObject obj) {
        obj.isDiced_$eq(true);
        obj.isCut_$eq(true);
        return new StringBuilder(14).append("You dice the ").append(obj.name()).append(".").toString();
    }

    public String actionLookAround(FastObject[] params) {
        return this.actionLookAround();
    }

    public String actionLookAround() {
        return this.getCurrentRoomDescription();
    }

    public String actionExamine(FastObject[] params) {
        return this.actionExamine(params[0]);
    }

    public String actionExamine(FastObject obj) {
        if (obj.isReadable()) {
            return this.actionRead(obj);
        }
        return obj.getDescription();
    }

    public String actionMove(FastObject[] params) {
        return this.actionMove(params[0], params[1]);
    }

    public String actionMove(FastObject door, FastObject newLoc) {
        FastObject fastObject = newLoc;
        if (fastObject instanceof Room) {
            Room room = (Room)fastObject;
            if (door != null && !door.isOpen()) {
                return "You can't move there, the door is closed. ";
            }
            this.agentLocation_$eq(room);
            return this.agentLocation().getDescription();
        }
        throw new RuntimeException(new StringBuilder(61).append("ERROR: Attempting to move to a location that is not a room (").append(newLoc.name()).append(")").toString());
    }

    public String actionRead(FastObject[] params) {
        return this.actionRead(params[0]);
    }

    public String actionRead(FastObject obj) {
        obj.hasBeenRead_$eq(true);
        return obj.readText();
    }

    public String actionInventory(FastObject[] params) {
        return this.actionInventory();
    }

    public String actionInventory() {
        Serializable serializable;
        scala.collection.mutable.StringBuilder os = new scala.collection.mutable.StringBuilder();
        scala.collection.mutable.StringBuilder stringBuilder = this.limitInventorySize ? os.append(new StringBuilder(41).append("Inventory (maximum capacity is ").append(this.inventoryMaxCapacity()).append(" items): \n").toString()) : os.append("Inventory: \n");
        if (this.agentInventory().contents().isEmpty()) {
            serializable = os.append("  Your inventory is currently empty.\n");
        } else {
            this.agentInventory().contents().foreach((Function1<FastObject, scala.collection.mutable.StringBuilder> & Serializable)obj -> os.append(new StringBuilder(3).append("  ").append(obj.getDescription()).append("\n").toString()));
            serializable = BoxedUnit.UNIT;
        }
        return os.toString();
    }

    public String actionOpenDoor(FastObject[] params) {
        return this.actionOpenDoor(params[0], params[1]);
    }

    public String actionOpenDoor(FastObject door, FastObject locationBeyond) {
        if (!door.isOpen()) {
            door.isOpen_$eq(true);
            return new StringBuilder(31).append("You open the ").append(door.getDescription()).append(", revealing the ").append(locationBeyond.name()).append(". ").toString();
        }
        return "That is already open. ";
    }

    public String actionCloseDoor(FastObject[] params) {
        return this.actionCloseDoor(params[0], params[1]);
    }

    public String actionCloseDoor(FastObject door, FastObject locationBeyond) {
        if (door.isOpen()) {
            door.isOpen_$eq(false);
            return new StringBuilder(24).append("You close the ").append(door.getDescription()).append(" to the ").append(locationBeyond.name()).append(". ").toString();
        }
        return "That is already closed. ";
    }

    public String canPrepareMeal() {
        String string = this.agentLocation().name();
        String string2 = "kitchen";
        if (string == null ? string2 != null : !string.equals(string2)) {
            return "Can only prepare meal in the -= kitchen =-.";
        }
        BooleanRef conditionsMet = BooleanRef.create(true);
        this.taskObjects().foreach((Function1<FastObject, Object> & Serializable)ingredient -> {
            CookingWorldGame.$anonfun$canPrepareMeal$1(this, conditionsMet, ingredient);
            return BoxedUnit.UNIT;
        });
        if (!conditionsMet.elem) {
            return "You are unable to prepare the meal right now.";
        }
        return "";
    }

    public String actionPrepareMeal(FastObject[] params) {
        return this.actionPrepareMeal();
    }

    public String actionPrepareMeal() {
        String errMsg;
        String string = errMsg = this.canPrepareMeal();
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            return errMsg;
        }
        this.taskObjects().foreach((Function1<FastObject, Object> & Serializable)ingredient -> {
            CookingWorldGame.$anonfun$actionPrepareMeal$1(ingredient);
            return BoxedUnit.UNIT;
        });
        Meal preparedMeal = new Meal();
        this.meal_$eq(new Some<FastObject>(preparedMeal));
        this.agentInventory().addObject(preparedMeal);
        return "Adding the meal to your inventory.";
    }

    public int ACTION_TAKE() {
        return this.ACTION_TAKE;
    }

    public int ACTION_PUTIN() {
        return this.ACTION_PUTIN;
    }

    public int ACTION_OPEN() {
        return this.ACTION_OPEN;
    }

    public int ACTION_CLOSE() {
        return this.ACTION_CLOSE;
    }

    public int ACTION_EAT() {
        return this.ACTION_EAT;
    }

    public int ACTION_COOK() {
        return this.ACTION_COOK;
    }

    public int ACTION_CHOP() {
        return this.ACTION_CHOP;
    }

    public int ACTION_SLICE() {
        return this.ACTION_SLICE;
    }

    public int ACTION_DICE() {
        return this.ACTION_DICE;
    }

    public int ACTION_LOOKAROUND() {
        return this.ACTION_LOOKAROUND;
    }

    public int ACTION_MOVE() {
        return this.ACTION_MOVE;
    }

    public int ACTION_READ() {
        return this.ACTION_READ;
    }

    public int ACTION_PREPAREMEAL() {
        return this.ACTION_PREPAREMEAL;
    }

    public int ACTION_INVENTORY() {
        return this.ACTION_INVENTORY;
    }

    public int ACTION_EXAMINE() {
        return this.ACTION_EXAMINE;
    }

    public int ACTION_OPENDOOR() {
        return this.ACTION_OPENDOOR;
    }

    public int ACTION_CLOSEDOOR() {
        return this.ACTION_CLOSEDOOR;
    }

    public int ACTION_INVALID() {
        return this.ACTION_INVALID;
    }

    public String runAction(int actionIdx, FastObject[] params) {
        int n = actionIdx;
        if (this.ACTION_TAKE() == n) {
            return this.actionTake(params);
        }
        if (this.ACTION_PUTIN() == n) {
            return this.actionPutIn(params);
        }
        if (this.ACTION_OPEN() == n) {
            return this.actionOpenContainer(params);
        }
        if (this.ACTION_CLOSE() == n) {
            return this.actionCloseContainer(params);
        }
        if (this.ACTION_EAT() == n) {
            return this.actionEat(params);
        }
        if (this.ACTION_COOK() == n) {
            return this.actionCook(params);
        }
        if (this.ACTION_CHOP() == n) {
            return this.actionChop(params);
        }
        if (this.ACTION_SLICE() == n) {
            return this.actionSlice(params);
        }
        if (this.ACTION_DICE() == n) {
            return this.actionDice(params);
        }
        if (this.ACTION_LOOKAROUND() == n) {
            return this.actionLookAround(params);
        }
        if (this.ACTION_MOVE() == n) {
            return this.actionMove(params);
        }
        if (this.ACTION_READ() == n) {
            return this.actionRead(params);
        }
        if (this.ACTION_PREPAREMEAL() == n) {
            return this.actionPrepareMeal(params);
        }
        if (this.ACTION_INVENTORY() == n) {
            return this.actionInventory(params);
        }
        if (this.ACTION_EXAMINE() == n) {
            return this.actionExamine(params);
        }
        if (this.ACTION_OPENDOOR() == n) {
            return this.actionOpenDoor(params);
        }
        if (this.ACTION_CLOSEDOOR() == n) {
            return this.actionCloseDoor(params);
        }
        return "That is not a command that I recognize.";
    }

    public ListBuffer<Tuple3<String, Object, FastObject[]>> mkActions(ListBuffer<FastObject> visibleObjects) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ListBuffer<Tuple3<String, Object, FastObject[]>> actionsOut = new ListBuffer<Tuple3<String, Object, FastObject[]>>();
        actionsOut.append(new Tuple3<String, Integer, Object>("look around", BoxesRunTime.boxToInteger(this.ACTION_LOOKAROUND()), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FastObject.class))));
        actionsOut.append(new Tuple3<String, Integer, Object>("inventory", BoxesRunTime.boxToInteger(this.ACTION_INVENTORY()), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FastObject.class))));
        String string = this.canPrepareMeal();
        String string2 = "";
        Object object5 = !(string != null ? !string.equals(string2) : string2 != null) ? actionsOut.append(new Tuple3<String, Integer, Object>("prepare meal", BoxesRunTime.boxToInteger(this.ACTION_PREPAREMEAL()), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FastObject.class)))) : BoxedUnit.UNIT;
        Object object6 = this.agentLocation().locationNorth() != null ? actionsOut.append(new Tuple3<String, Integer, Object[]>("move north", BoxesRunTime.boxToInteger(this.ACTION_MOVE()), new FastObject[]{this.agentLocation().doorNorth(), this.agentLocation().locationNorth()})) : BoxedUnit.UNIT;
        Object object7 = this.agentLocation().locationSouth() != null ? actionsOut.append(new Tuple3<String, Integer, Object[]>("move south", BoxesRunTime.boxToInteger(this.ACTION_MOVE()), new FastObject[]{this.agentLocation().doorSouth(), this.agentLocation().locationSouth()})) : BoxedUnit.UNIT;
        Object object8 = this.agentLocation().locationEast() != null ? actionsOut.append(new Tuple3<String, Integer, Object[]>("move east", BoxesRunTime.boxToInteger(this.ACTION_MOVE()), new FastObject[]{this.agentLocation().doorEast(), this.agentLocation().locationEast()})) : BoxedUnit.UNIT;
        Object object9 = this.agentLocation().locationWest() != null ? actionsOut.append(new Tuple3<String, Integer, Object[]>("move west", BoxesRunTime.boxToInteger(this.ACTION_MOVE()), new FastObject[]{this.agentLocation().doorWest(), this.agentLocation().locationWest()})) : BoxedUnit.UNIT;
        if (this.agentLocation().doorNorth() != null) {
            actionsOut.append(new Tuple3<String, Integer, Object[]>("open door to north", BoxesRunTime.boxToInteger(this.ACTION_OPENDOOR()), new FastObject[]{this.agentLocation().doorNorth(), this.agentLocation().locationNorth()}));
            object4 = actionsOut.append(new Tuple3<String, Integer, Object[]>("close door to north", BoxesRunTime.boxToInteger(this.ACTION_CLOSEDOOR()), new FastObject[]{this.agentLocation().doorNorth(), this.agentLocation().locationNorth()}));
        } else {
            object4 = BoxedUnit.UNIT;
        }
        if (this.agentLocation().doorSouth() != null) {
            actionsOut.append(new Tuple3<String, Integer, Object[]>("open door to south", BoxesRunTime.boxToInteger(this.ACTION_OPENDOOR()), new FastObject[]{this.agentLocation().doorSouth(), this.agentLocation().locationSouth()}));
            object3 = actionsOut.append(new Tuple3<String, Integer, Object[]>("close door to south", BoxesRunTime.boxToInteger(this.ACTION_CLOSEDOOR()), new FastObject[]{this.agentLocation().doorSouth(), this.agentLocation().locationSouth()}));
        } else {
            object3 = BoxedUnit.UNIT;
        }
        if (this.agentLocation().doorEast() != null) {
            actionsOut.append(new Tuple3<String, Integer, Object[]>("open door to east", BoxesRunTime.boxToInteger(this.ACTION_OPENDOOR()), new FastObject[]{this.agentLocation().doorEast(), this.agentLocation().locationEast()}));
            object2 = actionsOut.append(new Tuple3<String, Integer, Object[]>("close door to east", BoxesRunTime.boxToInteger(this.ACTION_CLOSEDOOR()), new FastObject[]{this.agentLocation().doorEast(), this.agentLocation().locationEast()}));
        } else {
            object2 = BoxedUnit.UNIT;
        }
        if (this.agentLocation().doorWest() != null) {
            actionsOut.append(new Tuple3<String, Integer, Object[]>("open door to west", BoxesRunTime.boxToInteger(this.ACTION_OPENDOOR()), new FastObject[]{this.agentLocation().doorWest(), this.agentLocation().locationWest()}));
            object = actionsOut.append(new Tuple3<String, Integer, Object[]>("close door to west", BoxesRunTime.boxToInteger(this.ACTION_CLOSEDOOR()), new FastObject[]{this.agentLocation().doorWest(), this.agentLocation().locationWest()}));
        } else {
            object = BoxedUnit.UNIT;
        }
        visibleObjects.foreach((Function1<FastObject, Object> & Serializable)obj -> {
            actionsOut.append(new Tuple3<String, Integer, Object[]>(new StringBuilder(8).append("examine ").append(obj.name()).toString(), BoxesRunTime.boxToInteger(this.ACTION_EXAMINE()), new FastObject[]{obj}));
            Object object = obj.isMovable() ? actionsOut.append(new Tuple3<String, Integer, Object[]>(new StringBuilder(5).append("take ").append(obj.name()).toString(), BoxesRunTime.boxToInteger(this.ACTION_TAKE()), new FastObject[]{obj})) : BoxedUnit.UNIT;
            Object object2 = obj.isContainer() && obj.isOpenable() ? (!obj.isOpen() ? actionsOut.append(new Tuple3<String, Integer, Object[]>(new StringBuilder(5).append("open ").append(obj.name()).toString(), BoxesRunTime.boxToInteger(this.ACTION_OPEN()), new FastObject[]{obj})) : actionsOut.append(new Tuple3<String, Integer, Object[]>(new StringBuilder(6).append("close ").append(obj.name()).toString(), BoxesRunTime.boxToInteger(this.ACTION_CLOSE()), new FastObject[]{obj}))) : BoxedUnit.UNIT;
            return obj.isReadable() ? actionsOut.append(new Tuple3<String, Integer, Object[]>(new StringBuilder(5).append("read ").append(obj.name()).toString(), BoxesRunTime.boxToInteger(this.ACTION_READ()), new FastObject[]{obj})) : BoxedUnit.UNIT;
        });
        boolean agentHasKnife = this.agentHasKnife();
        this.agentInventory().contents().foreach((Function1<FastObject, Object> & Serializable)iObj -> {
            Object object;
            actionsOut.append(new Tuple3<String, Integer, Object[]>(new StringBuilder(8).append("examine ").append(iObj.name()).toString(), BoxesRunTime.boxToInteger(this.ACTION_EXAMINE()), new FastObject[]{iObj}));
            visibleObjects.foreach((Function1<FastObject, Object> & Serializable)eObj -> {
                Object object = eObj.isContainer() && eObj.isOpen() ? actionsOut.append(new Tuple3<String, Integer, Object[]>(new StringBuilder(8).append("put ").append(iObj.name()).append(" in ").append(eObj.name()).toString(), BoxesRunTime.boxToInteger(this.ACTION_PUTIN()), new FastObject[]{iObj, eObj})) : BoxedUnit.UNIT;
                return iObj.isCookable() && eObj.isCookingDevice() && !iObj.isFried() && !iObj.isRoasted() && !iObj.isGrilled() ? actionsOut.append(new Tuple3<String, Integer, Object[]>(new StringBuilder(9).append("cook ").append(iObj.name()).append(" in ").append(eObj.name()).toString(), BoxesRunTime.boxToInteger(this.ACTION_COOK()), new FastObject[]{iObj, eObj})) : BoxedUnit.UNIT;
            });
            Object object2 = iObj.isEdible() ? actionsOut.append(new Tuple3<String, Integer, Object[]>(new StringBuilder(4).append("eat ").append(iObj.name()).toString(), BoxesRunTime.boxToInteger(this.ACTION_EAT()), new FastObject[]{iObj})) : BoxedUnit.UNIT;
            if (iObj.isCuttable() && !iObj.isCut() && agentHasKnife) {
                actionsOut.append(new Tuple3<String, Integer, Object[]>(new StringBuilder(5).append("chop ").append(iObj.name()).toString(), BoxesRunTime.boxToInteger(this.ACTION_CHOP()), new FastObject[]{iObj}));
                actionsOut.append(new Tuple3<String, Integer, Object[]>(new StringBuilder(6).append("slice ").append(iObj.name()).toString(), BoxesRunTime.boxToInteger(this.ACTION_SLICE()), new FastObject[]{iObj}));
                object = actionsOut.append(new Tuple3<String, Integer, Object[]>(new StringBuilder(5).append("dice ").append(iObj.name()).toString(), BoxesRunTime.boxToInteger(this.ACTION_DICE()), new FastObject[]{iObj}));
            } else {
                object = BoxedUnit.UNIT;
            }
            return iObj.isReadable() ? actionsOut.append(new Tuple3<String, Integer, Object[]>(new StringBuilder(5).append("read ").append(iObj.name()).toString(), BoxesRunTime.boxToInteger(this.ACTION_READ()), new FastObject[]{iObj})) : BoxedUnit.UNIT;
        });
        return actionsOut;
    }

    @Override
    public StepResult initalStep() {
        return this.step("look around", this.ACTION_LOOKAROUND(), (FastObject[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FastObject.class)));
    }

    @Override
    public StepResult step(String actionStr) {
        Object object = new Object();
        try {
            this.lastValidActions().foreach((Function1<Tuple3, Object> & Serializable)action -> {
                CookingWorldGame.$anonfun$step$1(this, actionStr, object, action);
                return BoxedUnit.UNIT;
            });
            return this.step(actionStr, this.ACTION_INVALID(), (FastObject[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FastObject.class)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (StepResult)ex.value();
        }
    }

    public StepResult step(String actionStr, int actionNumber, FastObject[] actionParams) {
        String observationStr = this.runAction(actionNumber, actionParams);
        boolean wasValidAction = actionNumber != this.ACTION_INVALID();
        this.scorer().doScoring(this.meal());
        GameScore curScores = this.getScore();
        ListBuffer<FastObject> visibleObjects = this.getVisibleObjects();
        ListBuffer<Tuple3<String, Object, FastObject[]>> validActions = this.mkActions(visibleObjects);
        this.lastValidActions_$eq(validActions);
        ObjectRef validActionStrs = ObjectRef.create(new ArrayBuffer(validActions.length()));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), validActions.length()).foreach((Function1<Object, ArrayBuffer> & Serializable)i -> CookingWorldGame.$anonfun$step$2(validActionStrs, validActions, BoxesRunTime.unboxToInt(i)));
        validActionStrs.elem = (ArrayBuffer)this.random().shuffle((ArrayBuffer)validActionStrs.elem, BuildFrom$.MODULE$.buildFromIterableOps());
        String freeLookStr = this.agentLocation().getDescription();
        String inventoryStr = this.actionInventory();
        this.history().append(new ActionHistory(actionStr, observationStr, curScores));
        StepResult result = new StepResult(observationStr, freeLookStr, inventoryStr, (String[])((ArrayBuffer)validActionStrs.elem).toArray(ClassTag$.MODULE$.apply(String.class)), curScores.scoreRaw(), curScores.scoreNormalized(), curScores.taskSuccess(), curScores.taskFailure(), wasValidAction);
        return result;
    }

    public static final /* synthetic */ void $anonfun$agentHasKnife$1(Object nonLocalReturnKey2$1, FastObject obj) {
        String string = obj.name();
        String string2 = "knife";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey2$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$canPrepareMeal$2(FastObject ingredient$1, ObjectRef recipeItem$1, RecipeIngredient r) {
        block0: {
            String string = r.name();
            String string2 = ingredient$1.name();
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            recipeItem$1.elem = r;
        }
    }

    public static final /* synthetic */ void $anonfun$canPrepareMeal$1(CookingWorldGame $this, BooleanRef conditionsMet$1, FastObject ingredient) {
        block4: {
            block3: {
                block2: {
                    if (ingredient.currentContainer() == null) break block2;
                    String string = ingredient.currentContainer().name();
                    String string2 = "inventory";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block3;
                }
                conditionsMet$1.elem = false;
            }
            ObjectRef<Object> recipeItem = ObjectRef.create(null);
            $this.recipe().foreach((Function1<RecipeIngredient, Object> & Serializable)r -> {
                CookingWorldGame.$anonfun$canPrepareMeal$2(ingredient, recipeItem, r);
                return BoxedUnit.UNIT;
            });
            if (ingredient.isPreparedCorrectly(((RecipeIngredient)recipeItem.elem).preparation())) break block4;
            conditionsMet$1.elem = false;
        }
    }

    public static final /* synthetic */ void $anonfun$actionPrepareMeal$1(FastObject ingredient) {
        ingredient.removeFromCurrentContainer();
        ingredient.isDeleted_$eq(true);
    }

    public static final /* synthetic */ void $anonfun$step$1(CookingWorldGame $this, String actionStr$1, Object nonLocalReturnKey3$1, Tuple3 action) {
        Object T1 = action._1();
        String string = actionStr$1;
        if (!(T1 != null ? !T1.equals(string) : string != null)) {
            throw new NonLocalReturnControl<StepResult>(nonLocalReturnKey3$1, $this.step(actionStr$1, BoxesRunTime.unboxToInt(action._2()), (FastObject[])action._3()));
        }
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$step$2(ObjectRef validActionStrs$1, ListBuffer validActions$1, int i) {
        return (ArrayBuffer)((ArrayBuffer)validActionStrs$1.elem).append(((Tuple3)validActions$1.apply(i))._1());
    }

    public CookingWorldGame(Room[] locations, ArrayBuffer<RecipeIngredient> recipe, ArrayBuffer<FastObject> taskObjects, boolean limitInventorySize, long seed, Map<String, Object> generationProperties) {
        this.locations = locations;
        this.recipe = recipe;
        this.taskObjects = taskObjects;
        this.limitInventorySize = limitInventorySize;
        this.seed = seed;
        this.generationProperties = generationProperties;
        this.agentInventory = new FastObject("inventory");
        this.agentLocation = locations[0];
        this.deletedObjects = new ArrayBuffer();
        this.scorer = new CookingWorldGameScoring(recipe, taskObjects);
        this.meal = None$.MODULE$;
        this.lastValidActions = ListBuffer$.MODULE$.empty();
        this.history = new ArrayBuffer();
        this.inventoryMaxCapacity = recipe.length() + 2;
        this.random = new Random(seed);
        this.ACTION_TAKE = 1;
        this.ACTION_PUTIN = 2;
        this.ACTION_OPEN = 3;
        this.ACTION_CLOSE = 4;
        this.ACTION_EAT = 5;
        this.ACTION_COOK = 6;
        this.ACTION_CHOP = 7;
        this.ACTION_SLICE = 8;
        this.ACTION_DICE = 9;
        this.ACTION_LOOKAROUND = 10;
        this.ACTION_MOVE = 11;
        this.ACTION_READ = 12;
        this.ACTION_PREPAREMEAL = 13;
        this.ACTION_INVENTORY = 14;
        this.ACTION_EXAMINE = 15;
        this.ACTION_OPENDOOR = 16;
        this.ACTION_CLOSEDOOR = 17;
        this.ACTION_INVALID = 0;
    }
}

